/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.source.gen.core;

import aurora.ide.api.composite.map.CommentCompositeLoader;
import aurora.ide.helpers.LogUtil;
import aurora.ide.meta.exception.GeneratorException;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.exception.TemplateNotBindedException;
import aurora.ide.meta.gef.FileFinder;
import aurora.ide.meta.gef.editors.models.ILink;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.models.io.ModelIOManager;
import aurora.ide.meta.gef.editors.source.gen.core.DisplayScreenGenerator;
import aurora.ide.meta.gef.editors.source.gen.core.ScreenGenerator;
import aurora.ide.meta.gef.i18n.Messages;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.ide.prototype.freemarker.FMConfigration;
import aurora.ide.prototype.freemarker.FreeMarkerGenerator;
import aurora.ide.search.core.Util;
import aurora.ide.search.ui.MessageFormater;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeMap;

public class ProjectGenerator {
    private IProject project;
    private boolean isOverlap;
    private int fNumberOfFilesToScan;
    private IFile fCurrentFile;
    private int fNumberOfScannedFiles;
    private Shell shell;
    private IProject auroraProject;
    private IFolder screenFolder;
    private IContainer auroraWebFolder;
    private String errorMessage;
    private String header;

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public ProjectGenerator(IProject project, boolean isOverlap, Shell shell) {
        this.project = project;
        this.isOverlap = isOverlap;
        this.shell = shell;
    }

    public boolean isOverlap() {
        return this.isOverlap;
    }

    public void setOverlap(boolean isOverlap) {
        this.isOverlap = isOverlap;
    }

    public void go(final IProgressMonitor monitor) throws InvocationTargetException {
        block14: {
            boolean validate = this.validate();
            if (!validate) {
                throw new InvocationTargetException(new GeneratorException());
            }
            FileFinder fileFinder = new FileFinder();
            try {
                this.project.accept((IResourceVisitor)fileFinder);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            this.header = this.createHeader();
            List<IResource> files = fileFinder.getResult();
            this.fNumberOfFilesToScan = files.size();
            Job monitorUpdateJob = new Job("source generator"){
                private int fLastNumberOfScannedFiles;
                {
                    super($anonymous0);
                    this.fLastNumberOfScannedFiles = 0;
                }

                public IStatus run(IProgressMonitor inner) {
                    while (!inner.isCanceled()) {
                        IFile file = ProjectGenerator.this.fCurrentFile;
                        if (file != null) {
                            this.updateMonitor(monitor, file);
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            return Status.OK_STATUS;
                        }
                    }
                    return Status.OK_STATUS;
                }

                private void updateMonitor(IProgressMonitor monitor2, IFile file) {
                    String fileName = file.getName();
                    Object[] args = new Object[]{fileName, new Integer(ProjectGenerator.this.fNumberOfScannedFiles), new Integer(ProjectGenerator.this.fNumberOfFilesToScan)};
                    monitor2.subTask(MessageFormater.format((String)"Scanning file {1} of {2}: {0}", (Object[])args));
                    int steps = ProjectGenerator.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                    monitor2.worked(steps);
                    this.fLastNumberOfScannedFiles += steps;
                }
            };
            monitor.beginTask(Messages.ProjectGenerator_Gen_source, files.size());
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                if (files == null) break block14;
                int i = 0;
                while (i < files.size()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.fCurrentFile = (IFile)files.get(i);
                    ++this.fNumberOfScannedFiles;
                    try {
                        this.processFile(this.fCurrentFile, monitor);
                    }
                    catch (IOException iOException) {
                        break;
                    }
                    catch (TemplateException e) {
                        LogUtil.getInstance().logError("\u6478\u7248\u683c\u5f0f\u5f02\u5e38\uff0c\u4ee3\u7801\u751f\u6210\u7ec8\u6b62\u3002", (Throwable)e);
                        this.errorMessage = "\u6478\u7248\u683c\u5f0f\u5f02\u5e38\uff0c\u4ee3\u7801\u751f\u6210\u7ec8\u6b62\u3002\u67e5\u770blog\u83b7\u5f97\u8be6\u7ec6\u4fe1\u606f\u3002";
                        throw new InvocationTargetException(new GeneratorException());
                    }
                    catch (TemplateNotBindedException templateNotBindedException) {
                    }
                    catch (SAXException e) {
                        LogUtil.getInstance().logError("\u751f\u6210\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5ffd\u5f8b\u6b64\u6587\u4ef6 : " + this.fCurrentFile.getName(), (Throwable)e);
                    }
                    ++i;
                }
            }
            finally {
                monitorUpdateJob.cancel();
                monitor.done();
            }
        }
    }

    private String createHeader() {
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n";
        String date = DateFormat.getDateInstance().format(new Date());
        String user = System.getProperty("user.name");
        String comment = "<!-- \n  $Author: " + user + " \n  $Date: " + date + " \n" + "  $Revision: 1.0 \n  $add by aurora_ide team.\n-->\n\r ";
        return String.valueOf(s) + comment;
    }

    public boolean validate() {
        this.auroraProject = this.getAuroraProject();
        this.screenFolder = this.getScreenFolder();
        this.auroraWebFolder = this.getAuroraWebFolder();
        if (this.auroraProject == null) {
            this.errorMessage = Messages.ProjectGenerator_Project_error;
            return false;
        }
        if (this.auroraWebFolder == null) {
            this.errorMessage = Messages.ProjectGenerator_web_error;
            return false;
        }
        if (this.screenFolder == null) {
            this.errorMessage = Messages.ProjectGenerator__folder_erroe;
            return false;
        }
        try {
            FMConfigration.Instance().getTemplate("");
        }
        catch (IOException iOException) {
            this.errorMessage = "\u6ca1\u6709\u627e\u5230\u6478\u7248\uff0c\u4ee3\u7801\u751f\u6210\u7ec8\u6b62\u3002";
            return false;
        }
        return true;
    }

    private ViewDiagram loadFile(IFile file) {
        ViewDiagram diagram;
        block12: {
            diagram = null;
            InputStream is = null;
            try {
                try {
                    is = file.getContents(false);
                    CommentCompositeLoader parser = new CommentCompositeLoader();
                    CompositeMap rootMap = parser.loadFromStream(is);
                    ModelIOManager mim = ModelIOManager.getNewInstance();
                    diagram = mim.fromCompositeMap(rootMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (is == null) break block12;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return diagram;
    }

    private void genNewFile(IFile newFile, String content) throws InvocationTargetException {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (is == null) {
            return;
        }
        if (newFile.exists() && this.isOverlap) {
            try {
                newFile.setContents((InputStream)is, true, false, null);
                return;
            }
            catch (CoreException coreException) {
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        CreateFileOperation cfo = new CreateFileOperation(newFile, null, is, "create file."){

            protected void setResourceDescriptions(ResourceDescription[] descriptions) {
                super.setResourceDescriptions(descriptions);
            }

            public IStatus computeExecutionStatus(IProgressMonitor monitor) {
                IStatus status = super.computeExecutionStatus(monitor);
                if (status.isOK()) {
                    status = this.computeCreateStatus(false);
                }
                return status;
            }
        };
        try {
            cfo.execute(null, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.shell));
        }
        catch (ExecutionException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void processFile(IFile fCurrentFile, IProgressMonitor monitor) throws InvocationTargetException, IOException, TemplateException, TemplateNotBindedException, SAXException {
        ScreenGenerator sg = new ScreenGenerator(this.project, fCurrentFile);
        IFile newFile = this.getNewFile(fCurrentFile);
        if (newFile.exists() && !this.isOverlap) {
            return;
        }
        ViewDiagram loadFile = this.loadFile(fCurrentFile);
        CompositeMap screenMap = sg.genCompositeMap(loadFile);
        FreeMarkerGenerator fmg = new FreeMarkerGenerator();
        String genFile = fmg.gen(screenMap);
        this.genNewFile(newFile, genFile);
        this.genRelationFile(sg, 0);
    }

    private void genRelationFile(ScreenGenerator sg, int i) throws InvocationTargetException, TemplateNotBindedException, IOException, TemplateException, SAXException {
        if (i > 10) {
            return;
        }
        ++i;
        List<ILink> links = sg.getLinks();
        for (ILink link : links) {
            Path p;
            String openPath = link.getOpenPath();
            if (openPath == null || "".equals(openPath) || !"uip".equalsIgnoreCase((p = new Path(openPath)).getFileExtension())) continue;
            IFile fCurrentFile = this.screenFolder.getFile((IPath)p);
            openPath = sg.getNewLinkFilePath(openPath);
            p = new Path(openPath);
            IFile newFile = this.getNewFile((IPath)p);
            DisplayScreenGenerator dsg = new DisplayScreenGenerator(this.project, link, newFile);
            dsg.setIdGenerator(sg.getIdGenerator());
            ViewDiagram loadFile = this.loadFile(fCurrentFile);
            if (loadFile == null) continue;
            CompositeMap screenMap = ((ScreenGenerator)dsg).genCompositeMap(loadFile);
            FreeMarkerGenerator fmg = new FreeMarkerGenerator();
            String genFile = fmg.gen(screenMap);
            this.genNewFile(newFile, genFile);
            this.genRelationFile(dsg, i);
        }
    }

    private IProject getAuroraProject() {
        AuroraMetaProject amp = new AuroraMetaProject(this.project);
        try {
            return amp.getAuroraProject();
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    private IFolder getScreenFolder() {
        AuroraMetaProject amp = new AuroraMetaProject(this.project);
        try {
            return amp.getScreenFolder();
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    private IContainer getAuroraWebFolder() {
        IContainer findWebInf = Util.findWebInf((IResource)this.auroraProject);
        return findWebInf == null ? null : findWebInf.getParent();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    private IFile getNewFile(IFile file) {
        IPath makeRelativeTo = file.getProjectRelativePath().makeRelativeTo(this.screenFolder.getProjectRelativePath());
        return this.getNewFile(makeRelativeTo);
    }

    private IFile getNewFile(IPath makeRelativeTo) {
        makeRelativeTo = makeRelativeTo.removeFileExtension();
        makeRelativeTo = makeRelativeTo.addFileExtension("screen");
        return this.auroraWebFolder.getFile(makeRelativeTo);
    }
}

