/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.template.handle;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Button;
import aurora.ide.meta.gef.editors.models.CheckBox;
import aurora.ide.meta.gef.editors.models.FieldSet;
import aurora.ide.meta.gef.editors.models.Form;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.HBox;
import aurora.ide.meta.gef.editors.models.Input;
import aurora.ide.meta.gef.editors.models.Label;
import aurora.ide.meta.gef.editors.models.TabFolder;
import aurora.ide.meta.gef.editors.models.TabItem;
import aurora.ide.meta.gef.editors.models.Toolbar;
import aurora.ide.meta.gef.editors.models.VBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuroraModelFactory {
    private static String[] types = new String[]{"toolbar", "form", "fieldset", "vbox", "hbox", "textfield", "numberfield", "lov", "combobox", "datepicker", "datetimepicker", "checkbox", "grid", "tabpanel", "tab", "button", "tabref", "label"};

    public static boolean isComponent(String type) {
        if (type == null) {
            return false;
        }
        type = type.toLowerCase();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T extends AuroraComponent> T createComponent(String type) {
        if (type == null) {
            return null;
        }
        if ("toolbar".equals(type = type.toLowerCase())) {
            return (T)new Toolbar();
        }
        if ("form".equals(type)) {
            return (T)new Form();
        }
        if ("fieldset".equals(type)) {
            return (T)new FieldSet();
        }
        if ("vbox".equals(type)) {
            return (T)new VBox();
        }
        if ("hbox".equals(type)) {
            return (T)new HBox();
        }
        if ("textfield".equals(type)) {
            Input input = new Input();
            input.setType("textField");
            return (T)input;
        }
        if ("numberfield".equals(type)) {
            Input input = new Input();
            input.setType("numberField");
            return (T)input;
        }
        if ("lov".equals(type)) {
            Input input = new Input();
            input.setType("lov");
            return (T)input;
        }
        if ("combobox".equals(type)) {
            Input input = new Input();
            input.setType("comboBox");
            return (T)input;
        }
        if ("datepicker".equals(type)) {
            Input input = new Input();
            input.setType("datePicker");
            return (T)input;
        }
        if ("datetimepicker".equals(type)) {
            Input input = new Input();
            input.setType("dateTimePicker");
            return (T)input;
        }
        if ("checkbox".equals(type)) {
            return (T)new CheckBox();
        }
        if ("grid".equals(type)) {
            return (T)new Grid();
        }
        if ("tabpanel".equals(type)) {
            return (T)new TabFolder();
        }
        if ("tab".equals(type)) {
            return (T)new TabItem();
        }
        if ("button".equals(type)) {
            return (T)new Button();
        }
        if ("label".equals(type)) {
            return (T)new Label();
        }
        return null;
    }
}

