/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.wizard.dialog;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Button;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.models.link.Parameter;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParameterDialog
extends Dialog {
    private Container[] containers;
    private Parameter para;
    private Parameter _para = new Parameter();
    private Combo containerField;
    private Text valueField;
    private Text nameField;
    private AuroraComponent context;

    public ParameterDialog(Shell parentShell, Container[] containers, Parameter para, AuroraComponent context) {
        super(parentShell);
        this.containers = containers;
        this.para = para;
        this.context = context;
    }

    protected Control createSuperDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ParameterDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)this.createSuperDialogArea(parent);
        Label name = new Label(composite, 0);
        name.setText("Name :");
        this.nameField = new Text(composite, this.getInputTextStyle());
        this.nameField.setLayoutData((Object)new GridData(768));
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterDialog.this._para.setName(ParameterDialog.this.nameField.getText());
            }
        });
        Label value = new Label(composite, 0);
        value.setText("Value :");
        this.valueField = new Text(composite, this.getInputTextStyle());
        this.valueField.setLayoutData((Object)new GridData(768));
        this.valueField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterDialog.this._para.setValue(ParameterDialog.this.valueField.getText());
            }
        });
        ParameterDialog.applyDialogFont((Control)composite);
        this.init();
        return composite;
    }

    private void init() {
        if (this.para != null) {
            this.nameField.setText(this.para.getName() != null ? this.para.getName() : "");
            this.valueField.setText(this.para.getValue() != null ? this.para.getValue() : "");
        }
    }

    public Parameter getParameter() {
        this._para.setContainer(this.findContainer());
        return this._para;
    }

    private Container findContainer() {
        Container findGrid = this.findGrid(this.context);
        if (findGrid != null) {
            return findGrid;
        }
        if (this.context instanceof Button) {
            return this.findForm();
        }
        return null;
    }

    private Container findForm() {
        List<Container> sectionContainers;
        ViewDiagram diagram = this.getDiagram(this.context);
        if (diagram != null && (sectionContainers = diagram.getSectionContainers(diagram, new String[]{"SECTION_TYPE_QUERY"})).size() > 0) {
            return sectionContainers.get(0);
        }
        return null;
    }

    private ViewDiagram getDiagram(AuroraComponent ac) {
        if (ac != null) {
            Container parent = ac.getParent();
            if (parent instanceof ViewDiagram) {
                return (ViewDiagram)parent;
            }
            return this.getDiagram(parent);
        }
        return null;
    }

    private Container findGrid(AuroraComponent ac) {
        if (ac == null) {
            return null;
        }
        Container parent = ac.getParent();
        if (parent instanceof Grid) {
            return parent;
        }
        if (parent != null) {
            return this.findGrid(parent.getParent());
        }
        return null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Parameter");
        shell.setMinimumSize(400, 150);
    }

    protected int getInputTextStyle() {
        return 2052;
    }
}

