/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionExpression
extends AbstractExpression {
    private List<AbstractExpression> children;
    private List<Boolean> commas;
    private List<Boolean> spaces;

    CollectionExpression(AbstractExpression parent, List<AbstractExpression> children, List<Boolean> commas, List<Boolean> spaces) {
        this(parent, children, commas, spaces, false);
    }

    CollectionExpression(AbstractExpression parent, List<AbstractExpression> children, List<Boolean> commas, List<Boolean> spaces, boolean temporary) {
        super(parent);
        this.children = children;
        this.commas = commas;
        this.spaces = spaces;
        if (!temporary) {
            this.updateBackpointers();
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        ListIterator<Expression> iter = this.children();
        while (iter.hasNext()) {
            iter.next().accept(visitor);
        }
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        int childCount = this.children.size();
        for (int index = 0; index < childCount; ++index) {
            this.getChildInternal(index);
        }
        children.addAll(this.children);
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        this.children();
        int count = this.children.size();
        for (int index = 0; index < count; ++index) {
            Expression expression = this.getChild(index);
            children.add((AbstractExpression)expression);
            if (this.hasComma(index)) {
                children.add(this.buildStringExpression(','));
            }
            if (!this.hasSpace(index)) continue;
            children.add(this.buildStringExpression(' '));
        }
    }

    public int childrenSize() {
        this.children();
        return this.children.size();
    }

    public boolean endsWithComma() {
        this.children();
        if (this.children.get(this.children.size() - 1).isNull()) {
            return this.commas.get(this.commas.size() - 2);
        }
        return false;
    }

    public boolean endsWithSpace() {
        this.children();
        if (this.children.get(this.children.size() - 1).isNull()) {
            return this.spaces.get(this.spaces.size() - 2);
        }
        return false;
    }

    @Override
    public JPQLQueryBNF findQueryBNF(AbstractExpression expression) {
        return this.getParent().findQueryBNF(expression);
    }

    public Expression getChild(int index) {
        return this.getChildInternal(index);
    }

    private AbstractExpression getChildInternal(int index) {
        AbstractExpression child = this.children.get(index);
        if (child == null) {
            child = this.buildNullExpression();
            this.children.set(index, child);
        }
        return child;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getParent().getQueryBNF();
    }

    public boolean hasComma(int index) {
        this.children();
        return index < this.commas.size() && this.commas.get(index) != false;
    }

    public boolean hasSpace(int index) {
        this.children();
        return index < this.spaces.size() && (this.spaces.get(index) != false || this.hasComma(index) && index + 1 < this.children.size() && !this.getChildInternal(index + 1).isNull());
    }

    public int indexOf(Expression expression) {
        this.children();
        return this.children.indexOf(expression);
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        throw new IllegalAccessError("This method shouln't be invoked, text=" + wordParser);
    }

    public String toActualText(int endIndex) {
        StringBuilder writer = new StringBuilder();
        this.toParsedText(writer, endIndex, true);
        return writer.toString();
    }

    public String toParsedText(int endIndex) {
        StringBuilder writer = new StringBuilder();
        this.toParsedText(writer, endIndex, false);
        return writer.toString();
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        this.toParsedText(writer, this.childrenSize(), includeVirtual);
    }

    private void toParsedText(StringBuilder writer, int endIndex, boolean includeVirtual) {
        int count = this.children.size();
        for (int index = 0; index < count; ++index) {
            AbstractExpression expression = this.children.get(index);
            if (expression != null) {
                expression.toParsedText(writer, includeVirtual);
            }
            if (this.commas.get(index).booleanValue()) {
                AbstractExpression nextExpression;
                writer.append(',');
                if (this.spaces.get(index).booleanValue()) {
                    writer.append(' ');
                    continue;
                }
                if (index + 1 >= count || (nextExpression = this.children.get(index + 1)) == null || nextExpression.isNull()) continue;
                writer.append(' ');
                continue;
            }
            if (!this.spaces.get(index).booleanValue()) continue;
            writer.append(' ');
        }
    }

    private void updateBackpointers() {
        for (AbstractExpression child : this.children) {
            if (child == null) continue;
            child.setParent(this);
        }
    }
}

