/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectStatement
extends AbstractSelectStatement {
    private boolean hasSpaceBeforeOrderBy;
    private AbstractExpression orderByClause;

    SelectStatement(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        super.acceptChildren(visitor);
        this.getOrderByClause().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        super.addChildrenTo(children);
        if (this.orderByClause != null) {
            children.add(this.orderByClause);
        }
    }

    @Override
    public FromClause addFromClause() {
        return (FromClause)super.addFromClause();
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        super.addOrderedChildrenTo(children);
        if (this.hasSpaceBeforeOrderBy) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.orderByClause != null) {
            children.add(this.orderByClause);
        }
    }

    @Override
    FromClause buildFromClause() {
        return new FromClause(this);
    }

    @Override
    SelectClause buildSelectClause() {
        return new SelectClause(this);
    }

    public Expression getOrderByClause() {
        if (this.orderByClause == null) {
            this.orderByClause = this.buildNullExpression();
        }
        return this.orderByClause;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return SelectStatement.queryBNF("select_statement");
    }

    @Override
    public SelectClause getSelectClause() {
        return (SelectClause)super.getSelectClause();
    }

    public boolean hasOrderByClause() {
        return this.orderByClause != null && !this.orderByClause.isNull();
    }

    public boolean hasSpaceBeforeOrderBy() {
        return this.hasSpaceBeforeOrderBy;
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        super.parse(wordParser, tolerant);
        boolean bl = this.hasSpaceBeforeOrderBy = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("ORDER BY")) {
            this.orderByClause = new OrderByClause(this);
            this.orderByClause.parse(wordParser, tolerant);
        }
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        super.toParsedText(writer, includeVirtual);
        if (this.hasSpaceBeforeOrderBy) {
            writer.append(' ');
        }
        if (this.hasOrderByClause()) {
            this.orderByClause.toParsedText(writer, includeVirtual);
        }
    }
}

