/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaRootElement;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestSourcePage;
import org.eclipse.pde.internal.ui.editor.text.XMLUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;

public class ExtensionAttributePointDectector
implements MouseListener,
KeyListener {
    private ManifestSourcePage fSourcePage = null;
    private StyledText fStyledText = null;
    private ISelection fSelection = null;

    public ISelection getSelection() {
        return this.fSelection;
    }

    public void setTextEditor(ManifestSourcePage editor) {
        this.fSourcePage = editor;
        ISourceViewer viewer = this.fSourcePage.getViewer();
        if (viewer == null) {
            return;
        }
        StyledText newStyledText = viewer.getTextWidget();
        if (this.fStyledText != null && this.fStyledText.equals(newStyledText)) {
            return;
        }
        this.removeListeners();
        this.fStyledText = newStyledText;
        this.addListeners();
        this.checkIfOnTarget();
    }

    private void checkIfOnTarget() {
        this.fSelection = null;
        if (!this.isInputInitialized()) {
            return;
        }
        Point selectionPoint = this.fStyledText.getSelection();
        Region selectionRegion = new Region(selectionPoint.x, selectionPoint.y - selectionPoint.x);
        if (selectionRegion == null || this.fSourcePage == null) {
            return;
        }
        IDocumentRange element = this.fSourcePage.getRangeElement(selectionRegion.getOffset(), true);
        if (!XMLUtil.withinRange(element, selectionRegion.getOffset())) {
            return;
        }
        if (!(element instanceof IDocumentAttributeNode)) {
            return;
        }
        IDocumentAttributeNode documentAttribute = (IDocumentAttributeNode)element;
        String attributeValue = documentAttribute.getAttributeValue();
        if (attributeValue == null || attributeValue.length() == 0) {
            return;
        }
        IPluginObject node = XMLUtil.getTopLevelParent((IDocumentRange)documentAttribute);
        if (node == null || !node.getModel().isEditable()) {
            return;
        }
        if (!(node instanceof IPluginExtension)) {
            return;
        }
        IPluginExtension extension = (IPluginExtension)node;
        ISchemaAttribute schemaAttribute = XMLUtil.getSchemaAttribute(documentAttribute, extension.getPoint());
        if (schemaAttribute == null) {
            return;
        }
        if (!(schemaAttribute.getParent() instanceof SchemaRootElement) || !documentAttribute.getAttributeName().equals("point")) {
            return;
        }
        this.fSelection = new StructuredSelection((Object)extension);
    }

    private void removeListeners() {
        if (!this.isInputInitialized()) {
            return;
        }
        this.fStyledText.removeMouseListener((MouseListener)this);
        this.fStyledText.removeKeyListener((KeyListener)this);
    }

    private boolean isInputInitialized() {
        return this.fStyledText != null && !this.fStyledText.isDisposed();
    }

    private void addListeners() {
        if (!this.isInputInitialized()) {
            return;
        }
        this.fStyledText.addMouseListener((MouseListener)this);
        this.fStyledText.addKeyListener((KeyListener)this);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this.checkIfOnTarget();
    }

    public void keyPressed(KeyEvent e) {
        this.checkIfOnTarget();
    }

    public void keyReleased(KeyEvent e) {
    }
}

