/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value.prefs;

import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.common.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.prefs.PreferencePropertyValueModel;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesCollectionValueModel<P>
extends AspectAdapter<Preferences>
implements CollectionValueModel<PreferencePropertyValueModel<P>> {
    protected final HashMap<String, PreferencePropertyValueModel<P>> preferences = new HashMap();
    protected final PreferenceChangeListener preferenceChangeListener = this.buildPreferenceChangeListener();

    public PreferencesCollectionValueModel(Preferences preferences) {
        this((PropertyValueModel<Preferences>)new StaticPropertyValueModel<Preferences>(preferences));
    }

    public PreferencesCollectionValueModel(PropertyValueModel<? extends Preferences> preferencesHolder) {
        super(preferencesHolder);
    }

    protected PreferenceChangeListener buildPreferenceChangeListener() {
        return new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent event) {
                PreferencesCollectionValueModel.this.preferenceChanged(event.getKey(), event.getNewValue());
            }

            public String toString() {
                return "preference change listener";
            }
        };
    }

    @Override
    public synchronized Iterator<PreferencePropertyValueModel<P>> iterator() {
        return this.preferences.values().iterator();
    }

    @Override
    public synchronized int size() {
        return this.preferences.size();
    }

    @Override
    protected Object getValue() {
        return this.iterator();
    }

    @Override
    protected Class<? extends EventListener> getListenerClass() {
        return CollectionChangeListener.class;
    }

    @Override
    protected String getListenerAspectName() {
        return "values";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("values");
    }

    @Override
    protected void fireAspectChanged(Object oldValue, Object newValue) {
        Iterator iterator = (Iterator)newValue;
        this.fireCollectionChanged("values", CollectionTools.collection(iterator));
    }

    @Override
    protected void engageSubject_() {
        ((Preferences)this.subject).addPreferenceChangeListener(this.preferenceChangeListener);
        Iterator<PreferencePropertyValueModel<P>> stream = this.preferenceModels();
        while (stream.hasNext()) {
            PreferencePropertyValueModel<P> preferenceModel = stream.next();
            this.preferences.put(preferenceModel.getKey(), preferenceModel);
        }
    }

    @Override
    protected void disengageSubject_() {
        block2: {
            try {
                ((Preferences)this.subject).removePreferenceChangeListener(this.preferenceChangeListener);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage().equals("Node has been removed.")) break block2;
                throw ex;
            }
        }
        this.preferences.clear();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.subject);
    }

    protected Iterator<PreferencePropertyValueModel<P>> preferenceModels() {
        String[] keys;
        try {
            keys = ((Preferences)this.subject).keys();
        }
        catch (BackingStoreException ex) {
            throw new RuntimeException(ex);
        }
        return new TransformationIterator<String, PreferencePropertyValueModel<P>>(new ArrayIterator<String>(keys)){

            @Override
            protected PreferencePropertyValueModel<P> transform(String key) {
                return PreferencesCollectionValueModel.this.buildPreferenceModel(key);
            }
        };
    }

    protected PreferencePropertyValueModel<P> buildPreferenceModel(String key) {
        return new PreferencePropertyValueModel(this.subjectHolder, key);
    }

    protected synchronized void preferenceChanged(String key, String newValue) {
        if (newValue == null) {
            PreferencePropertyValueModel<P> preferenceModel = this.preferences.remove(key);
            this.fireItemRemoved("values", preferenceModel);
        } else if (!this.preferences.containsKey(key)) {
            PreferencePropertyValueModel<P> preferenceModel = this.buildPreferenceModel(key);
            this.preferences.put(key, preferenceModel);
            this.fireItemAdded("values", preferenceModel);
        }
    }
}

