/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIExceptionHandler;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UpdateAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.DiscoveryURL;
import org.uddi4j.util.DiscoveryURLs;
import org.uddi4j.util.IdentifierBag;
import org.uddi4j.util.KeyedReference;

public class UpdateBusinessAction
extends UpdateAction {
    private boolean isUpdate_ = true;

    public UpdateBusinessAction(Controller controller) {
        super(controller, true);
    }

    protected boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        boolean isModified;
        boolean isModified2;
        String uuidKey = parser.getParameter("uuidBusinessKey");
        String[] discoveryURLModifiedStates = parser.getParameterValues("discoveryURLModified");
        String[] discoveryURLViewIds = parser.getParameterValues("discoveryURLViewId");
        String[] discoveryURLs = parser.getParameterValues("advancedDiscoveryURL");
        String[] nameModifiedStates = parser.getParameterValues("nameModified");
        String[] nameViewIds = parser.getParameterValues("businessViewId");
        String[] nameLanguages = parser.getParameterValues("advancedNameLanguage");
        String[] names = parser.getParameterValues("advancedName");
        String[] descriptionModifiedStates = parser.getParameterValues("descriptionModified");
        String[] descriptionViewIds = parser.getParameterValues("descriptionViewId");
        String[] descriptionLanguages = parser.getParameterValues("advancedDescriptionLanguage");
        String[] descriptions = parser.getParameterValues("advancedDescription");
        String[] idModifiedStates = parser.getParameterValues("identifierModified");
        String[] idViewIds = parser.getParameterValues("identifierViewId");
        String[] idTypes = parser.getParameterValues("advancedIdentifierType");
        String[] idKeyNames = parser.getParameterValues("advancedIdentifierKeyName");
        String[] idKeyValues = parser.getParameterValues("advancedIdentifierKeyValue");
        String[] catModifiedStates = parser.getParameterValues("categoryModified");
        String[] catViewIds = parser.getParameterValues("categoryViewId");
        String[] catTypes = parser.getParameterValues("advancedCategoryType");
        String[] catKeyNames = parser.getParameterValues("advancedCategoryKeyName");
        String[] catKeyValues = parser.getParameterValues("advancedCategoryKeyValue");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        if (uuidKey != null) {
            this.propertyTable_.put("uuidBusinessKey", uuidKey);
        }
        if (discoveryURLModifiedStates != null && discoveryURLViewIds != null && discoveryURLs != null) {
            Vector oldDiscoveryURLListElementVector = (Vector)formToolPI.getProperty("advancedBusinessDiscoveryURLs");
            Vector<ListElement> newDiscoveryURLListElementVector = new Vector<ListElement>();
            String[] parameters = new String[2];
            parameters[0] = uddiPerspective.getMessage("FORM_LABEL_DISCOVERYURL");
            int i = 0;
            while (i < discoveryURLs.length) {
                parameters[1] = String.valueOf(i + 1);
                DiscoveryURL discoveryURL = new DiscoveryURL(discoveryURLs[i], "");
                if (!Validator.validateURL(discoveryURLs[i])) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedBusinessDiscoveryURLs", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_INVALID_TEXT", parameters));
                }
                int discoveryURLViewId = Integer.parseInt(discoveryURLViewIds[i]);
                isModified2 = Boolean.valueOf(discoveryURLModifiedStates[i]);
                if (discoveryURLViewId == -1 || isModified2) {
                    newDiscoveryURLListElementVector.addElement(new ListElement(discoveryURL));
                } else {
                    newDiscoveryURLListElementVector.addElement((ListElement)oldDiscoveryURLListElementVector.elementAt(discoveryURLViewId));
                }
                ++i;
            }
            this.reindexListElementVector(newDiscoveryURLListElementVector);
            this.propertyTable_.put("advancedBusinessDiscoveryURLs", newDiscoveryURLListElementVector);
        } else {
            this.removeProperty("advancedBusinessDiscoveryURLs");
        }
        Hashtable<String, Boolean> languageHash = new Hashtable<String, Boolean>();
        if (nameModifiedStates != null && nameViewIds != null && nameLanguages != null && names != null) {
            Vector oldNameListElementVector = (Vector)formToolPI.getProperty("advancedBusinessNames");
            Vector<ListElement> newNameListElementVector = new Vector<ListElement>();
            String[] parameters = new String[2];
            parameters[0] = uddiPerspective.getMessage("FORM_LABEL_NAME");
            int i = 0;
            while (i < names.length) {
                Name uddi4jName;
                parameters[1] = String.valueOf(i + 1);
                if (nameLanguages[i].length() > 0) {
                    uddi4jName = new Name(names[i], nameLanguages[i]);
                } else {
                    uddi4jName = new Name(names[i]);
                    if (i != 0) {
                        inputsValid = false;
                        formToolPI.flagRowError((Object)"advancedBusinessNames", i);
                        messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_BLANK_LANGUAGE", parameters));
                    }
                }
                if (languageHash.get(nameLanguages[i]) != null) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedBusinessNames", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_DUPLICATE_LANGUAGE", parameters));
                } else {
                    languageHash.put(nameLanguages[i], Boolean.TRUE);
                }
                if (!Validator.validateString(names[i])) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedBusinessNames", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_INVALID_TEXT", parameters));
                }
                int nameViewId = Integer.parseInt(nameViewIds[i]);
                isModified = Boolean.valueOf(nameModifiedStates[i]);
                if (nameViewId == -1 || isModified) {
                    newNameListElementVector.addElement(new ListElement(uddi4jName));
                } else {
                    newNameListElementVector.addElement((ListElement)oldNameListElementVector.elementAt(nameViewId));
                }
                ++i;
            }
            this.reindexListElementVector(newNameListElementVector);
            this.propertyTable_.put("advancedBusinessNames", newNameListElementVector);
        } else {
            this.removeProperty("advancedBusinessNames");
            inputsValid = false;
            formToolPI.flagError("advancedBusinessNames");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_NO_NAMES"));
        }
        if (descriptionModifiedStates != null && descriptionViewIds != null && descriptionLanguages != null && descriptions != null) {
            Vector oldDescriptionListElementVector = (Vector)formToolPI.getProperty("advancedBusinessDescriptions");
            Vector<ListElement> newDescriptionListElementVector = new Vector<ListElement>();
            String[] parameters = new String[2];
            parameters[0] = uddiPerspective.getMessage("FORM_LABEL_DESCRIPTION");
            languageHash.clear();
            int i = 0;
            while (i < descriptions.length) {
                Description uddi4jDescription;
                parameters[1] = String.valueOf(i + 1);
                if (descriptionLanguages[i].length() > 0) {
                    uddi4jDescription = new Description(descriptions[i], descriptionLanguages[i]);
                } else {
                    uddi4jDescription = new Description(descriptions[i]);
                    if (i != 0) {
                        inputsValid = false;
                        formToolPI.flagRowError((Object)"advancedBusinessDescriptions", i);
                        messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_BLANK_LANGUAGE", parameters));
                    }
                }
                if (languageHash.get(descriptionLanguages[i]) != null) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedBusinessDescriptions", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_DUPLICATE_LANGUAGE", parameters));
                } else {
                    languageHash.put(descriptionLanguages[i], Boolean.TRUE);
                }
                if (!Validator.validateString(descriptions[i])) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedBusinessDescriptions", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_INVALID_TEXT", parameters));
                }
                int descriptionViewId = Integer.parseInt(descriptionViewIds[i]);
                isModified = Boolean.valueOf(descriptionModifiedStates[i]);
                if (descriptionViewId == -1 || isModified) {
                    newDescriptionListElementVector.addElement(new ListElement(uddi4jDescription));
                } else {
                    newDescriptionListElementVector.addElement((ListElement)oldDescriptionListElementVector.elementAt(descriptionViewId));
                }
                ++i;
            }
            this.reindexListElementVector(newDescriptionListElementVector);
            this.propertyTable_.put("advancedBusinessDescriptions", newDescriptionListElementVector);
        } else {
            this.removeProperty("advancedBusinessDescriptions");
        }
        if (idModifiedStates != null && idViewIds != null && idTypes != null && idKeyNames != null && idKeyValues != null) {
            Vector oldIdListElementVector = (Vector)formToolPI.getProperty("advancedBusinessIdentifiers");
            Vector<ListElement> newIdListElementVector = new Vector<ListElement>();
            int i = 0;
            while (i < idKeyNames.length) {
                KeyedReference kr = new KeyedReference(idKeyNames[i], idKeyValues[i], idTypes[i]);
                int idViewId = Integer.parseInt(idViewIds[i]);
                isModified2 = Boolean.valueOf(idModifiedStates[i]);
                if (idViewId == -1 || isModified2) {
                    newIdListElementVector.addElement(new ListElement(kr));
                } else {
                    newIdListElementVector.addElement((ListElement)oldIdListElementVector.elementAt(idViewId));
                }
                ++i;
            }
            this.reindexListElementVector(newIdListElementVector);
            this.propertyTable_.put("advancedBusinessIdentifiers", newIdListElementVector);
        } else {
            this.removeProperty("advancedBusinessIdentifiers");
        }
        if (catModifiedStates != null && catViewIds != null && catTypes != null && catKeyNames != null && catKeyValues != null) {
            Vector oldCatListElementVector = (Vector)formToolPI.getProperty("advancedBusinessCategories");
            Vector<ListElement> newCatListElementVector = new Vector<ListElement>();
            int i = 0;
            while (i < catTypes.length) {
                KeyedReference kr = new KeyedReference(catKeyNames[i], catKeyValues[i], catTypes[i]);
                int catViewId = Integer.parseInt(catViewIds[i]);
                isModified2 = Boolean.valueOf(catModifiedStates[i]);
                if (catViewId == -1 || isModified2) {
                    newCatListElementVector.addElement(new ListElement(kr));
                } else {
                    newCatListElementVector.addElement((ListElement)oldCatListElementVector.elementAt(catViewId));
                }
                ++i;
            }
            this.reindexListElementVector(newCatListElementVector);
            this.propertyTable_.put("advancedBusinessCategories", newCatListElementVector);
        } else {
            this.removeProperty("advancedBusinessCategories");
        }
        return inputsValid;
    }

    public final boolean refreshFromRegistry() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        uddiPerspective.getMessageQueue();
        try {
            String uuidKey = (String)this.propertyTable_.get("uuidBusinessKey");
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            UDDIProxy proxy = regElement.getProxy();
            Vector beVector = proxy.get_businessDetail(uuidKey).getBusinessEntityVector();
            BusinessEntity be = beVector.size() > 0 ? (BusinessEntity)beVector.get(0) : null;
            if (be != null) {
                this.propertyTable_.put("latestObject", be);
                return true;
            }
        }
        catch (TransportException transportException) {
        }
        catch (UDDIException uDDIException) {}
        this.isUpdate_ = false;
        return false;
    }

    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        try {
            BusinessEntity be = (BusinessEntity)this.propertyTable_.get("latestObject");
            String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
            String userId = (String)this.propertyTable_.get("advancedUserId");
            String password = (String)this.propertyTable_.get("advancedPassword");
            Vector discoveryURLListElementVector = (Vector)this.propertyTable_.get("advancedBusinessDiscoveryURLs");
            Vector nameListElementVector = (Vector)this.propertyTable_.get("advancedBusinessNames");
            Vector descriptionListElementVector = (Vector)this.propertyTable_.get("advancedBusinessDescriptions");
            Vector idListElementVector = (Vector)this.propertyTable_.get("advancedBusinessIdentifiers");
            Vector catListElementVector = (Vector)this.propertyTable_.get("advancedBusinessCategories");
            Vector<DiscoveryURL> discoveryURLVector = new Vector<DiscoveryURL>();
            if (discoveryURLListElementVector != null) {
                int i = 0;
                while (i < discoveryURLListElementVector.size()) {
                    ListElement listElement = (ListElement)discoveryURLListElementVector.elementAt(i);
                    DiscoveryURL discoveryURL = (DiscoveryURL)listElement.getObject();
                    discoveryURLVector.addElement(discoveryURL);
                    ++i;
                }
            }
            Vector<Name> nameVector = new Vector<Name>();
            int i = 0;
            while (i < nameListElementVector.size()) {
                ListElement listElement = (ListElement)nameListElementVector.elementAt(i);
                Name name = (Name)listElement.getObject();
                nameVector.addElement(name);
                ++i;
            }
            Vector<Description> descriptionVector = null;
            if (descriptionListElementVector != null) {
                descriptionVector = new Vector<Description>();
                int i2 = 0;
                while (i2 < descriptionListElementVector.size()) {
                    ListElement listElement = (ListElement)descriptionListElementVector.elementAt(i2);
                    Description description = (Description)listElement.getObject();
                    descriptionVector.addElement(description);
                    ++i2;
                }
            }
            IdentifierBag idBag = null;
            if (idListElementVector != null) {
                idBag = new IdentifierBag();
                int i3 = 0;
                while (i3 < idListElementVector.size()) {
                    ListElement listElement = (ListElement)idListElementVector.elementAt(i3);
                    KeyedReference kr = (KeyedReference)listElement.getObject();
                    idBag.add(kr);
                    ++i3;
                }
            }
            CategoryBag catBag = null;
            if (catListElementVector != null) {
                catBag = new CategoryBag();
                int i4 = 0;
                while (i4 < catListElementVector.size()) {
                    ListElement listElement = (ListElement)catListElementVector.elementAt(i4);
                    KeyedReference kr = (KeyedReference)listElement.getObject();
                    catBag.add(kr);
                    ++i4;
                }
            }
            if (discoveryURLVector.size() > 0) {
                be.setDiscoveryURLs(new DiscoveryURLs(discoveryURLVector));
            } else {
                be.setDiscoveryURLs(null);
            }
            be.setNameVector(nameVector);
            be.setDescriptionVector(descriptionVector);
            be.setIdentifierBag(idBag);
            be.setCategoryBag(catBag);
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            if (!regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            UDDIProxy proxy = regElement.getProxy();
            Vector<BusinessEntity> beVector = new Vector<BusinessEntity>();
            beVector.add(be);
            be = (BusinessEntity)proxy.save_business(regElement.getAuthInfoString(), beVector).getBusinessEntityVector().get(0);
            this.refreshNode(be);
            if (this.isUpdate_) {
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_BUSINESS_UPDATED", be.getDefaultNameString()));
            } else {
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_BUSINESS_PUBLISHED", be.getDefaultNameString()));
            }
            return true;
        }
        catch (TransportException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "TransportException", e);
        }
        catch (UDDIException e) {
            if (UDDIExceptionHandler.requiresReset(e)) {
                RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
                regElement.setDefaults();
            }
            messageQueue.addMessage(uddiPerspective.getController().getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (MalformedURLException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "MalformedURLException", e);
        }
        return false;
    }
}

