/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.RegPublishServiceInterfaceSimpleAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIExceptionHandler;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UpdateAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegPublishTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.util.Uddi4jHelper;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;

public class UpdateServiceAction
extends UpdateAction {
    private boolean isUpdate_ = true;

    public UpdateServiceAction(Controller controller) {
        super(controller, true);
    }

    protected boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        boolean isModified;
        int i;
        String[] parameters;
        String uuidBusinessKey = parser.getParameter("uuidBusinessKey");
        String uuidServiceKey = parser.getParameter("uuidServiceKey");
        String wsdlURLModifiedState = parser.getParameter("wsdlURLModified");
        String wsdlURL = parser.getParameter("advancedServiceWSDLURL");
        String[] nameModifiedStates = parser.getParameterValues("nameModified");
        String[] nameViewIds = parser.getParameterValues("businessViewId");
        String[] nameLanguages = parser.getParameterValues("advancedNameLanguage");
        String[] names = parser.getParameterValues("advancedName");
        String[] descriptionModifiedStates = parser.getParameterValues("descriptionModified");
        String[] descriptionViewIds = parser.getParameterValues("descriptionViewId");
        String[] descriptionLanguages = parser.getParameterValues("advancedDescriptionLanguage");
        String[] descriptions = parser.getParameterValues("advancedDescription");
        String[] catModifiedStates = parser.getParameterValues("categoryModified");
        String[] catViewIds = parser.getParameterValues("categoryViewId");
        String[] catTypes = parser.getParameterValues("advancedCategoryType");
        String[] catKeyNames = parser.getParameterValues("advancedCategoryKeyName");
        String[] catKeyValues = parser.getParameterValues("advancedCategoryKeyValue");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        if (uuidBusinessKey != null) {
            this.propertyTable_.put("uuidBusinessKey", uuidBusinessKey);
        }
        if (uuidServiceKey != null) {
            this.propertyTable_.put("uuidServiceKey", uuidServiceKey);
        }
        if (wsdlURLModifiedState != null && wsdlURL != null) {
            ListElement wsdlURLListElement = (ListElement)formToolPI.getProperty("advancedServiceWSDLURL");
            boolean isModified2 = Boolean.valueOf(wsdlURLModifiedState);
            if (isModified2) {
                wsdlURLListElement = new ListElement(wsdlURL);
            } else {
                wsdlURL = (String)wsdlURLListElement.getObject();
            }
            this.propertyTable_.put("advancedServiceWSDLURL", wsdlURLListElement);
            if (!Validator.validateURL(wsdlURL)) {
                inputsValid = false;
                formToolPI.flagError("advancedServiceWSDLURL");
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_WSDL_URL"));
            }
        } else {
            this.removeProperty("advancedServiceWSDLURL");
        }
        Hashtable<String, Boolean> languageHash = new Hashtable<String, Boolean>();
        if (nameModifiedStates != null && nameViewIds != null && nameLanguages != null && names != null) {
            Vector oldNameListElementVector = (Vector)formToolPI.getProperty("advancedServiceNames");
            Vector<ListElement> newNameListElementVector = new Vector<ListElement>();
            parameters = new String[2];
            parameters[0] = uddiPerspective.getMessage("FORM_LABEL_NAME");
            i = 0;
            while (i < names.length) {
                Name uddi4jName;
                parameters[1] = String.valueOf(i + 1);
                if (nameLanguages[i].length() > 0) {
                    uddi4jName = new Name(names[i], nameLanguages[i]);
                } else {
                    uddi4jName = new Name(names[i]);
                    if (i != 0) {
                        inputsValid = false;
                        formToolPI.flagRowError((Object)"advancedServiceNames", i);
                        messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_BLANK_LANGUAGE", parameters));
                    }
                }
                if (languageHash.get(nameLanguages[i]) != null) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedServiceNames", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_DUPLICATE_LANGUAGE", parameters));
                } else {
                    languageHash.put(nameLanguages[i], Boolean.TRUE);
                }
                if (!Validator.validateString(names[i])) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedServiceNames", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_INVALID_TEXT", parameters));
                }
                int nameViewId = Integer.parseInt(nameViewIds[i]);
                isModified = Boolean.valueOf(nameModifiedStates[i]);
                if (nameViewId == -1 || isModified) {
                    newNameListElementVector.addElement(new ListElement(uddi4jName));
                } else {
                    newNameListElementVector.addElement((ListElement)oldNameListElementVector.elementAt(nameViewId));
                }
                ++i;
            }
            this.reindexListElementVector(newNameListElementVector);
            this.propertyTable_.put("advancedServiceNames", newNameListElementVector);
        } else {
            this.removeProperty("advancedServiceNames");
            inputsValid = false;
            formToolPI.flagError("advancedServiceNames");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_NO_NAMES"));
        }
        if (descriptionModifiedStates != null && descriptionViewIds != null && descriptionLanguages != null && descriptions != null) {
            Vector oldDescriptionListElementVector = (Vector)formToolPI.getProperty("advancedServiceDescriptions");
            Vector<ListElement> newDescriptionListElementVector = new Vector<ListElement>();
            parameters = new String[2];
            parameters[0] = uddiPerspective.getMessage("FORM_LABEL_DESCRIPTION");
            languageHash.clear();
            i = 0;
            while (i < descriptions.length) {
                Description uddi4jDescription;
                parameters[1] = String.valueOf(i + 1);
                if (descriptionLanguages[i].length() > 0) {
                    uddi4jDescription = new Description(descriptions[i], descriptionLanguages[i]);
                } else {
                    uddi4jDescription = new Description(descriptions[i]);
                    if (i != 0) {
                        inputsValid = false;
                        formToolPI.flagRowError((Object)"advancedServiceDescriptions", i);
                        messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_BLANK_LANGUAGE", parameters));
                    }
                }
                if (languageHash.get(descriptionLanguages[i]) != null) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedServiceDescriptions", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_DUPLICATE_LANGUAGE", parameters));
                } else {
                    languageHash.put(descriptionLanguages[i], Boolean.TRUE);
                }
                if (!Validator.validateString(descriptions[i])) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedServiceDescriptions", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_INVALID_TEXT", parameters));
                }
                int descriptionViewId = Integer.parseInt(descriptionViewIds[i]);
                isModified = Boolean.valueOf(descriptionModifiedStates[i]);
                if (descriptionViewId == -1 || isModified) {
                    newDescriptionListElementVector.addElement(new ListElement(uddi4jDescription));
                } else {
                    newDescriptionListElementVector.addElement((ListElement)oldDescriptionListElementVector.elementAt(descriptionViewId));
                }
                ++i;
            }
            this.reindexListElementVector(newDescriptionListElementVector);
            this.propertyTable_.put("advancedServiceDescriptions", newDescriptionListElementVector);
        } else {
            this.removeProperty("advancedServiceDescriptions");
        }
        if (catModifiedStates != null && catViewIds != null && catTypes != null && catKeyNames != null && catKeyValues != null) {
            Vector oldCatListElementVector = (Vector)formToolPI.getProperty("advancedServiceCategories");
            Vector<ListElement> newCatListElementVector = new Vector<ListElement>();
            int i2 = 0;
            while (i2 < catTypes.length) {
                KeyedReference kr = new KeyedReference(catKeyNames[i2], catKeyValues[i2], catTypes[i2]);
                int catViewId = Integer.parseInt(catViewIds[i2]);
                boolean isModified3 = Boolean.valueOf(catModifiedStates[i2]);
                if (catViewId == -1 || isModified3) {
                    newCatListElementVector.addElement(new ListElement(kr));
                } else {
                    newCatListElementVector.addElement((ListElement)oldCatListElementVector.elementAt(catViewId));
                }
                ++i2;
            }
            this.reindexListElementVector(newCatListElementVector);
            this.propertyTable_.put("advancedServiceCategories", newCatListElementVector);
        } else {
            this.removeProperty("advancedServiceCategories");
        }
        return inputsValid;
    }

    public final boolean refreshBusinessFromRegistry() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        uddiPerspective.getMessageQueue();
        try {
            String uuidBusinessKey = (String)this.propertyTable_.get("uuidBusinessKey");
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            UDDIProxy proxy = regElement.getProxy();
            Vector beVector = proxy.get_businessDetail(uuidBusinessKey).getBusinessEntityVector();
            BusinessEntity be = beVector.size() > 0 ? (BusinessEntity)beVector.get(0) : null;
            if (be != null) {
                this.propertyTable_.put("latestBusiness", be);
                return true;
            }
        }
        catch (TransportException transportException) {
        }
        catch (UDDIException uDDIException) {}
        return false;
    }

    public final boolean refreshFromRegistry() {
        this.controller_.getUDDIPerspective();
        try {
            String uuidServiceKey = (String)this.propertyTable_.get("uuidServiceKey");
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            UDDIProxy proxy = regElement.getProxy();
            ServiceDetail serviceDetail = proxy.get_serviceDetail(uuidServiceKey);
            Vector businessServiceVector = serviceDetail.getBusinessServiceVector();
            if (businessServiceVector.size() > 0) {
                this.propertyTable_.put("latestObject", businessServiceVector.elementAt(0));
                return true;
            }
        }
        catch (UDDIException uDDIException) {
        }
        catch (TransportException transportException) {}
        this.isUpdate_ = false;
        return false;
    }

    public final RegPublishTool setupRegPublishTool() {
        RegPublishTool regPublishTool = this.regNode_.getRegPublishTool();
        regPublishTool.setProperty("subQueryKey", "");
        regPublishTool.setProperty("queryItem", String.valueOf(1));
        regPublishTool.setProperty("queryStyleServices", String.valueOf(1));
        regPublishTool.setProperty("advancedServiceWSDLURL", this.propertyTable_.get("advancedServiceWSDLURL"));
        Vector nameListElementVector = (Vector)this.propertyTable_.get("advancedServiceNames");
        Vector descriptionListElementVector = (Vector)this.propertyTable_.get("advancedServiceDescriptions");
        Vector catListElementVector = (Vector)this.propertyTable_.get("advancedServiceCategories");
        Vector<Name> nameVector = new Vector<Name>();
        int i = 0;
        while (i < nameListElementVector.size()) {
            ListElement listElement = (ListElement)nameListElementVector.elementAt(i);
            Name name = (Name)listElement.getObject();
            nameVector.addElement(name);
            ++i;
        }
        Vector<Description> descriptionVector = null;
        if (descriptionListElementVector != null) {
            descriptionVector = new Vector<Description>();
            int i2 = 0;
            while (i2 < descriptionListElementVector.size()) {
                ListElement listElement = (ListElement)descriptionListElementVector.elementAt(i2);
                Description description = (Description)listElement.getObject();
                descriptionVector.addElement(description);
                ++i2;
            }
        } else {
            regPublishTool.removeProperty("advancedServiceDescriptions");
        }
        CategoryBag catBag = null;
        if (catListElementVector != null) {
            catBag = new CategoryBag();
            int i3 = 0;
            while (i3 < catListElementVector.size()) {
                ListElement listElement = (ListElement)catListElementVector.elementAt(i3);
                KeyedReference kr = (KeyedReference)listElement.getObject();
                catBag.add(kr);
                ++i3;
            }
        } else {
            regPublishTool.removeProperty("advancedServiceCategories");
        }
        regPublishTool.setProperty("advancedServiceNames", nameVector);
        if (descriptionVector != null) {
            regPublishTool.setProperty("advancedServiceDescriptions", descriptionVector);
        }
        if (catBag != null) {
            regPublishTool.setProperty("advancedServiceCategories", catBag);
        }
        return regPublishTool;
    }

    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        try {
            BusinessEntity be = (BusinessEntity)this.propertyTable_.get("latestBusiness");
            String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
            String userId = (String)this.propertyTable_.get("advancedUserId");
            String password = (String)this.propertyTable_.get("advancedPassword");
            String uuidServiceKey = (String)this.propertyTable_.get("uuidServiceKey");
            ListElement wsdlURLListElement = (ListElement)this.propertyTable_.get("advancedServiceWSDLURL");
            Vector nameListElementVector = (Vector)this.propertyTable_.get("advancedServiceNames");
            Vector descriptionListElementVector = (Vector)this.propertyTable_.get("advancedServiceDescriptions");
            Vector catListElementVector = (Vector)this.propertyTable_.get("advancedServiceCategories");
            String wsdlURL = (String)wsdlURLListElement.getObject();
            Vector<Name> nameVector = new Vector<Name>();
            int i = 0;
            while (i < nameListElementVector.size()) {
                ListElement listElement = (ListElement)nameListElementVector.elementAt(i);
                Name name = (Name)listElement.getObject();
                nameVector.addElement(name);
                ++i;
            }
            Vector<Description> descriptionVector = null;
            if (descriptionListElementVector != null) {
                descriptionVector = new Vector<Description>();
                int i2 = 0;
                while (i2 < descriptionListElementVector.size()) {
                    ListElement listElement = (ListElement)descriptionListElementVector.elementAt(i2);
                    Description description = (Description)listElement.getObject();
                    descriptionVector.addElement(description);
                    ++i2;
                }
            }
            CategoryBag catBag = null;
            if (catListElementVector != null) {
                catBag = new CategoryBag();
                int i3 = 0;
                while (i3 < catListElementVector.size()) {
                    ListElement listElement = (ListElement)catListElementVector.elementAt(i3);
                    KeyedReference kr = (KeyedReference)listElement.getObject();
                    catBag.add(kr);
                    ++i3;
                }
            }
            if (!regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            UDDIProxy proxy = regElement.getProxy();
            Uddi4jHelper uddi4jHelper = new Uddi4jHelper();
            Definition def = uddi4jHelper.getWSDLDefinition(wsdlURL);
            RegPublishServiceInterfaceSimpleAction regPublishSIAction = new RegPublishServiceInterfaceSimpleAction(this.controller_);
            int currentNodeId = this.getSelectedNavigatorNode().getNodeId();
            NodeManager nodeManager = this.regNode_.getNodeManager();
            Hashtable tModelsTable = new Hashtable();
            TModel[] tModels = null;
            if (uddi4jHelper.isMonolithicWSDL(def)) {
                tModels = new TModel[]{uddi4jHelper.newTModel(wsdlURL, def)};
            } else {
                String[] imports = uddi4jHelper.getImports(def, wsdlURL);
                tModels = new TModel[imports.length];
                int i4 = 0;
                while (i4 < tModels.length) {
                    tModels[i4] = uddi4jHelper.newTModel(imports[i4]);
                    ++i4;
                }
            }
            if (tModels != null) {
                int i5 = 0;
                while (i5 < tModels.length) {
                    boolean inputsValid = regPublishSIAction.populatePropertyTable(uddi4jHelper.getWSDL(tModels[i5]), tModels[i5]);
                    if (inputsValid) {
                        regPublishSIAction.run();
                        Object savedTModel = regPublishSIAction.getPropertyTable().get("savedTModel");
                        if (savedTModel != null) {
                            tModelsTable.put(((TModel)savedTModel).getNameString(), savedTModel);
                        }
                        nodeManager.setSelectedNodeId(currentNodeId);
                    }
                    ++i5;
                }
            }
            BusinessService busService = uddi4jHelper.newBusinessService(wsdlURL, def, tModelsTable);
            if (this.isUpdate_) {
                busService.setServiceKey(uuidServiceKey);
            }
            busService.setBusinessKey(be.getBusinessKey());
            busService.setNameVector(nameVector);
            busService.setDescriptionVector(descriptionVector);
            busService.setCategoryBag(catBag);
            regElement.handlePreInvocation(busService);
            Vector<BusinessService> bsVector = new Vector<BusinessService>();
            bsVector.add(busService);
            busService = (BusinessService)proxy.save_service(regElement.getAuthInfoString(), bsVector).getBusinessServiceVector().get(0);
            this.refreshNode(busService);
            if (this.isUpdate_) {
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICE_UPDATED", busService.getDefaultNameString()));
            } else {
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICE_PUBLISHED", busService.getDefaultNameString()));
            }
            return true;
        }
        catch (WSDLException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "WSDLException", e);
        }
        catch (TransportException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "TransportException", e);
        }
        catch (UDDIException e) {
            if (UDDIExceptionHandler.requiresReset(e)) {
                regElement.setDefaults();
            }
            messageQueue.addMessage(uddiPerspective.getController().getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (MalformedURLException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "MalformedURLException", e);
        }
        return false;
    }
}

