/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDGroupChoiceFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDGroupFragment;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XSDGroupChoiceFragment
extends XSDGroupFragment
implements IXSDGroupChoiceFragment {
    private XSDParticle[] choices_ = null;
    private Hashtable choiceIndexes_ = new Hashtable();

    public XSDGroupChoiceFragment(String id, String name, XSDToFragmentConfiguration config, XSDToFragmentController controller, XSDModelGroup xsdModelGroup) {
        super(id, name, config, controller, xsdModelGroup);
    }

    public boolean processParameterValues(MultipartFormDataParser parser) throws MultipartFormDataException {
        super.processParameterValues(parser);
        String[] groupIDs = this.getGroupIDs();
        this.choiceIndexes_.clear();
        boolean paramsValid = true;
        int i = 0;
        while (i < groupIDs.length) {
            String selectedChoiceFragID = parser.getParameter(groupIDs[i]);
            int choiceIndex = 0;
            IXSDFragment[] choiceFrags = this.getGroupMemberFragments(groupIDs[i]);
            int j = 0;
            while (j < choiceFrags.length) {
                if (choiceFrags[j].getID().equals(selectedChoiceFragID)) {
                    choiceIndex = j;
                    paramsValid = paramsValid && choiceFrags[j].validateAllParameterValues();
                    break;
                }
                ++j;
            }
            this.setChoiceIndex(groupIDs[i], choiceIndex);
            ++i;
        }
        return paramsValid;
    }

    public boolean setParameterValuesFromInstanceDocuments(Element[] instanceDocuments) {
        this.removeGroupIDs();
        this.choiceIndexes_.clear();
        boolean paramsValid = true;
        if (instanceDocuments != null) {
            int i = 0;
            while (i < instanceDocuments.length) {
                String groupID = this.createGroupChoiceInstance(0);
                IXSDFragment[] choiceFrags = this.getGroupMemberFragments(groupID);
                int j = 0;
                while (j < choiceFrags.length) {
                    if (choiceFrags[j].getName().equals(this.trimPrefix(instanceDocuments[i].getTagName()))) {
                        XSDToFragmentConfiguration xsdConfig = choiceFrags[j].getXSDToFragmentConfiguration();
                        Element[] childInstances = this.getInstanceDocumentPartition(instanceDocuments, i, xsdConfig.getMinOccurs(), xsdConfig.getMaxOccurs());
                        if (!choiceFrags[j].setParameterValuesFromInstanceDocuments(childInstances)) {
                            paramsValid = false;
                        }
                        this.setChoiceIndex(groupID, j);
                        if (childInstances.length <= 0) break;
                        i = i + childInstances.length - 1;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return paramsValid;
    }

    private Element[] getInstanceDocumentPartition(Element[] instanceDocuments, int start, int minSize, int maxSize) {
        String tagName = instanceDocuments[start].getTagName();
        int size = 1;
        int i = start + 1;
        while (i < instanceDocuments.length) {
            if (!instanceDocuments[i].getTagName().equals(tagName)) break;
            ++size;
            ++i;
        }
        if (maxSize != -1 && size > maxSize && (size -= minSize) > maxSize) {
            size = maxSize;
        }
        Element[] subset = new Element[size];
        int j = 0;
        while (j < subset.length) {
            subset[j] = instanceDocuments[start + j];
            ++j;
        }
        return subset;
    }

    public Element[] genInstanceDocumentsFromParameterValues(boolean genXSIType, Hashtable namespaceTable, Document doc) {
        Vector<Element> instanceDocumentsCopy = new Vector<Element>();
        String[] groupIDs = this.getGroupIDs();
        int i = 0;
        while (i < groupIDs.length) {
            IXSDFragment[] choiceFrags = this.getGroupMemberFragments(groupIDs[i]);
            int choiceIndex = this.getChoiceIndex(groupIDs[i]);
            Element[] choiceFragInstances = choiceFrags[choiceIndex].genInstanceDocumentsFromParameterValues(genXSIType, namespaceTable, doc);
            int j = 0;
            while (j < choiceFragInstances.length) {
                instanceDocumentsCopy.add(choiceFragInstances[j]);
                ++j;
            }
            ++i;
        }
        Object[] instanceDocuments = new Element[instanceDocumentsCopy.size()];
        instanceDocumentsCopy.copyInto(instanceDocuments);
        return instanceDocuments;
    }

    public XSDParticle[] getChoices() {
        if (this.choices_ == null) {
            EList particles = this.getXSDModelGroup().getParticles();
            this.choices_ = new XSDParticle[particles.size()];
            int i = 0;
            while (i < this.choices_.length) {
                this.choices_[i] = (XSDParticle)particles.get(i);
                ++i;
            }
        }
        return this.choices_;
    }

    public String createGroupChoiceInstance(int choiceIndex) {
        this.getChoices();
        if (choiceIndex < 0 || choiceIndex > this.choices_.length - 1) {
            return null;
        }
        String groupID = this.createGroupInstance();
        this.setChoiceIndex(groupID, choiceIndex);
        return groupID;
    }

    public String createInstance() {
        return this.createGroupChoiceInstance(0);
    }

    public int getChoiceIndex(String groupID) {
        Integer index = (Integer)this.choiceIndexes_.get(groupID);
        if (index != null) {
            return index;
        }
        return 0;
    }

    public void setChoiceIndex(String groupID, int choiceIndex) {
        this.choiceIndexes_.put(groupID, new Integer(choiceIndex));
    }

    public boolean validateAllParameterValues() {
        String[] groupIDs = this.getGroupIDs();
        int i = 0;
        while (i < groupIDs.length) {
            int selectionIndex = this.getChoiceIndex(groupIDs[i]);
            if (!this.getGroupMemberFragments(groupIDs[i])[selectionIndex].validateAllParameterValues()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

