/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.importexport.internal.ImportExportActivator;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.AbstractPage;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.ImportPage;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportWizard
extends InstallWizard
implements IImportWizard {
    public ImportWizard() {
        this(ProvisioningUI.getDefaultUI(), null, null, null);
    }

    public ImportWizard(ProvisioningUI ui, InstallOperation operation, Collection<IInstallableUnit> initialSelections, LoadMetadataRepositoryJob preloadJob) {
        super(ui, operation, initialSelections, preloadJob);
        IDialogSettings workbenchSettings = ImportExportActivator.getDefault().getDialogSettings();
        String sectionName = "ImportWizard";
        IDialogSettings section = workbenchSettings.getSection(sectionName);
        if (section == null) {
            section = workbenchSettings.addNewSection(sectionName);
        }
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.ImportWizard_WINDOWTITLE);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport").getEntry("icons/install_wiz.gif")));
        this.setNeedsProgressMonitor(true);
    }

    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        return new ImportPage(this.ui, (ProvisioningOperationWizard)this);
    }

    protected ProvisioningContext getProvisioningContext() {
        return ((ImportPage)this.mainPage).getProvisioningContext();
    }

    public void recomputePlan(IRunnableContext runnableContext) {
        if (((ImportPage)this.mainPage).hasUnloadedRepo()) {
            try {
                runnableContext.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InterruptedException {
                        final SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
                        ((ImportPage)ImportWizard.this.mainPage).recompute((IProgressMonitor)sub.newChild(800));
                        if (sub.isCanceled()) {
                            throw new InterruptedException();
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                ProvisioningContext context = ImportWizard.this.getProvisioningContext();
                                ImportWizard.this.initializeResolutionModelElements(ImportWizard.this.getOperationSelections());
                                if (ImportWizard.this.planSelections.length == 0) {
                                    ImportWizard.this.operation = (ProfileChangeOperation)new InstallOperation(new ProvisioningSession(AbstractPage.agent), new ArrayList()){

                                        protected void computeProfileChangeRequest(MultiStatus status, IProgressMonitor monitor) {
                                            monitor.done();
                                        }

                                        public IStatus getResolutionResult() {
                                            if (sub.isCanceled()) {
                                                return Status.CANCEL_STATUS;
                                            }
                                            return new Status(4, "org.eclipse.equinox.p2.ui.importexport", Messages.ImportWizard_CannotQuerySelection);
                                        }
                                    };
                                } else {
                                    ImportWizard.this.operation = ImportWizard.this.getProfileChangeOperation(ImportWizard.this.planSelections);
                                    ImportWizard.this.operation.setProvisioningContext(context);
                                }
                            }
                        });
                        if (sub.isCanceled()) {
                            throw new InterruptedException();
                        }
                        if (ImportWizard.this.operation.resolveModal((IProgressMonitor)sub.newChild(200)).getSeverity() == 8) {
                            throw new InterruptedException();
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                ImportWizard.this.planChanged();
                            }
                        });
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                this.operation = new InstallOperation(new ProvisioningSession(AbstractPage.agent), new ArrayList()){

                    public IStatus getResolutionResult() {
                        return Status.CANCEL_STATUS;
                    }
                };
            }
            catch (InvocationTargetException e) {
                ProvUI.handleException((Throwable)e.getCause(), null, (int)3);
                this.unableToResolve(null);
            }
        } else {
            super.recomputePlan(runnableContext);
        }
    }

    void unableToResolve(String message) {
        Status couldNotResolveStatus = message != null ? new Status(4, "org.eclipse.equinox.p2.ui.importexport", message, null) : new Status(4, "org.eclipse.equinox.p2.ui.importexport", ProvUIMessages.ProvisioningOperationWizard_UnexpectedFailureToResolve, null);
        StatusManager.getManager().handle((IStatus)couldNotResolveStatus, 1);
    }
}

