/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.db.impl.oracle;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.insightech.er.editor.model.dbimport.DBObject;
import org.insightech.er.editor.model.dbimport.ImportFromDBManagerBase;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.Index;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.Sequence;
import org.insightech.er.editor.model.diagram_contents.not_element.trigger.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTableImportManager
extends ImportFromDBManagerBase {
    private static Logger logger = Logger.getLogger(OracleTableImportManager.class.getName());
    private static final Pattern INTERVAL_YEAR_TO_MONTH_PATTERN = Pattern.compile("interval year\\((.)\\) to month");
    private static final Pattern INTERVAL_DAY_TO_SECCOND_PATTERN = Pattern.compile("interval day\\((.)\\) to second\\((.)\\)");
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("timestamp\\((.)\\).*");

    @Override
    protected void cashColumnData(List<DBObject> dbObjectList, IProgressMonitor monitor) throws SQLException, InterruptedException {
        super.cashColumnData(dbObjectList, monitor);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.prepareStatement("SELECT OWNER, TABLE_NAME, COLUMN_NAME, COMMENTS FROM SYS.ALL_COL_COMMENTS WHERE COMMENTS IS NOT NULL");
            rs = stmt.executeQuery();
            while (rs.next()) {
                ImportFromDBManagerBase.ColumnData columnData;
                String tableName = rs.getString("TABLE_NAME");
                String schema = rs.getString("OWNER");
                String columnName = rs.getString("COLUMN_NAME");
                String comments = rs.getString("COMMENTS");
                Map cash = (Map)this.columnDataCash.get(tableName = this.dbSetting.getTableNameWithSchema(tableName, schema));
                if (cash == null || (columnData = (ImportFromDBManagerBase.ColumnData)cash.get(columnName)) == null) continue;
                columnData.description = comments;
            }
        }
        catch (Throwable throwable) {
            this.close(rs);
            this.close(stmt);
            throw throwable;
        }
        this.close(rs);
        this.close(stmt);
    }

    @Override
    protected void cashTableComment(IProgressMonitor monitor) throws SQLException, InterruptedException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.prepareStatement("SELECT OWNER, TABLE_NAME, COMMENTS FROM SYS.ALL_TAB_COMMENTS WHERE COMMENTS IS NOT NULL");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String schema = rs.getString("OWNER");
                String comments = rs.getString("COMMENTS");
                tableName = this.dbSetting.getTableNameWithSchema(tableName, schema);
                this.tableCommentMap.put(tableName, comments);
            }
        }
        catch (Throwable throwable) {
            this.close(rs);
            this.close(stmt);
            throw throwable;
        }
        this.close(rs);
        this.close(stmt);
    }

    @Override
    protected String getViewDefinitionSQL(String schema) {
        if (schema != null) {
            return "SELECT TEXT FROM ALL_VIEWS WHERE OWNER = ? AND VIEW_NAME = ?";
        }
        return "SELECT TEXT FROM ALL_VIEWS WHERE VIEW_NAME = ?";
    }

    @Override
    protected Sequence importSequence(String schema, String sequenceName) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            Sequence sequence;
            stmt = null;
            rs = null;
            try {
                if (schema != null) {
                    stmt = this.con.prepareStatement("SELECT * FROM SYS.ALL_SEQUENCES WHERE SEQUENCE_OWNER = ? AND SEQUENCE_NAME = ?");
                    stmt.setString(1, schema);
                    stmt.setString(2, sequenceName);
                } else {
                    stmt = this.con.prepareStatement("SELECT * FROM SYS.ALL_SEQUENCES WHERE SEQUENCE_NAME = ?");
                    stmt.setString(1, sequenceName);
                }
                rs = stmt.executeQuery();
                if (!rs.next()) break block6;
                Sequence sequence2 = new Sequence();
                sequence2.setName(sequenceName);
                sequence2.setSchema(schema);
                sequence2.setIncrement(rs.getInt("INCREMENT_BY"));
                BigDecimal minValue = rs.getBigDecimal("MIN_VALUE");
                sequence2.setMinValue(minValue.longValue());
                BigDecimal maxValue = rs.getBigDecimal("MAX_VALUE");
                sequence2.setMaxValue(maxValue);
                BigDecimal lastNumber = rs.getBigDecimal("LAST_NUMBER");
                sequence2.setStart(lastNumber.longValue());
                sequence2.setCache(rs.getInt("CACHE_SIZE"));
                String cycle = rs.getString("CYCLE_FLAG").toLowerCase();
                if ("y".equals(cycle)) {
                    sequence2.setCycle(true);
                } else {
                    sequence2.setCycle(false);
                }
                sequence = sequence2;
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                throw throwable;
            }
            this.close(rs);
            this.close(stmt);
            return sequence;
        }
        this.close(rs);
        this.close(stmt);
        return null;
    }

    @Override
    protected Trigger importTrigger(String schema, String name) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block4: {
            Trigger trigger;
            stmt = null;
            rs = null;
            try {
                if (schema != null) {
                    stmt = this.con.prepareStatement("SELECT * FROM SYS.ALL_TRIGGERS WHERE OWNER = ? AND TRIGGER_NAME = ?");
                    stmt.setString(1, schema);
                    stmt.setString(2, name);
                } else {
                    stmt = this.con.prepareStatement("SELECT * FROM SYS.ALL_TRIGGERS WHERE TRIGGER_NAME = ?");
                    stmt.setString(1, name);
                }
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                Trigger trigger2 = new Trigger();
                trigger2.setName(name);
                trigger2.setSchema(schema);
                trigger2.setDescription(rs.getString("DESCRIPTION"));
                trigger2.setSql(rs.getString("TRIGGER_BODY"));
                trigger = trigger2;
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                throw throwable;
            }
            this.close(rs);
            this.close(stmt);
            return trigger;
        }
        this.close(rs);
        this.close(stmt);
        return null;
    }

    public static boolean isValidObjectName(String s) {
        return s.matches("([a-zA-Z]{1}\\w*(\\$|\\#)*\\w*)|(\".*)");
    }

    @Override
    protected List<Index> getIndexes(ERTable table, DatabaseMetaData metaData, List<ImportFromDBManagerBase.PrimaryKeyData> primaryKeys) throws SQLException {
        if (!OracleTableImportManager.isValidObjectName(table.getPhysicalName())) {
            logger.info("is not valid object name : " + table.getPhysicalName());
            return new ArrayList<Index>();
        }
        try {
            return super.getIndexes(table, metaData, primaryKeys);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 38029) {
                logger.info(String.valueOf(table.getPhysicalName()) + " : " + e.getMessage());
                return new ArrayList<Index>();
            }
            throw e;
        }
    }

    @Override
    protected int getLength(String type, int size) {
        int endIndex;
        int startIndex = type.indexOf("(");
        if (startIndex > 0 && (endIndex = type.indexOf(")", startIndex + 1)) != -1) {
            String str = type.substring(startIndex + 1, endIndex);
            return Integer.parseInt(str);
        }
        return size;
    }

    @Override
    protected List<ERTable> importSynonyms() throws SQLException, InterruptedException {
        ArrayList<ERTable> list = new ArrayList<ERTable>();
        return list;
    }

    @Override
    protected ImportFromDBManagerBase.ColumnData createColumnData(ResultSet columnSet) throws SQLException {
        ImportFromDBManagerBase.ColumnData columnData = super.createColumnData(columnSet);
        String type = columnData.type.toLowerCase();
        if (type.equals("number")) {
            if (columnData.size == 22 && columnData.decimalDegits == 0) {
                columnData.size = 0;
            }
        } else if (type.equals("float")) {
            if (columnData.size == 126 && columnData.decimalDegits == 0) {
                columnData.size = 0;
            }
        } else if (type.equals("urowid")) {
            if (columnData.size == 4000) {
                columnData.size = 0;
            }
        } else if (type.equals("anydata")) {
            columnData.size = 0;
        } else {
            Matcher yearToMonthMatcber = INTERVAL_YEAR_TO_MONTH_PATTERN.matcher(columnData.type);
            Matcher dayToSecondMatcber = INTERVAL_DAY_TO_SECCOND_PATTERN.matcher(columnData.type);
            Matcher timestampMatcber = TIMESTAMP_PATTERN.matcher(columnData.type);
            if (yearToMonthMatcber.matches()) {
                columnData.type = "interval year to month";
                if (columnData.size == 2) {
                    columnData.size = 0;
                }
            } else if (dayToSecondMatcber.matches()) {
                columnData.type = "interval day to second";
                if (columnData.size == 2 && columnData.decimalDegits == 6) {
                    columnData.size = 0;
                    columnData.decimalDegits = 0;
                }
            } else if (timestampMatcber.matches()) {
                columnData.type = columnData.type.replaceAll("\\(.\\)", "");
                columnData.size = 0;
                columnData.size = columnData.decimalDegits == 6 ? 0 : columnData.decimalDegits;
                columnData.decimalDegits = 0;
            }
        }
        return columnData;
    }
}

