/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.model.settings.TranslationSetting;
import org.insightech.er.preference.PreferenceInitializer;

public class TranslationResources {
    private Map<String, String> translationMap = new TreeMap<String, String>(new TranslationResourcesComparator());

    public TranslationResources(TranslationSetting translationSettings) {
        String defaultFileName = ResourceString.getResourceString("label.translation.default");
        if (translationSettings.isUse()) {
            for (String translation : PreferenceInitializer.getAllUserTranslations()) {
                File file;
                if (!translationSettings.isSelected(translation) || !(file = new File(PreferenceInitializer.getTranslationPath(translation))).exists()) continue;
                FileInputStream in = null;
                try {
                    try {
                        in = new FileInputStream(file);
                        this.load(in);
                    }
                    catch (IOException e) {
                        Activator.showExceptionDialog(e);
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            Activator.showExceptionDialog(e2);
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            Activator.showExceptionDialog(e);
                        }
                    }
                    throw throwable;
                }
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {
                    Activator.showExceptionDialog(e);
                }
            }
            if (translationSettings.isSelected(defaultFileName)) {
                InputStream in = this.getClass().getResourceAsStream("/translation.txt");
                try {
                    try {
                        this.load(in);
                    }
                    catch (IOException e) {
                        Activator.showExceptionDialog(e);
                        try {
                            in.close();
                        }
                        catch (IOException e3) {
                            Activator.showExceptionDialog(e3);
                        }
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        Activator.showExceptionDialog(e);
                    }
                }
            }
        }
    }

    private void load(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String key;
            int index = line.indexOf(",");
            if (index == -1 || index == line.length() - 1 || "".equals(key = line.substring(0, index).trim())) continue;
            String value = line.substring(index + 1).trim();
            this.translationMap.put(key, value);
            key = key.replaceAll("[aiueo]", "");
            if (key.length() <= 1) continue;
            this.translationMap.put(key, value);
        }
    }

    public String translate(String str) {
        for (Map.Entry<String, String> entry : this.translationMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Pattern p = Pattern.compile("_*" + Pattern.quote(key) + "_*", 2);
            Matcher m = p.matcher(str);
            str = m.replaceAll(value);
        }
        return str;
    }

    public boolean contains(String key) {
        return this.translationMap.containsKey(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TranslationResourcesComparator
    implements Comparator<String> {
        private TranslationResourcesComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int diff = o2.length() - o1.length();
            if (diff != 0) {
                return diff;
            }
            return o1.replace('_', ' ').compareTo(o2.replace('_', ' '));
        }
    }
}

