/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.command.diagram_contents.element.connection.relation;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.insightech.er.editor.controller.command.diagram_contents.element.connection.relation.AbstractCreateRelationCommand;
import org.insightech.er.editor.controller.editpart.element.ERDiagramEditPart;
import org.insightech.er.editor.controller.editpart.element.node.TableViewEditPart;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.Location;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;

public class CreateRelatedTableCommand
extends AbstractCreateRelationCommand {
    private Relation relation1;
    private Relation relation2;
    private ERTable relatedTable = new ERTable();
    private ERDiagram diagram;
    private int sourceX;
    private int sourceY;
    private int targetX;
    private int targetY;

    public void setSourcePoint(int x, int y) {
        this.sourceX = x;
        this.sourceY = y;
    }

    private void setTargetPoint(int x, int y) {
        this.targetX = x;
        this.targetY = y;
    }

    public void setTarget(EditPart target) {
        super.setTarget(target);
        if (target != null && target instanceof TableViewEditPart) {
            TableViewEditPart tableEditPart = (TableViewEditPart)target;
            Point point = tableEditPart.getFigure().getBounds().getCenter();
            this.setTargetPoint(point.x, point.y);
        }
    }

    protected void doExecute() {
        ERDiagramEditPart.setUpdateable(false);
        this.init();
        this.diagram.addNewContent(this.relatedTable);
        this.relation1.setSource((ERTable)this.source.getModel());
        this.relation1.setTargetTableView(this.relatedTable);
        this.relation2.setSource((ERTable)this.target.getModel());
        this.relation2.setTargetTableView(this.relatedTable);
        ERDiagramEditPart.setUpdateable(true);
        this.diagram.getDiagramContents().getContents().getTableSet().setDirty();
    }

    protected void doUndo() {
        ERDiagramEditPart.setUpdateable(false);
        this.diagram.removeContent(this.relatedTable);
        this.relation1.setSource(null);
        this.relation1.setTargetTableView(null);
        this.relation2.setSource(null);
        this.relation2.setTargetTableView(null);
        ERDiagramEditPart.setUpdateable(true);
        this.diagram.getDiagramContents().getContents().getTableSet().setDirty();
    }

    private void init() {
        ERTable sourceTable = (ERTable)this.getSourceModel();
        this.diagram = sourceTable.getDiagram();
        this.relation1 = sourceTable.createRelation();
        ERTable targetTable = (ERTable)this.getTargetModel();
        this.relation2 = targetTable.createRelation();
        this.relatedTable.setLocation(new Location((this.sourceX + this.targetX - 120) / 2, (this.sourceY + this.targetY - 75) / 2, 120, 75));
        this.relatedTable.setLogicalName(ERTable.NEW_LOGICAL_NAME);
        this.relatedTable.setPhysicalName(ERTable.NEW_PHYSICAL_NAME);
    }

    public boolean canExecute() {
        if (!super.canExecute()) {
            return false;
        }
        return this.getSourceModel() instanceof ERTable && this.getTargetModel() instanceof ERTable;
    }
}

