/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.element.node;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.editor.controller.command.common.ChangeModelPropertiesCommand;
import org.insightech.er.editor.controller.editpart.element.node.IResizable;
import org.insightech.er.editor.controller.editpart.element.node.NodeElementEditPart;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.model_properties.ModelProperties;
import org.insightech.er.editor.model.settings.Settings;
import org.insightech.er.editor.view.dialog.element.ModelPropertiesDialog;
import org.insightech.er.editor.view.figure.ModelPropertiesFigure;

public class ModelPropertiesEditPart
extends NodeElementEditPart
implements IResizable {
    protected IFigure createFigure() {
        ERDiagram diagram = this.getDiagram();
        Settings settings = diagram.getDiagramContents().getSettings();
        ModelPropertiesFigure figure = new ModelPropertiesFigure();
        this.changeFont((IFigure)figure);
        figure.setVisible(settings.getModelProperties().isDisplay());
        return figure;
    }

    public void doPropertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("model_properties")) {
            this.refreshVisuals();
        }
        super.doPropertyChange(event);
    }

    public void refreshVisuals() {
        ERDiagram diagram = this.getDiagram();
        ModelProperties modelProperties = (ModelProperties)this.getModel();
        ModelPropertiesFigure figure = (ModelPropertiesFigure)this.getFigure();
        figure.setData(modelProperties.getProperties(), modelProperties.getCreationDate(), modelProperties.getUpdatedDate(), diagram.getDiagramContents().getSettings().getTableStyle(), modelProperties.getColor());
        super.refreshVisuals();
    }

    public void changeSettings(Settings settings) {
        this.figure.setVisible(settings.getModelProperties().isDisplay());
        super.changeSettings(settings);
    }

    protected void setVisible() {
        ERDiagram diagram = this.getDiagram();
        Settings settings = diagram.getDiagramContents().getSettings();
        this.figure.setVisible(settings.getModelProperties().isDisplay());
    }

    public void performRequestOpen() {
        ERDiagram diagram = this.getDiagram();
        ModelProperties copyModelProperties = diagram.getDiagramContents().getSettings().getModelProperties().clone();
        ModelPropertiesDialog dialog = new ModelPropertiesDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), copyModelProperties);
        if (dialog.open() == 0) {
            ChangeModelPropertiesCommand command = new ChangeModelPropertiesCommand(diagram, copyModelProperties);
            this.executeCommand(command);
        }
    }

    public boolean isDeleteable() {
        return false;
    }
}

