/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.outline.view;

import java.beans.PropertyChangeEvent;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.editor.controller.editpart.DeleteableEditPart;
import org.insightech.er.editor.controller.editpart.element.node.ViewEditPart;
import org.insightech.er.editor.controller.editpart.outline.AbstractOutlineEditPart;
import org.insightech.er.editor.controller.editpolicy.element.node.NodeElementComponentEditPolicy;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.view.View;
import org.insightech.er.editor.view.dialog.element.view.ViewDialog;

public class ViewOutlineEditPart
extends AbstractOutlineEditPart
implements DeleteableEditPart {
    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected void refreshOutlineVisuals() {
        this.refreshName();
        for (Object child : this.getChildren()) {
            EditPart part = (EditPart)child;
            part.refresh();
        }
    }

    public void performRequest(Request request) {
        View view = (View)this.getModel();
        ERDiagram diagram = (ERDiagram)this.getRoot().getContents().getModel();
        if (request.getType().equals("open")) {
            View copyView = view.copyData();
            ViewDialog dialog = new ViewDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getViewer(), copyView, diagram.getDiagramContents().getGroups());
            if (dialog.open() == 0) {
                CompoundCommand command = ViewEditPart.createChangeViewPropertyCommand(diagram, view, copyView);
                this.execute(command.unwrap());
            }
        }
        super.performRequest(request);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NodeElementComponentEditPolicy());
    }

    public DragTracker getDragTracker(Request req) {
        return new SelectEditPartTracker((EditPart)this);
    }

    public boolean isDeleteable() {
        return true;
    }

    protected void refreshName() {
        View model = (View)this.getModel();
        ERDiagram diagram = (ERDiagram)this.getRoot().getContents().getModel();
        String name = null;
        int viewMode = diagram.getDiagramContents().getSettings().getOutlineViewMode();
        if (viewMode == 1) {
            name = model.getPhysicalName() != null ? model.getPhysicalName() : "";
        } else if (viewMode == 0) {
            name = model.getLogicalName() != null ? model.getLogicalName() : "";
        } else {
            name = model.getLogicalName() != null ? model.getLogicalName() : "";
            name = String.valueOf(name) + "/";
            if (model.getPhysicalName() != null) {
                name = String.valueOf(name) + model.getPhysicalName();
            }
        }
        this.setWidgetText(diagram.filter(name));
        this.setWidgetImage(Activator.getImage("VIEW"));
    }
}

