/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.excel.sheet_generator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.ObjectModel;
import org.insightech.er.editor.model.dbexport.excel.ExportToExcelManager;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.table.TableView;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.util.POIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSheetGenerator {
    private static final int MAX_SHEET_NAME_LENGTH = 26;
    protected static final String KEYWORD_ORDER = "$ORD";
    protected static final String KEYWORD_LOGICAL_TABLE_NAME = "$LTN";
    protected static final String KEYWORD_PHYSICAL_TABLE_NAME = "$PTN";
    protected static final String KEYWORD_LOGICAL_COLUMN_NAME = "$LCN";
    protected static final String KEYWORD_PHYSICAL_COLUMN_NAME = "$PCN";
    protected static final String KEYWORD_TYPE = "$TYP";
    protected static final String KEYWORD_LENGTH = "$LEN";
    protected static final String KEYWORD_DECIMAL = "$DEC";
    protected static final String KEYWORD_PRIMARY_KEY = "$PK";
    protected static final String KEYWORD_NOT_NULL = "$NN";
    protected static final String KEYWORD_UNIQUE_KEY = "$UK";
    protected static final String KEYWORD_FOREIGN_KEY = "$FK";
    protected static final String KEYWORD_LOGICAL_REFERENCE_TABLE_KEY = "$LRFTC";
    protected static final String KEYWORD_PHYSICAL_REFERENCE_TABLE_KEY = "$PRFTC";
    protected static final String KEYWORD_LOGICAL_REFERENCE_TABLE = "$LRFT";
    protected static final String KEYWORD_PHYSICAL_REFERENCE_TABLE = "$PRFT";
    protected static final String KEYWORD_LOGICAL_REFERENCE_KEY = "$LRFC";
    protected static final String KEYWORD_PHYSICAL_REFERENCE_KEY = "$PRFC";
    protected static final String KEYWORD_AUTO_INCREMENT = "$INC";
    protected static final String KEYWORD_DESCRIPTION = "$CDSC";
    protected static final String KEYWORD_DEFAULT_VALUE = "$DEF";
    protected static final String KEYWORD_LOGICAL_FOREIGN_KEY_NAME = "$LFKN";
    protected static final String KEYWORD_PHYSICAL_FOREIGN_KEY_NAME = "$PFKN";
    protected static final String KEYWORD_TABLE_DESCRIPTION = "$TDSC";
    private static final String[] KEYWORDS_OF_COLUMN = new String[]{"$ORD", "$LTN", "$PTN", "$LCN", "$PCN", "$TYP", "$LEN", "$DEC", "$PK", "$NN", "$UK", "$FK", "$LRFTC", "$PRFTC", "$LRFT", "$PRFT", "$LRFC", "$PRFC", "$INC", "$DEF", "$CDSC", "$LFKN", "$PFKN"};
    protected static final String[] FIND_KEYWORDS_OF_COLUMN = new String[]{"$LCN", "$PCN"};
    protected Map<String, String> keywordsValueMap;

    protected Map<String, String> buildKeywordsValueMap(HSSFSheet wordsSheet, int columnNo, String[] keywords) {
        HashMap<String, String> keywordsValueMap = new HashMap<String, String>();
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            HSSFRow row;
            HSSFCell cell;
            String value;
            String keyword = stringArray[n2];
            POIUtils.CellLocation location = POIUtils.findCell(wordsSheet, keyword, columnNo);
            if (location != null && (value = (cell = (row = wordsSheet.getRow(location.r)).getCell(location.c + 2)).getRichStringCellValue().getString()) != null) {
                keywordsValueMap.put(keyword, value);
            }
            ++n2;
        }
        return keywordsValueMap;
    }

    protected String getValue(Map<String, String> keywordsValueMap, String keyword, Object obj) {
        if (obj instanceof Boolean) {
            if (Boolean.TRUE.equals(obj)) {
                String value = keywordsValueMap.get(keyword);
                if (value != null && !"".equals(value)) {
                    return value;
                }
            } else {
                return "";
            }
        }
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    protected void setColumnData(Map<String, String> keywordsValueMap, ColumnTemplate columnTemplate, HSSFRow row, NormalColumn normalColumn, TableView tableView, int order) {
        for (int columnNum : columnTemplate.columnTemplateMap.keySet()) {
            HSSFCell cell = row.createCell(columnNum);
            String template = columnTemplate.columnTemplateMap.get(columnNum);
            String value = null;
            value = KEYWORD_ORDER.equals(template) ? String.valueOf(order) : this.getColumnValue(keywordsValueMap, normalColumn, tableView, template);
            try {
                double num = Double.parseDouble(value);
                cell.setCellValue(num);
            }
            catch (NumberFormatException numberFormatException) {
                HSSFRichTextString text = new HSSFRichTextString(value);
                cell.setCellValue((RichTextString)text);
            }
        }
    }

    private String getColumnValue(Map<String, String> keywordsValueMap, NormalColumn normalColumn, TableView tableView, String template) {
        String str = template;
        String[] stringArray = KEYWORDS_OF_COLUMN;
        int n = KEYWORDS_OF_COLUMN.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            str = str.replaceAll("\\" + keyword, this.getKeywordValue(keywordsValueMap, normalColumn, tableView, keyword));
            ++n2;
        }
        return str;
    }

    private String getKeywordValue(Map<String, String> keywordsValueMap, NormalColumn normalColumn, TableView tableView, String keyword) {
        Object obj = null;
        if (KEYWORD_LOGICAL_TABLE_NAME.equals(keyword)) {
            obj = tableView.getLogicalName();
        } else if (KEYWORD_PHYSICAL_TABLE_NAME.equals(keyword)) {
            obj = tableView.getPhysicalName();
        } else if (KEYWORD_LOGICAL_COLUMN_NAME.equals(keyword)) {
            obj = normalColumn.getLogicalName();
        } else if (KEYWORD_PHYSICAL_COLUMN_NAME.equals(keyword)) {
            obj = normalColumn.getPhysicalName();
        } else if (KEYWORD_TYPE.equals(keyword)) {
            obj = normalColumn.getType() == null ? null : normalColumn.getType().getAlias(tableView.getDiagram().getDatabase());
        } else if (KEYWORD_LENGTH.equals(keyword)) {
            obj = normalColumn.getTypeData().getLength();
        } else if (KEYWORD_DECIMAL.equals(keyword)) {
            obj = normalColumn.getTypeData().getDecimal();
        } else if (KEYWORD_PRIMARY_KEY.equals(keyword)) {
            obj = normalColumn.isPrimaryKey();
        } else if (KEYWORD_NOT_NULL.equals(keyword)) {
            obj = normalColumn.isNotNull();
        } else if (KEYWORD_FOREIGN_KEY.equals(keyword)) {
            List<Relation> relationList = normalColumn.getRelationList();
            obj = relationList == null || relationList.isEmpty() ? Boolean.valueOf(false) : Boolean.valueOf(true);
        } else if (KEYWORD_LOGICAL_REFERENCE_TABLE_KEY.equals(keyword)) {
            List<Relation> relationList = normalColumn.getRelationList();
            if (relationList == null || relationList.isEmpty()) {
                obj = null;
            } else {
                Relation relation = relationList.get(0);
                TableView referencedTable = relation.getSourceTableView();
                obj = String.valueOf(referencedTable.getLogicalName()) + "." + normalColumn.getReferencedColumn(relation).getLogicalName();
            }
        } else if (KEYWORD_PHYSICAL_REFERENCE_TABLE_KEY.equals(keyword)) {
            List<Relation> relationList = normalColumn.getRelationList();
            if (relationList == null || relationList.isEmpty()) {
                obj = null;
            } else {
                Relation relation = relationList.get(0);
                TableView referencedTable = relation.getSourceTableView();
                obj = String.valueOf(referencedTable.getPhysicalName()) + "." + normalColumn.getReferencedColumn(relation).getPhysicalName();
            }
        } else if (KEYWORD_LOGICAL_REFERENCE_TABLE.equals(keyword)) {
            List<Relation> relationList = normalColumn.getRelationList();
            if (relationList == null || relationList.isEmpty()) {
                obj = null;
            } else {
                TableView referencedTable = relationList.get(0).getSourceTableView();
                obj = referencedTable.getLogicalName();
            }
        } else if (KEYWORD_PHYSICAL_REFERENCE_TABLE.equals(keyword)) {
            List<Relation> relationList = normalColumn.getRelationList();
            if (relationList == null || relationList.isEmpty()) {
                obj = null;
            } else {
                TableView referencedTable = relationList.get(0).getSourceTableView();
                obj = referencedTable.getPhysicalName();
            }
        } else if (KEYWORD_LOGICAL_REFERENCE_KEY.equals(keyword)) {
            List<Relation> relationList = normalColumn.getRelationList();
            if (relationList == null || relationList.isEmpty()) {
                obj = null;
            } else {
                Relation relation = relationList.get(0);
                obj = normalColumn.getReferencedColumn(relation).getLogicalName();
            }
        } else if (KEYWORD_PHYSICAL_REFERENCE_KEY.equals(keyword)) {
            List<Relation> relationList = normalColumn.getRelationList();
            if (relationList == null || relationList.isEmpty()) {
                obj = null;
            } else {
                Relation relation = relationList.get(0);
                obj = normalColumn.getReferencedColumn(relation).getPhysicalName();
            }
        } else if (KEYWORD_LOGICAL_FOREIGN_KEY_NAME.equals(keyword)) {
            obj = normalColumn.getLogicalName();
        } else if (KEYWORD_PHYSICAL_FOREIGN_KEY_NAME.equals(keyword)) {
            obj = normalColumn.getPhysicalName();
        } else if (KEYWORD_UNIQUE_KEY.equals(keyword)) {
            obj = normalColumn.isUniqueKey();
        } else if (KEYWORD_DESCRIPTION.equals(keyword)) {
            obj = normalColumn.getDescription();
        } else if (KEYWORD_DEFAULT_VALUE.equals(keyword)) {
            obj = normalColumn.getDefaultValue();
        } else if (KEYWORD_AUTO_INCREMENT.equals(keyword)) {
            obj = normalColumn.isAutoIncrement();
        }
        return this.getValue(keywordsValueMap, keyword, obj);
    }

    protected ColumnTemplate loadColumnTemplate(HSSFWorkbook workbook, HSSFSheet templateSheet, POIUtils.CellLocation location) {
        if (location == null) {
            return null;
        }
        ColumnTemplate columnTemplate = new ColumnTemplate();
        HSSFRow row = templateSheet.getRow(location.r);
        HSSFRow bottomRow = templateSheet.getRow(location.r + 1);
        int colNum = row.getFirstCellNum();
        while (colNum <= row.getLastCellNum()) {
            HSSFCell cell = row.getCell(colNum);
            if (cell != null) {
                columnTemplate.columnTemplateMap.put(colNum, cell.getRichStringCellValue().getString());
            }
            ++colNum;
        }
        columnTemplate.topRowCellStyleList = POIUtils.copyCellStyle(workbook, row);
        columnTemplate.middleRowCellStyleList = POIUtils.copyCellStyle(workbook, row);
        columnTemplate.bottomRowCellStyleList = POIUtils.copyCellStyle(workbook, row);
        int i = 0;
        while (i < columnTemplate.middleRowCellStyleList.size()) {
            HSSFCellStyle middleRowCellStyle = columnTemplate.middleRowCellStyleList.get(i);
            if (middleRowCellStyle != null) {
                HSSFCellStyle topRowCellStyle = columnTemplate.topRowCellStyleList.get(i);
                HSSFCellStyle bottomRowCellStyle = columnTemplate.bottomRowCellStyleList.get(i);
                HSSFCell bottomCell = bottomRow.getCell(row.getFirstCellNum() + i);
                topRowCellStyle.setBorderBottom(bottomCell.getCellStyle().getBorderTop());
                middleRowCellStyle.setBorderTop(bottomCell.getCellStyle().getBorderTop());
                middleRowCellStyle.setBorderBottom(bottomCell.getCellStyle().getBorderTop());
                bottomRowCellStyle.setBorderTop(bottomCell.getCellStyle().getBorderTop());
                bottomRowCellStyle.setBorderBottom(bottomCell.getCellStyle().getBorderBottom());
            }
            i = (short)(i + 1);
        }
        return columnTemplate;
    }

    protected void setCellStyle(ColumnTemplate columnTemplate, HSSFSheet sheet, int firstRowNum, int rowSize, int firstColNum) {
        sheet.removeRow((Row)sheet.getRow(firstRowNum + rowSize));
        HSSFRow bottomRowTemplate = sheet.getRow(firstRowNum + rowSize + 1);
        sheet.removeRow((Row)bottomRowTemplate);
        int r = firstRowNum + 1;
        while (r < firstRowNum + rowSize) {
            HSSFRow row = sheet.getRow(r);
            int i = 0;
            while (i < columnTemplate.middleRowCellStyleList.size()) {
                HSSFCell cell = row.getCell(firstColNum + i);
                if (cell != null && columnTemplate.middleRowCellStyleList.get(i) != null) {
                    cell.setCellStyle(columnTemplate.middleRowCellStyleList.get(i));
                }
                ++i;
            }
            ++r;
        }
        if (rowSize > 0) {
            HSSFRow topRow = sheet.getRow(firstRowNum);
            int i = 0;
            while (i < columnTemplate.topRowCellStyleList.size()) {
                HSSFCell cell = topRow.getCell(firstColNum + i);
                if (cell != null && columnTemplate.topRowCellStyleList.get(i) != null) {
                    cell.setCellStyle(columnTemplate.topRowCellStyleList.get(i));
                }
                ++i;
            }
            HSSFRow bottomRow = sheet.getRow(firstRowNum + rowSize - 1);
            int i2 = 0;
            while (i2 < columnTemplate.bottomRowCellStyleList.size()) {
                HSSFCell bottomRowCell = bottomRow.getCell(firstColNum + i2);
                if (bottomRowCell != null && columnTemplate.bottomRowCellStyleList.get(i2) != null) {
                    bottomRowCell.setCellStyle(columnTemplate.bottomRowCellStyleList.get(i2));
                }
                ++i2;
            }
        } else {
            HSSFRow bottomRow = sheet.getRow(firstRowNum - 1);
            if (bottomRow != null) {
                int i = 0;
                while (i < columnTemplate.bottomRowCellStyleList.size()) {
                    HSSFCell bottomRowCell = bottomRow.getCell(firstColNum + i);
                    if (bottomRowCell != null) {
                        HSSFCellStyle bottomRowCellStyle = bottomRowCell.getCellStyle();
                        if (columnTemplate.bottomRowCellStyleList.get(i) != null) {
                            bottomRowCellStyle.setBorderBottom(columnTemplate.bottomRowCellStyleList.get(i).getBorderBottom());
                        }
                    }
                    ++i;
                }
            }
        }
        List<CellRangeAddress> regionList = POIUtils.getMergedRegionList(sheet, firstRowNum);
        int r2 = firstRowNum + 1;
        while (r2 < firstRowNum + rowSize) {
            POIUtils.copyMergedRegion(sheet, regionList, r2);
            ++r2;
        }
    }

    public static HSSFSheet createNewSheet(HSSFWorkbook workbook, int sheetNo, String name, Map<String, Integer> sheetNameMap) {
        HSSFSheet sheet = workbook.cloneSheet(sheetNo);
        int newSheetNo = workbook.getSheetIndex((Sheet)sheet);
        workbook.setSheetName(newSheetNo, AbstractSheetGenerator.decideSheetName(name, sheetNameMap));
        return sheet;
    }

    public static String decideSheetName(String name, Map<String, Integer> sheetNameMap) {
        if (name.length() > 26) {
            name = name.substring(0, 26);
        }
        String sheetName = null;
        Integer sameNameNum = sheetNameMap.get(name);
        if (sameNameNum == null) {
            sameNameNum = 0;
            sheetName = name;
        } else {
            do {
                sameNameNum = sameNameNum + 1;
            } while (sheetNameMap.containsKey(sheetName = String.valueOf(name) + "(" + sameNameNum + ")"));
        }
        sheetNameMap.put(name, sameNameNum);
        return sheetName;
    }

    public void init(HSSFSheet wordsSheet) {
        this.keywordsValueMap = this.buildKeywordsValueMap(wordsSheet, this.getKeywordsColumnNo(), this.getKeywords());
    }

    public abstract void generate(IProgressMonitor var1, HSSFWorkbook var2, int var3, boolean var4, Map<String, Integer> var5, Map<String, ObjectModel> var6, ERDiagram var7, Map<String, ExportToExcelManager.LoopDefinition> var8) throws InterruptedException;

    public abstract int count(ERDiagram var1);

    public abstract String getTemplateSheetName();

    public abstract int getKeywordsColumnNo();

    public abstract String[] getKeywords();

    public static class ColumnTemplate {
        public Map<Integer, String> columnTemplateMap = new HashMap<Integer, String>();
        public List<HSSFCellStyle> topRowCellStyleList;
        public List<HSSFCellStyle> middleRowCellStyleList;
        public List<HSSFCellStyle> bottomRowCellStyleList;
    }

    public static class MatrixCellStyle {
        public HSSFCellStyle headerTemplateCellStyle;
        public HSSFCellStyle style11;
        public HSSFCellStyle style12;
        public HSSFCellStyle style13;
        public HSSFCellStyle style21;
        public HSSFCellStyle style22;
        public HSSFCellStyle style23;
        public HSSFCellStyle style31;
        public HSSFCellStyle style32;
        public HSSFCellStyle style33;
    }
}

