/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageSetting
implements Serializable {
    private static final long serialVersionUID = 7520875865783223474L;
    private static final int DEFAULT_MARGIN = 30;
    private boolean directionHorizontal;
    private int scale;
    private String paperSize;
    private int topMargin;
    private int leftMargin;
    private int bottomMargin;
    private int rightMargin;

    public PageSetting() {
        this.directionHorizontal = true;
        this.scale = 100;
        this.paperSize = "A4 210 x 297 mm";
        this.topMargin = 30;
        this.rightMargin = 30;
        this.bottomMargin = 30;
        this.leftMargin = 30;
    }

    public PageSetting(boolean directionHorizontal, int scale, String paperSize, int topMargin, int rightMargin, int bottomMargin, int leftMargin) {
        this.directionHorizontal = directionHorizontal;
        this.scale = scale;
        this.paperSize = paperSize;
        this.topMargin = topMargin;
        this.rightMargin = rightMargin;
        this.bottomMargin = bottomMargin;
        this.leftMargin = leftMargin;
    }

    public static List<String> getAllPaperSize() {
        ArrayList<String> allPaperSize = new ArrayList<String>();
        allPaperSize.add("A0 841 x 1189 mm");
        allPaperSize.add("A1 594 x 841 mm");
        allPaperSize.add("A2 420 x 594 mm");
        allPaperSize.add("A3 297 x 420 mm");
        allPaperSize.add("A4 210 x 297 mm");
        allPaperSize.add("B0 1000 x 1414 mm");
        allPaperSize.add("B1 707 x 1000 mm");
        allPaperSize.add("B2 500 x 707 mm");
        allPaperSize.add("B3 353 x 500 mm");
        allPaperSize.add("B4 250 x 353 mm");
        allPaperSize.add("B5 176 x 250 mm");
        return allPaperSize;
    }

    public boolean isDirectionHorizontal() {
        return this.directionHorizontal;
    }

    public int getScale() {
        return this.scale;
    }

    public String getPaperSize() {
        return this.paperSize;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getWidth() {
        return (int)((double)((this.getLength(this.directionHorizontal) - this.leftMargin / 10 - this.rightMargin / 10) * Display.getCurrent().getDPI().x) / 25.4 * 100.0 / (double)this.scale);
    }

    public int getHeight() {
        return (int)((double)((this.getLength(!this.directionHorizontal) - this.topMargin / 10 - this.bottomMargin / 10) * Display.getCurrent().getDPI().y) / 25.4 * 100.0 / (double)this.scale);
    }

    private int getLength(boolean horizontal) {
        if (horizontal) {
            if (this.paperSize.startsWith("A0")) {
                return 1189;
            }
            if (this.paperSize.startsWith("A1")) {
                return 841;
            }
            if (this.paperSize.startsWith("A2")) {
                return 594;
            }
            if (this.paperSize.startsWith("A3")) {
                return 420;
            }
            if (this.paperSize.startsWith("A4")) {
                return 297;
            }
            if (this.paperSize.startsWith("B0")) {
                return 1414;
            }
            if (this.paperSize.startsWith("B1")) {
                return 1000;
            }
            if (this.paperSize.startsWith("B2")) {
                return 707;
            }
            if (this.paperSize.startsWith("B3")) {
                return 500;
            }
            if (this.paperSize.startsWith("B4")) {
                return 353;
            }
            if (this.paperSize.startsWith("B5")) {
                return 250;
            }
            return 297;
        }
        if (this.paperSize.startsWith("A0")) {
            return 841;
        }
        if (this.paperSize.startsWith("A1")) {
            return 594;
        }
        if (this.paperSize.startsWith("A2")) {
            return 420;
        }
        if (this.paperSize.startsWith("A3")) {
            return 297;
        }
        if (this.paperSize.startsWith("A4")) {
            return 210;
        }
        if (this.paperSize.startsWith("B0")) {
            return 1000;
        }
        if (this.paperSize.startsWith("B1")) {
            return 707;
        }
        if (this.paperSize.startsWith("B2")) {
            return 500;
        }
        if (this.paperSize.startsWith("B3")) {
            return 353;
        }
        if (this.paperSize.startsWith("B4")) {
            return 250;
        }
        if (this.paperSize.startsWith("B5")) {
            return 176;
        }
        return 210;
    }
}

