/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.editor.model.settings.DBSetting;
import org.insightech.er.preference.PreferenceInitializer;
import org.insightech.er.util.Format;

public class DBSettingListDialog
extends AbstractDialog {
    private Table settingTable;
    private List<DBSetting> dbSettingList;
    private DBSetting result;
    private String database;

    public DBSettingListDialog(Shell parentShell, String database) {
        super(parentShell);
        this.database = database;
        this.dbSettingList = new ArrayList<DBSetting>();
    }

    protected void initialize(Composite composite) {
        GridData gridData = new GridData();
        gridData.heightHint = 150;
        this.settingTable = new Table(composite, 67584);
        this.settingTable.setHeaderVisible(true);
        this.settingTable.setLayoutData((Object)gridData);
        this.settingTable.setLinesVisible(false);
        TableColumn dbsystemColumn = new TableColumn(this.settingTable, 16384);
        dbsystemColumn.setWidth(100);
        dbsystemColumn.setText(ResourceString.getResourceString("label.database"));
        TableColumn serverColumn = new TableColumn(this.settingTable, 16384);
        serverColumn.setWidth(100);
        serverColumn.setText(ResourceString.getResourceString("label.server.name"));
        TableColumn portColumn = new TableColumn(this.settingTable, 131072);
        portColumn.setWidth(80);
        portColumn.setText(ResourceString.getResourceString("label.port"));
        TableColumn databaseColumn = new TableColumn(this.settingTable, 16384);
        databaseColumn.setWidth(100);
        databaseColumn.setText(ResourceString.getResourceString("label.database.name"));
        TableColumn userNameColumn = new TableColumn(this.settingTable, 16384);
        userNameColumn.setWidth(100);
        userNameColumn.setText(ResourceString.getResourceString("label.user.name"));
        TableColumn urlTableColumn = new TableColumn(this.settingTable, 16384);
        urlTableColumn.setWidth(130);
        urlTableColumn.setText(ResourceString.getResourceString("label.url"));
    }

    protected void addListener() {
        super.addListener();
        this.settingTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DBSettingListDialog.this.buttonPressed(0);
            }
        });
        this.settingTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSettingListDialog.this.validate();
                int index = DBSettingListDialog.this.settingTable.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                DBSettingListDialog.this.selectTable(index);
            }
        });
    }

    protected void perfomeOK() throws InputException {
        int index = this.settingTable.getSelectionIndex();
        this.result = this.dbSettingList.get(index);
    }

    public DBSetting getResult() {
        return this.result;
    }

    public int getResultIndex() {
        return this.dbSettingList.indexOf(this.result);
    }

    protected void setData() {
        this.dbSettingList = PreferenceInitializer.getDBSettingList(this.database);
        for (DBSetting dbSetting : this.dbSettingList) {
            TableItem item = new TableItem(this.settingTable, 0);
            item.setText(0, dbSetting.getDbsystem());
            item.setText(1, dbSetting.getServer());
            if (dbSetting.getPort() != 0) {
                item.setText(2, String.valueOf(dbSetting.getPort()));
            }
            item.setText(3, dbSetting.getDatabase());
            item.setText(4, dbSetting.getUser());
            item.setText(5, Format.null2blank(dbSetting.getUrl()));
        }
        this.setButtonEnabled(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, ResourceString.getResourceString("label.load.setting"), true);
        this.createButton(parent, 6, ResourceString.getResourceString("label.delete"), false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
        this.setButtonEnabled(false);
    }

    private void setButtonEnabled(boolean enabled) {
        Button deleteButton;
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enabled);
        }
        if ((deleteButton = this.getButton(6)) != null) {
            deleteButton.setEnabled(enabled);
        }
    }

    private void selectTable(int index) {
        this.settingTable.select(index);
        if (index >= 0) {
            this.setButtonEnabled(true);
        } else {
            this.setButtonEnabled(false);
        }
    }

    protected String getErrorMessage() {
        int index = this.settingTable.getSelectionIndex();
        if (index == -1) {
            return "dialog.message.load.db.setting";
        }
        return null;
    }

    protected String getTitle() {
        return "label.load.database.setting";
    }

    protected void buttonPressed(int buttonId) {
        int index;
        if (buttonId == 6 && (index = this.settingTable.getSelectionIndex()) != -1) {
            this.settingTable.remove(index);
            this.dbSettingList.remove(index);
            PreferenceInitializer.saveSetting(this.dbSettingList);
            if (index >= this.settingTable.getItemCount()) {
                index = this.settingTable.getItemCount() - 1;
            }
            this.selectTable(index);
        }
        super.buttonPressed(buttonId);
    }
}

