/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.edit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.CenteredContentCellPaint;
import org.insightech.er.common.widgets.ListenerAppender;
import org.insightech.er.db.sqltype.SqlType;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.DiagramContents;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.Column;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.CopyWord;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.TypeData;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.Word;
import org.insightech.er.editor.model.edit.CopyManager;
import org.insightech.er.editor.view.dialog.common.EditableTable;
import org.insightech.er.util.Check;
import org.insightech.er.util.Format;

public class EditAllAttributesDialog
extends AbstractDialog
implements EditableTable {
    private static final int KEY_WIDTH = 45;
    private static final int NAME_WIDTH = 150;
    private static final int TYPE_WIDTH = 100;
    private static final int NOT_NULL_WIDTH = 80;
    private static final int UNIQUE_KEY_WIDTH = 70;
    private Table attributeTable;
    private TableEditor tableEditor;
    private ERDiagram diagram;
    private DiagramContents diagramContents;
    private List<Column> columnList;
    private List<Word> wordList;
    private String errorMessage;

    public EditAllAttributesDialog(Shell parentShell, ERDiagram diagram) {
        super(parentShell, 2);
        this.diagram = diagram;
        CopyManager copyManager = new CopyManager();
        this.diagramContents = copyManager.copy(this.diagram.getDiagramContents());
        this.columnList = new ArrayList<Column>();
    }

    protected String getErrorMessage() {
        return this.errorMessage;
    }

    protected String getTitle() {
        return "dialog.title.edit.all.attributes";
    }

    protected void initialize(Composite composite) {
        this.createTable(composite);
    }

    private void createTable(Composite composite) {
        GridData tableGridData = new GridData();
        tableGridData.horizontalSpan = 3;
        tableGridData.heightHint = 400;
        tableGridData.horizontalAlignment = 4;
        tableGridData.grabExcessHorizontalSpace = true;
        this.attributeTable = new Table(composite, 67588);
        this.attributeTable.setLayoutData((Object)tableGridData);
        this.attributeTable.setHeaderVisible(true);
        this.attributeTable.setLinesVisible(true);
        TableColumn columnLogicalName = new TableColumn(this.attributeTable, 0);
        columnLogicalName.setWidth(150);
        columnLogicalName.setText(ResourceString.getResourceString("label.column.logical.name"));
        TableColumn columnPhysicalName = new TableColumn(this.attributeTable, 0);
        columnPhysicalName.setWidth(150);
        columnPhysicalName.setText(ResourceString.getResourceString("label.column.physical.name"));
        TableColumn tableLogicalName = new TableColumn(this.attributeTable, 0);
        tableLogicalName.setWidth(150);
        tableLogicalName.setText(ResourceString.getResourceString("label.table.logical.name"));
        TableColumn tablePhysicalName = new TableColumn(this.attributeTable, 0);
        tablePhysicalName.setWidth(150);
        tablePhysicalName.setText(ResourceString.getResourceString("label.table.physical.name"));
        TableColumn tableWord = new TableColumn(this.attributeTable, 0);
        tableWord.setWidth(150);
        tableWord.setText(ResourceString.getResourceString("label.word"));
        TableColumn columnType = new TableColumn(this.attributeTable, 0);
        columnType.setWidth(100);
        columnType.setText(ResourceString.getResourceString("label.column.type"));
        TableColumn columnLength = new TableColumn(this.attributeTable, 131072);
        columnLength.setWidth(100);
        columnLength.setText(ResourceString.getResourceString("label.column.length"));
        TableColumn columnDecimal = new TableColumn(this.attributeTable, 131072);
        columnDecimal.setWidth(100);
        columnDecimal.setText(ResourceString.getResourceString("label.column.decimal"));
        TableColumn columnKey = new TableColumn(this.attributeTable, 0x1000000);
        columnKey.setText("PK");
        columnKey.setWidth(45);
        new CenteredContentCellPaint(this.attributeTable, 8);
        TableColumn columnForeignKey = new TableColumn(this.attributeTable, 0x1000000);
        columnForeignKey.setText("FK");
        columnForeignKey.setWidth(45);
        new CenteredContentCellPaint(this.attributeTable, 9);
        TableColumn columnNotNull = new TableColumn(this.attributeTable, 0x1000000);
        columnNotNull.setWidth(80);
        columnNotNull.setText(ResourceString.getResourceString("label.not.null"));
        new CenteredContentCellPaint(this.attributeTable, 10);
        TableColumn columnUnique = new TableColumn(this.attributeTable, 0x1000000);
        columnUnique.setWidth(70);
        columnUnique.setText(ResourceString.getResourceString("label.unique.key"));
        new CenteredContentCellPaint(this.attributeTable, 11);
        this.tableEditor = new TableEditor(this.attributeTable);
        this.tableEditor.grabHorizontal = true;
        ListenerAppender.addTableEditListener(this.attributeTable, this.tableEditor, this);
    }

    private Combo createTypeCombo(NormalColumn targetColumn) {
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        Combo typeCombo = new Combo((Composite)this.attributeTable, 8);
        this.initializeTypeCombo(typeCombo);
        typeCombo.setLayoutData((Object)gridData);
        typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditAllAttributesDialog.this.validate();
            }
        });
        SqlType sqlType = targetColumn.getType();
        String database = this.diagram.getDatabase();
        if (sqlType != null && sqlType.getAlias(database) != null) {
            typeCombo.setText(sqlType.getAlias(database));
        }
        return typeCombo;
    }

    private void initializeTypeCombo(Combo combo) {
        combo.setVisibleItemCount(20);
        combo.add("");
        String database = this.diagram.getDatabase();
        for (String alias : SqlType.getAliasList(database)) {
            combo.add(alias);
        }
    }

    protected Combo createWordCombo(NormalColumn targetColumn) {
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        Combo wordCombo = new Combo((Composite)this.attributeTable, 8);
        this.initializeWordCombo(wordCombo);
        wordCombo.setLayoutData((Object)gridData);
        this.setWordValue(wordCombo, targetColumn);
        return wordCombo;
    }

    private void initializeWordCombo(Combo combo) {
        combo.setVisibleItemCount(20);
        combo.add("");
        this.wordList = this.diagramContents.getDictionary().getWordList();
        Collections.sort(this.wordList);
        for (Word word : this.wordList) {
            combo.add(Format.null2blank(word.getLogicalName()));
        }
    }

    private void setWordValue(Combo combo, NormalColumn targetColumn) {
        Word word = targetColumn.getWord();
        while (word instanceof CopyWord) {
            word = ((CopyWord)word).getOriginal();
        }
        if (word != null) {
            int index = this.wordList.indexOf(word);
            combo.select(index + 1);
        }
    }

    protected void perfomeOK() throws InputException {
    }

    protected void setData() {
        for (NodeElement nodeElement : this.diagramContents.getContents()) {
            if (!(nodeElement instanceof ERTable)) continue;
            ERTable table = (ERTable)nodeElement;
            for (Column column : table.getColumns()) {
                TableItem tableItem = new TableItem(this.attributeTable, 0);
                this.column2TableItem(table, column, tableItem);
                this.columnList.add(column);
            }
        }
    }

    private void column2TableItem(ERTable table, Column column, TableItem tableItem) {
        if (table != null) {
            tableItem.setText(2, Format.null2blank(table.getLogicalName()));
            tableItem.setText(3, Format.null2blank(table.getPhysicalName()));
        }
        if (column instanceof NormalColumn) {
            NormalColumn normalColumn = (NormalColumn)column;
            Color keyColor = ColorConstants.black;
            Color color = ColorConstants.black;
            if (normalColumn.isPrimaryKey() && normalColumn.isForeignKey()) {
                keyColor = ColorConstants.blue;
                color = ColorConstants.gray;
            } else if (normalColumn.isPrimaryKey()) {
                keyColor = ColorConstants.red;
            } else if (normalColumn.isForeignKey()) {
                keyColor = ColorConstants.darkGreen;
                color = ColorConstants.gray;
            }
            tableItem.setForeground(color);
            int colCount = 0;
            tableItem.setForeground(colCount, keyColor);
            tableItem.setText(colCount, Format.null2blank(normalColumn.getLogicalName()));
            tableItem.setForeground(++colCount, keyColor);
            tableItem.setText(colCount, Format.null2blank(normalColumn.getPhysicalName()));
            tableItem.setForeground(++colCount, ColorConstants.gray);
            tableItem.setForeground(++colCount, ColorConstants.gray);
            ++colCount;
            if (normalColumn.getWord() != null) {
                tableItem.setText(colCount, Format.null2blank(normalColumn.getWord().getLogicalName()));
            }
            ++colCount;
            SqlType sqlType = normalColumn.getType();
            if (sqlType != null) {
                String database = this.diagram.getDatabase();
                if (sqlType.getAlias(database) != null) {
                    tableItem.setText(colCount, sqlType.getAlias(database));
                } else {
                    tableItem.setText(colCount, "");
                }
            } else {
                tableItem.setText(colCount, "");
            }
            ++colCount;
            if (normalColumn.getTypeData().getLength() != null) {
                tableItem.setText(colCount, normalColumn.getTypeData().getLength().toString());
            } else {
                tableItem.setText(colCount, "");
            }
            ++colCount;
            if (normalColumn.getTypeData().getDecimal() != null) {
                tableItem.setText(colCount, normalColumn.getTypeData().getDecimal().toString());
            } else {
                tableItem.setText(colCount, "");
            }
            ++colCount;
            if (normalColumn.isPrimaryKey()) {
                tableItem.setImage(colCount, Activator.getImage("PRIMARY_KEY"));
            } else {
                tableItem.setImage(colCount, null);
            }
            ++colCount;
            if (normalColumn.isForeignKey()) {
                tableItem.setImage(colCount, Activator.getImage("FOREIGN_KEY"));
            } else {
                tableItem.setImage(colCount, null);
            }
            ++colCount;
            if (normalColumn.isNotNull()) {
                if (normalColumn.isPrimaryKey()) {
                    tableItem.setImage(colCount, Activator.getImage("CHECK_GREY"));
                } else {
                    tableItem.setImage(colCount, Activator.getImage("CHECK"));
                }
            } else {
                tableItem.setImage(colCount, null);
            }
            ++colCount;
            if (normalColumn.isUniqueKey()) {
                if (table != null && normalColumn.isRefered()) {
                    tableItem.setImage(colCount, Activator.getImage("CHECK_GREY"));
                } else {
                    tableItem.setImage(colCount, Activator.getImage("CHECK"));
                }
            } else {
                tableItem.setImage(colCount, null);
            }
        } else {
            tableItem.setForeground(ColorConstants.gray);
            tableItem.setText(0, column.getName());
            tableItem.setImage(8, null);
            tableItem.setImage(9, null);
        }
    }

    public Control getControl(Point xy) {
        Column column = this.getColumn(xy);
        if (column instanceof NormalColumn) {
            NormalColumn targetColumn = (NormalColumn)column;
            String database = this.diagram.getDatabase();
            if (xy.x == 4) {
                if (targetColumn.isForeignKey()) {
                    return null;
                }
                return this.createWordCombo(targetColumn);
            }
            if (xy.x == 0 || xy.x == 1) {
                return new Text((Composite)this.attributeTable, 2048);
            }
            if (xy.x == 6) {
                if (targetColumn.isForeignKey()) {
                    return null;
                }
                if (targetColumn.getType() != null && targetColumn.getType().isNeedLength(database)) {
                    return new Text((Composite)this.attributeTable, 133120);
                }
            }
            if (xy.x == 7) {
                if (targetColumn.isForeignKey()) {
                    return null;
                }
                if (targetColumn.getType() != null && targetColumn.getType().isNeedDecimal(database)) {
                    return new Text((Composite)this.attributeTable, 133120);
                }
            }
            if (xy.x == 5) {
                if (targetColumn.isForeignKey()) {
                    return null;
                }
                return this.createTypeCombo(targetColumn);
            }
        }
        return null;
    }

    private Column getColumn(Point xy) {
        return this.columnList.get(xy.y);
    }

    /*
     * Unable to fully structure code
     */
    public void setData(Point xy, Control control) {
        this.errorMessage = null;
        column = this.getColumn(xy);
        if (column instanceof NormalColumn) {
            targetColumn = (NormalColumn)column;
            database = this.diagram.getDatabase();
            word = targetColumn.getWord();
            if (xy.x == 4) {
                if (targetColumn.isForeignKey()) {
                    return;
                }
                index = ((Combo)control).getSelectionIndex();
                dictionary = this.diagramContents.getDictionary();
                dictionary.remove(targetColumn);
                if (index == 0) {
                    word = new Word(word);
                    word.setLogicalName("");
                } else {
                    selectedWord = this.wordList.get(index - 1);
                    if (word != selectedWord) {
                        word = selectedWord;
                    }
                }
                targetColumn.setWord(word);
                dictionary.add(targetColumn);
                this.resetNormalColumn(targetColumn);
            } else {
                if (xy.x == 0) {
                    text = ((Text)control).getText();
                    if (targetColumn.isForeignKey()) {
                        targetColumn.setForeignKeyLogicalName(text);
                    } else {
                        word.setLogicalName(text);
                    }
                } else if (xy.x == 1) {
                    text = ((Text)control).getText();
                    if (!Check.isAlphabet(text) && this.diagram.getDiagramContents().getSettings().isValidatePhysicalName()) {
                        this.errorMessage = "error.column.physical.name.not.alphabet";
                        return;
                    }
                    if (targetColumn.isForeignKey()) {
                        targetColumn.setForeignKeyPhysicalName(text);
                    } else {
                        word.setPhysicalName(text);
                    }
                } else if (xy.x == 5) {
                    if (targetColumn.isForeignKey()) {
                        return;
                    }
                    selectedType = SqlType.valueOf(database, ((Combo)control).getText());
                    word.setType(selectedType, word.getTypeData(), database);
                } else if (xy.x == 6) {
                    if (targetColumn.isForeignKey()) {
                        return;
                    }
                    text = ((Text)control).getText().trim();
                    try {
                        if (text.equals("")) ** GOTO lbl81
                        len = Integer.parseInt(text);
                        if (len < 0) {
                            this.errorMessage = "error.column.length.zero";
                            return;
                        }
                        oldTypeData = word.getTypeData();
                        newTypeData = new TypeData(Integer.parseInt(((Text)control).getText()), oldTypeData.getDecimal(), oldTypeData.isArray(), oldTypeData.getArrayDimension(), oldTypeData.isUnsigned(), oldTypeData.getArgs());
                        word.setType(word.getType(), newTypeData, database);
                    }
                    catch (NumberFormatException v0) {
                        this.errorMessage = "error.column.length.degit";
                        return;
                    }
                } else if (xy.x == 7) {
                    if (targetColumn.isForeignKey()) {
                        return;
                    }
                    text = ((Text)control).getText().trim();
                    try {
                        if (!text.equals("")) {
                            decimal = Integer.parseInt(text);
                            if (decimal < 0) {
                                this.errorMessage = "error.column.decimal.zero";
                                return;
                            }
                            oldTypeData = word.getTypeData();
                            newTypeData = new TypeData(oldTypeData.getLength(), decimal, oldTypeData.isArray(), oldTypeData.getArrayDimension(), oldTypeData.isUnsigned(), oldTypeData.getArgs());
                            word.setType(word.getType(), newTypeData, database);
                        }
                    }
                    catch (NumberFormatException v1) {
                        this.errorMessage = "error.column.decimal.degit";
                        return;
                    }
                }
lbl81:
                // 10 sources

                this.resetRowUse(word, targetColumn);
            }
        }
    }

    private void resetRowUse(Word word, NormalColumn targetColumn) {
        if (targetColumn.isForeignKey()) {
            this.resetNormalColumn(targetColumn);
        } else {
            int i = 0;
            while (i < this.columnList.size()) {
                NormalColumn normalColumn;
                Column column = this.columnList.get(i);
                if (column instanceof NormalColumn && word.equals((normalColumn = (NormalColumn)column).getWord())) {
                    this.resetNormalColumn(normalColumn);
                }
                ++i;
            }
        }
    }

    private void resetNormalColumn(NormalColumn normalColumn) {
        int i = 0;
        while (i < this.columnList.size()) {
            if (this.columnList.get(i) == normalColumn) {
                TableItem tableItem = this.attributeTable.getItem(i);
                this.column2TableItem(null, normalColumn, tableItem);
                break;
            }
            ++i;
        }
        List<NormalColumn> foreignKeyList = normalColumn.getForeignKeyList();
        for (NormalColumn foreignKey : foreignKeyList) {
            this.resetNormalColumn(foreignKey);
        }
    }

    public DiagramContents getDiagramContents() {
        return this.diagramContents;
    }

    public void onDoubleClicked(Point xy) {
        Column column = this.getColumn(xy);
        if (column instanceof NormalColumn) {
            NormalColumn normalColumn = (NormalColumn)column;
            if (normalColumn.isPrimaryKey()) {
                return;
            }
            if (normalColumn.isRefered()) {
                return;
            }
            if (xy.x == 10) {
                normalColumn.setNotNull(!normalColumn.isNotNull());
                this.resetNormalColumn(normalColumn);
            } else if (xy.x == 11) {
                normalColumn.setUniqueKey(!normalColumn.isUniqueKey());
                this.resetNormalColumn(normalColumn);
            }
        }
    }
}

