/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.element;

import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.editor.model.diagram_contents.element.node.model_properties.ModelProperties;
import org.insightech.er.util.Check;
import org.insightech.er.util.Format;
import org.insightech.er.util.NameValue;

public class ModelPropertiesDialog
extends AbstractDialog {
    private static final int BUTTON_WIDTH = 60;
    private Table table;
    private Button addButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private ModelProperties modelProperties;
    private TableEditor tableEditor;
    int targetColumn = -1;

    public ModelPropertiesDialog(Shell parentShell, ModelProperties modelProperties) {
        super(parentShell, 2);
        this.modelProperties = modelProperties;
    }

    protected void initialize(Composite composite) {
        this.createTableComposite(composite);
        this.createButtonComposite(composite);
    }

    private void createTableComposite(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        GridData gridData = new GridData();
        gridData.heightHint = 320;
        GridData tableGridData = new GridData();
        tableGridData.horizontalSpan = 3;
        tableGridData.heightHint = 185;
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        this.table = new Table(composite, 67584);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)tableGridData);
        this.table.setLinesVisible(true);
        TableColumn tableColumn0 = new TableColumn(this.table, 0);
        tableColumn0.setWidth(200);
        tableColumn0.setText(ResourceString.getResourceString("label.property.name"));
        TableColumn tableColumn1 = new TableColumn(this.table, 0);
        tableColumn1.setWidth(200);
        tableColumn1.setText(ResourceString.getResourceString("label.property.value"));
        this.tableEditor = new TableEditor(this.table);
        this.tableEditor.grabHorizontal = true;
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                int index = ModelPropertiesDialog.this.table.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                TableItem item = ModelPropertiesDialog.this.table.getItem(index);
                Point selectedPoint = new Point(event.x, event.y);
                ModelPropertiesDialog.this.targetColumn = -1;
                int i = 0;
                while (i < ModelPropertiesDialog.this.table.getColumnCount()) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(selectedPoint)) {
                        ModelPropertiesDialog.this.targetColumn = i;
                        break;
                    }
                    ++i;
                }
                if (ModelPropertiesDialog.this.targetColumn == -1) {
                    return;
                }
                ModelPropertiesDialog.this.edit(item, ModelPropertiesDialog.this.tableEditor);
            }
        });
    }

    private void edit(final TableItem item, TableEditor tableEditor) {
        final Text text = new Text((Composite)this.table, 0);
        text.setText(item.getText(this.targetColumn));
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                item.setText(ModelPropertiesDialog.this.targetColumn, text.getText());
                text.dispose();
            }
        });
        tableEditor.setEditor((Control)text, item, this.targetColumn);
        text.setFocus();
        text.selectAll();
    }

    private void addRow() {
        TableItem item = new TableItem(this.table, 0);
        item.setText(0, "");
        item.setText(1, "");
        this.targetColumn = 0;
        this.edit(item, this.tableEditor);
    }

    private void createButtonComposite(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        GridData buttonGridData = new GridData();
        buttonGridData.widthHint = 60;
        this.addButton = new Button(composite, 0);
        this.addButton.setText(ResourceString.getResourceString("label.button.add"));
        this.addButton.setLayoutData((Object)buttonGridData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelPropertiesDialog.this.addRow();
            }
        });
        this.deleteButton = new Button(composite, 0);
        this.deleteButton.setText(ResourceString.getResourceString("label.button.delete"));
        this.deleteButton.setLayoutData((Object)buttonGridData);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelPropertiesDialog.this.removeColumn();
            }
        });
        Label filler = new Label(composite, 0);
        GridData fillerGridData = new GridData();
        fillerGridData.widthHint = 30;
        filler.setLayoutData((Object)fillerGridData);
        this.upButton = new Button(composite, 0);
        this.upButton.setText(ResourceString.getResourceString("label.up.arrow"));
        this.upButton.setLayoutData((Object)buttonGridData);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelPropertiesDialog.this.upColumn();
            }
        });
        this.downButton = new Button(composite, 0);
        this.downButton.setText(ResourceString.getResourceString("label.down.arrow"));
        this.downButton.setLayoutData((Object)buttonGridData);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelPropertiesDialog.this.downColumn();
            }
        });
    }

    private void removeColumn() {
        int index = this.table.getSelectionIndex();
        if (index != -1) {
            this.table.remove(index);
        }
        this.validate();
    }

    private void upColumn() {
        int index = this.table.getSelectionIndex();
        if (index != -1 && index != 0) {
            this.changeColumn(index - 1, index);
            this.table.setSelection(index - 1);
        }
    }

    private void downColumn() {
        int index = this.table.getSelectionIndex();
        if (index != -1 && index != this.table.getItemCount() - 1) {
            this.changeColumn(index, index + 1);
            this.table.setSelection(index + 1);
        }
    }

    private void changeColumn(int index1, int index2) {
        TableItem item1 = this.table.getItem(index1);
        TableItem item2 = this.table.getItem(index2);
        String name1 = item1.getText(0);
        String value1 = item1.getText(1);
        item1.setText(0, item2.getText(0));
        item1.setText(1, item2.getText(1));
        item2.setText(0, name1);
        item2.setText(1, value1);
    }

    protected String getErrorMessage() {
        return null;
    }

    protected void perfomeOK() {
        this.modelProperties.clear();
        int i = 0;
        while (i < this.table.getItemCount()) {
            TableItem item = this.table.getItem(i);
            if (!Check.isEmpty(item.getText(0)) || !Check.isEmpty(item.getText(1))) {
                NameValue property = new NameValue(item.getText(0), item.getText(1));
                this.modelProperties.addProperty(property);
            }
            ++i;
        }
    }

    protected String getTitle() {
        return "label.search.range.model.property";
    }

    protected void setData() {
        for (NameValue property : this.modelProperties.getProperties()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, Format.null2blank(property.getName()));
            item.setText(1, Format.null2blank(property.getValue()));
        }
    }
}

