/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.insightech.er.Resources;

public class DropShadowRectangle
extends RoundedRectangle {
    public static int SHADOW_INSET = 5;

    protected void fillShape(Graphics graphics) {
        Rectangle f = Rectangle.SINGLETON.setBounds(this.getBounds());
        Insets shadowInset = new Insets(0, 0, SHADOW_INSET, SHADOW_INSET);
        f = this.shrink(f, shadowInset);
        this.drawShadow(f, graphics);
        graphics.fillRoundRectangle(f, this.corner.width, this.corner.height);
    }

    private Rectangle shrink(Rectangle bounds, Insets insets) {
        Rectangle shrinked = bounds.getCopy();
        shrinked.x += insets.left;
        shrinked.y += insets.top;
        shrinked.width -= insets.getWidth();
        shrinked.height -= insets.getHeight();
        return shrinked;
    }

    public Insets getInsets() {
        return new Insets(1, 1, SHADOW_INSET + 1, SHADOW_INSET + 1);
    }

    protected void outlineShape(Graphics graphics) {
        Rectangle f = Rectangle.SINGLETON.setBounds(this.getBounds());
        Insets shadowInset = new Insets(this.getLineWidth() / 2, this.getLineWidth() / 2, this.getLineWidth() + SHADOW_INSET, this.getLineWidth() + SHADOW_INSET);
        this.shrink(f, shadowInset);
        graphics.drawRoundRectangle(f, this.corner.width, this.corner.height);
    }

    private void drawShadow(Rectangle rectangle, Graphics graphics) {
        int rgb = 255;
        int delta = 255 / SHADOW_INSET;
        int i = 0;
        while (i < SHADOW_INSET - 1) {
            Color color = Resources.getColor(new int[]{rgb -= delta, rgb, rgb});
            this.drawShadowLayer(rectangle, graphics, SHADOW_INSET - 1 - i, color);
            ++i;
        }
    }

    private void drawShadowLayer(Rectangle rectangle, Graphics graphics, int offset, Color color) {
        graphics.pushState();
        graphics.setLineWidth(0);
        graphics.setBackgroundColor(color);
        Rectangle shadowLayer = new Rectangle(rectangle);
        shadowLayer.x += offset;
        shadowLayer.y += offset;
        graphics.fillRoundRectangle(shadowLayer, this.corner.width, this.corner.height);
        graphics.popState();
    }
}

