/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.util;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CsvWriter {
    private static final DateFormat DEFAULT_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private static final String DELIMITER = ",";
    private PrintWriter writer;
    private DateFormat dateFormat;
    private String delimiter;

    public CsvWriter(PrintWriter writer) {
        this.writer = writer;
        this.delimiter = "";
        this.dateFormat = DEFAULT_FORMAT;
    }

    public void setDateFormat(String format) {
        this.dateFormat = new SimpleDateFormat(format);
    }

    public static String escape(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("\"", "\"\"");
    }

    public void print(Object object) {
        String value = null;
        value = object instanceof Date ? this.dateFormat.format((Date)object) : (object == null ? "" : object.toString());
        this.writer.print(this.delimiter);
        this.writer.print("\"");
        this.writer.print(CsvWriter.escape(value));
        this.writer.print("\"");
        this.setDelimiter();
    }

    private void setDelimiter() {
        this.delimiter = DELIMITER;
    }

    private void resetDelimiter() {
        this.delimiter = "";
    }

    public void crln() {
        this.writer.print("\r\n");
        this.resetDelimiter();
    }

    public void close() {
        this.writer.close();
    }
}

