/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.persistence;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractMappingFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImpliedMappingFileRef
extends AbstractMappingFileRef {
    public ImpliedMappingFileRef(PersistenceUnit parent, String fileName) {
        super(parent, fileName);
    }

    @Override
    public XmlMappingFileRef getXmlMappingFileRef() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isImplied() {
        return true;
    }

    @Override
    public void setFileName(String fileName) {
        throw new UnsupportedOperationException("Cannot set an implied mapping file ref's 'fileName': " + fileName);
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return false;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return null;
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getPersistenceUnit().getValidationTextRange();
    }

    @Override
    public Iterable<DeleteEdit> createDeleteMappingFileEdits(IFile file) {
        throw new IllegalStateException("This reference cannot be deleted - it is implied");
    }

    @Override
    public Iterable<ReplaceEdit> createRenameFolderEdits(IFolder originalFolder, String newName) {
        throw new IllegalStateException("This reference cannot be moved - it is implied");
    }

    @Override
    protected ReplaceEdit createRenameEdit(IFile originalFile, String newName) {
        return this.createReplaceEdit(String.valueOf(this.fileName.substring(0, this.fileName.lastIndexOf(47) + 1)) + newName);
    }

    @Override
    protected ReplaceEdit createMoveEdit(IFile originalFile, IPath runtimeDestination) {
        return this.createReplaceEdit(runtimeDestination.append(originalFile.getName()).toString());
    }

    protected ReplaceEdit createReplaceEdit(String newMappingFileName) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringTools.CR);
        sb.append("\t\t<mapping-file>");
        sb.append(newMappingFileName);
        sb.append("</mapping-file>");
        int offset = this.getPersistenceUnit().findInsertLocationForMappingFileRef();
        return new ReplaceEdit(offset, 0, sb.toString());
    }

    @Override
    public Iterable<ReplaceEdit> createMoveFolderEdits(IFolder originalFolder, IPath runtimeDestination) {
        throw new IllegalStateException("This reference cannot be moved - it is implied");
    }
}

