/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.synch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeClassesJob
extends WorkspaceJob {
    private IFile persistenceXmlFile;

    public SynchronizeClassesJob(IFile file) {
        super(JptCoreMessages.SYNCHRONIZE_CLASSES_JOB);
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        this.setRule(ruleFactory.modifyRule((IResource)file.getProject()));
        this.persistenceXmlFile = file;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        final SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)JptCoreMessages.SYNCHRONIZING_CLASSES_TASK, (int)20);
        final JpaProject jpaProject = JptJpaCorePlugin.getJpaProject(this.persistenceXmlFile.getProject());
        final JpaXmlResource resource = jpaProject.getPersistenceXmlResource();
        if (resource == null) {
            return Status.OK_STATUS;
        }
        if (sm.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        sm.worked(1);
        resource.modify(new Runnable(){

            public void run() {
                XmlPersistenceUnit persistenceUnit;
                XmlPersistence persistence = (XmlPersistence)resource.getRootObject();
                if (persistence.getPersistenceUnits().size() > 0) {
                    persistenceUnit = (XmlPersistenceUnit)persistence.getPersistenceUnits().get(0);
                } else {
                    persistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
                    persistenceUnit.setName(jpaProject.getName());
                    persistence.getPersistenceUnits().add((Object)persistenceUnit);
                }
                sm.worked(1);
                persistenceUnit.getClasses().clear();
                sm.worked(1);
                SynchronizeClassesJob.this.addClassRefs((IProgressMonitor)sm.newChild(17), jpaProject, persistenceUnit);
            }
        });
        return Status.OK_STATUS;
    }

    protected void addClassRefs(IProgressMonitor monitor, JpaProject jpaProject, XmlPersistenceUnit persistenceUnit) {
        Iterable<String> mappedClassNames = this.getMappedClassNames(jpaProject, '$');
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)CollectionTools.size(mappedClassNames));
        for (String fullyQualifiedTypeName : mappedClassNames) {
            if (!this.mappingFileContains(jpaProject, fullyQualifiedTypeName)) {
                XmlJavaClassRef classRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
                classRef.setJavaClass(fullyQualifiedTypeName);
                persistenceUnit.getClasses().add((Object)classRef);
            }
            sm.worked(1);
        }
    }

    protected Iterable<String> getMappedClassNames(final JpaProject jpaProject, final char enclosingTypeSeparator) {
        return new TransformationIterable<String, String>(jpaProject.getMappedJavaSourceClassNames()){

            protected String transform(String fullyQualifiedName) {
                IType jdtType = SynchronizeClassesJob.this.findType(jpaProject, fullyQualifiedName);
                return jdtType.getFullyQualifiedName(enclosingTypeSeparator);
            }
        };
    }

    protected IType findType(JpaProject jpaProject, String typeName) {
        try {
            return jpaProject.getJavaProject().findType(typeName);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    boolean mappingFileContains(JpaProject jpaProject, String fullyQualifiedTypeName) {
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            return false;
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            return false;
        }
        if (persistence.persistenceUnitsSize() == 0) {
            return false;
        }
        PersistenceUnit persistenceUnit = persistence.persistenceUnits().next();
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(persistenceUnit.mappingFileRefs())) {
            if (mappingFileRef.getPersistentType(fullyQualifiedTypeName) == null) continue;
            return true;
        }
        return false;
    }
}

