/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.BindingComparator;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.DefaultBindingResolver;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class TypeBinding
implements ITypeBinding {
    protected static final IFunctionBinding[] NO_METHOD_BINDINGS = new IFunctionBinding[0];
    private static final String NO_NAME = "";
    protected static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    protected static final IVariableBinding[] NO_VARIABLE_BINDINGS = new IVariableBinding[0];
    private static final int VALID_MODIFIERS = 3103;
    org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding binding;
    private String key;
    private BindingResolver resolver;
    private IVariableBinding[] fields;
    private IFunctionBinding[] methods;
    private ITypeBinding[] members;

    public TypeBinding(BindingResolver resolver, org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding binding) {
        this.binding = binding;
        this.resolver = resolver;
    }

    public ITypeBinding createArrayType(int dimension) {
        int realDimensions = dimension;
        if ((realDimensions += this.getDimensions()) < 1 || realDimensions > 255) {
            throw new IllegalArgumentException();
        }
        return this.resolver.resolveArrayType(this, dimension);
    }

    public String getBinaryName() {
        char[] constantPoolName = this.binding.constantPoolName();
        if (constantPoolName == null) {
            return null;
        }
        char[] dotSeparated = CharOperation.replaceOnCopy(constantPoolName, '/', '.');
        return new String(dotSeparated);
    }

    private IClassFile getClassFile(char[] fileName) {
        int jarSeparator = CharOperation.indexOf('|', fileName);
        int pkgEnd = CharOperation.lastIndexOf('/', fileName);
        if (pkgEnd == -1) {
            pkgEnd = CharOperation.lastIndexOf(File.separatorChar, fileName);
        }
        if (jarSeparator != -1 && pkgEnd < jarSeparator) {
            pkgEnd = jarSeparator;
        }
        if (pkgEnd == -1) {
            return null;
        }
        IPackageFragment pkg = this.getPackageFragment(fileName, pkgEnd, jarSeparator);
        if (pkg == null) {
            return null;
        }
        int start = pkgEnd + 1;
        return pkg.getClassFile(new String(fileName, start, fileName.length - start));
    }

    private IJavaScriptUnit getCompilationUnit(char[] fileName) {
        IJavaScriptUnit workingCopy;
        char[] slashSeparatedFileName = CharOperation.replaceOnCopy(fileName, File.separatorChar, '/');
        int pkgEnd = CharOperation.lastIndexOf('/', slashSeparatedFileName);
        if (pkgEnd == -1) {
            return null;
        }
        IPackageFragment pkg = this.getPackageFragment(slashSeparatedFileName, pkgEnd, -1);
        if (pkg == null) {
            return null;
        }
        int start = pkgEnd + 1;
        IJavaScriptUnit cu = pkg.getJavaScriptUnit(new String(slashSeparatedFileName, start, slashSeparatedFileName.length - start));
        if (this.resolver instanceof DefaultBindingResolver && (workingCopy = cu.findWorkingCopy(((DefaultBindingResolver)this.resolver).workingCopyOwner)) != null) {
            return workingCopy;
        }
        return cu;
    }

    public ITypeBinding getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return this.resolver.getTypeBinding(arrayBinding.elementsType());
    }

    public synchronized IVariableBinding[] getDeclaredFields() {
        if (this.fields != null) {
            return this.fields;
        }
        try {
            ReferenceBinding referenceBinding;
            FieldBinding[] fieldBindings;
            int length;
            if (this.isClass() && (length = (fieldBindings = (referenceBinding = (ReferenceBinding)this.binding).availableFields()).length) != 0) {
                IVariableBinding[] newFields = new IVariableBinding[length];
                int i = 0;
                while (i < length) {
                    IVariableBinding variableBinding = this.resolver.getVariableBinding(fieldBindings[i]);
                    if (variableBinding == null) {
                        this.fields = NO_VARIABLE_BINDINGS;
                        return NO_VARIABLE_BINDINGS;
                    }
                    newFields[i] = variableBinding;
                    ++i;
                }
                this.fields = newFields;
                return newFields;
            }
        }
        catch (RuntimeException e) {
            Util.log(e, "Could not retrieve declared fields");
        }
        this.fields = NO_VARIABLE_BINDINGS;
        return NO_VARIABLE_BINDINGS;
    }

    public synchronized IFunctionBinding[] getDeclaredMethods() {
        if (this.methods != null) {
            return this.methods;
        }
        try {
            ReferenceBinding referenceBinding;
            MethodBinding[] internalMethods;
            int length;
            if (this.isClass() && (length = (internalMethods = (referenceBinding = (ReferenceBinding)this.binding).availableMethods()).length) != 0) {
                int removeSyntheticsCounter = 0;
                IFunctionBinding[] newMethods = new IFunctionBinding[length];
                int i = 0;
                while (i < length) {
                    IFunctionBinding methodBinding2;
                    MethodBinding methodBinding = internalMethods[i];
                    if (!this.shouldBeRemoved(methodBinding) && (methodBinding2 = this.resolver.getMethodBinding(methodBinding)) != null) {
                        newMethods[removeSyntheticsCounter++] = methodBinding2;
                    }
                    ++i;
                }
                if (removeSyntheticsCounter != length) {
                    IFunctionBinding[] iFunctionBindingArray = newMethods;
                    newMethods = new IFunctionBinding[removeSyntheticsCounter];
                    System.arraycopy(iFunctionBindingArray, 0, newMethods, 0, removeSyntheticsCounter);
                }
                this.methods = newMethods;
                return newMethods;
            }
        }
        catch (RuntimeException e) {
            Util.log(e, "Could not retrieve declared methods");
        }
        this.methods = NO_METHOD_BINDINGS;
        return NO_METHOD_BINDINGS;
    }

    public int getDeclaredModifiers() {
        return this.getModifiers();
    }

    public synchronized ITypeBinding[] getDeclaredTypes() {
        if (this.members != null) {
            return this.members;
        }
        try {
            ReferenceBinding referenceBinding;
            ReferenceBinding[] internalMembers;
            int length;
            if (this.isClass() && (length = (internalMembers = (referenceBinding = (ReferenceBinding)this.binding).memberTypes()).length) != 0) {
                ITypeBinding[] newMembers = new ITypeBinding[length];
                int i = 0;
                while (i < length) {
                    ITypeBinding typeBinding = this.resolver.getTypeBinding(internalMembers[i]);
                    if (typeBinding == null) {
                        this.members = NO_TYPE_BINDINGS;
                        return NO_TYPE_BINDINGS;
                    }
                    newMembers[i] = typeBinding;
                    ++i;
                }
                this.members = newMembers;
                return newMembers;
            }
        }
        catch (RuntimeException e) {
            Util.log(e, "Could not retrieve declared methods");
        }
        this.members = NO_TYPE_BINDINGS;
        return NO_TYPE_BINDINGS;
    }

    public synchronized IFunctionBinding getDeclaringMethod() {
        if (this.binding instanceof LocalTypeBinding) {
            LocalTypeBinding localTypeBinding = (LocalTypeBinding)this.binding;
            MethodBinding methodBinding = localTypeBinding.enclosingMethod;
            if (methodBinding != null) {
                try {
                    return this.resolver.getMethodBinding(localTypeBinding.enclosingMethod);
                }
                catch (RuntimeException e) {
                    Util.log(e, "Could not retrieve declaring method");
                }
            }
        }
        return null;
    }

    public synchronized ITypeBinding getDeclaringClass() {
        ReferenceBinding referenceBinding;
        if (this.isClass() && (referenceBinding = (ReferenceBinding)this.binding).isNestedType()) {
            try {
                return this.resolver.getTypeBinding(referenceBinding.enclosingType());
            }
            catch (RuntimeException e) {
                Util.log(e, "Could not retrieve declaring class");
            }
        }
        return null;
    }

    public int getDimensions() {
        if (!this.isArray()) {
            return 0;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return arrayBinding.dimensions;
    }

    public ITypeBinding getElementType() {
        if (!this.isArray()) {
            return null;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return this.resolver.getTypeBinding(arrayBinding.leafComponentType);
    }

    public ITypeBinding getTypeDeclaration() {
        return this;
    }

    public ITypeBinding getErasure() {
        return this.resolver.getTypeBinding(this.binding);
    }

    public IJavaScriptElement getJavaElement() {
        JavaElement element = this.getUnresolvedJavaElement();
        if (element == null) {
            return null;
        }
        return element.resolved(this.binding);
    }

    private JavaElement getUnresolvedJavaElement() {
        return this.getUnresolvedJavaElement(this.binding);
    }

    private JavaElement getUnresolvedJavaElement(org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        switch (typeBinding.kind()) {
            case 68: {
                typeBinding = ((ArrayBinding)typeBinding).leafComponentType();
                return this.getUnresolvedJavaElement(typeBinding);
            }
            case 132: {
                return null;
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        char[] fileName = referenceBinding.getFileName();
        if (referenceBinding.isLocalType() || referenceBinding.isAnonymousType()) {
            if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(fileName)) {
                int jarSeparator = CharOperation.indexOf('|', fileName);
                int pkgEnd = CharOperation.lastIndexOf('/', fileName);
                if (pkgEnd == -1) {
                    pkgEnd = CharOperation.lastIndexOf(File.separatorChar, fileName);
                }
                if (jarSeparator != -1 && pkgEnd < jarSeparator) {
                    pkgEnd = jarSeparator;
                }
                if (pkgEnd == -1) {
                    return null;
                }
                IPackageFragment pkg = this.getPackageFragment(fileName, pkgEnd, jarSeparator);
                char[] constantPoolName = referenceBinding.constantPoolName();
                if (constantPoolName == null) {
                    ClassFile classFile = (ClassFile)this.getClassFile(fileName);
                    return classFile == null ? null : (JavaElement)((Object)classFile.getType());
                }
                pkgEnd = CharOperation.lastIndexOf('/', constantPoolName);
                char[] classFileName = CharOperation.subarray(constantPoolName, pkgEnd + 1, constantPoolName.length);
                ClassFile classFile = (ClassFile)pkg.getClassFile(String.valueOf(new String(classFileName)) + ".js");
                return (JavaElement)((Object)classFile.getType());
            }
            IJavaScriptUnit cu = this.getCompilationUnit(fileName);
            if (cu == null) {
                return null;
            }
            try {
                int sourceStart = ((LocalTypeBinding)referenceBinding).sourceStart;
                return (JavaElement)cu.getElementAt(sourceStart);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return null;
            }
        }
        if (fileName == null) {
            return null;
        }
        ITypeBinding declaringTypeBinding = null;
        declaringTypeBinding = this.isArray() ? this.getElementType().getDeclaringClass() : this.getDeclaringClass();
        if (declaringTypeBinding == null) {
            if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(fileName)) {
                ClassFile classFile = (ClassFile)this.getClassFile(fileName);
                if (classFile == null) {
                    return null;
                }
                return (JavaElement)((Object)classFile.getType());
            }
            IJavaScriptUnit cu = this.getCompilationUnit(fileName);
            if (cu == null) {
                return null;
            }
            return (JavaElement)((Object)cu.getType(new String(referenceBinding.sourceName())));
        }
        IType declaringType = (IType)declaringTypeBinding.getJavaElement();
        if (declaringType == null) {
            return null;
        }
        return (JavaElement)((Object)declaringType.getType(new String(referenceBinding.sourceName())));
    }

    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    public int getKind() {
        return 2;
    }

    public int getModifiers() {
        if (this.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int accessFlags = referenceBinding.getAccessFlags() & 0xC1F;
            if (referenceBinding.isAnonymousType()) {
                return accessFlags & 0xFFFFFFEF;
            }
            return accessFlags;
        }
        return 0;
    }

    public String getName() {
        switch (this.binding.kind()) {
            case 68: {
                ITypeBinding elementType = this.getElementType();
                if (elementType.isLocal() || elementType.isAnonymous()) {
                    return NO_NAME;
                }
                int dimensions = this.getDimensions();
                char[] brackets = new char[dimensions * 2];
                int i = dimensions * 2 - 1;
                while (i >= 0) {
                    brackets[i] = 93;
                    brackets[i - 1] = 91;
                    i -= 2;
                }
                StringBuffer buffer = new StringBuffer(elementType.getName());
                buffer.append(brackets);
                return String.valueOf(buffer);
            }
        }
        if (this.isPrimitive() || this.isNullType()) {
            BaseTypeBinding baseTypeBinding = (BaseTypeBinding)this.binding;
            return new String(baseTypeBinding.simpleName);
        }
        if (this.isAnonymous()) {
            return NO_NAME;
        }
        return new String(this.binding.sourceName());
    }

    public IPackageBinding getPackage() {
        switch (this.binding.kind()) {
            case 68: 
            case 132: {
                return null;
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        return this.resolver.getPackageBinding(referenceBinding.getPackage());
    }

    private IPackageFragment getPackageFragment(char[] fileName, int pkgEnd, int jarSeparator) {
        if (jarSeparator != -1) {
            String jarMemento = new String(fileName, 0, jarSeparator);
            IPackageFragmentRoot root = (IPackageFragmentRoot)JavaScriptCore.create(jarMemento);
            if (pkgEnd == jarSeparator) {
                return root.getPackageFragment(NO_NAME);
            }
            char[] pkgName = CharOperation.subarray(fileName, jarSeparator + 1, pkgEnd);
            CharOperation.replace(pkgName, '/', '.');
            return root.getPackageFragment(new String(pkgName));
        }
        Path path = new Path(new String(fileName, 0, pkgEnd));
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Object folder = path.segmentCount() == 1 ? workspaceRoot.getProject(path.lastSegment()) : workspaceRoot.getFolder((IPath)path);
        IJavaScriptElement element = JavaScriptCore.create((IResource)folder);
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 4: {
                return (IPackageFragment)element;
            }
            case 3: {
                return ((IPackageFragmentRoot)element).getPackageFragment(NO_NAME);
            }
            case 2: {
                IPackageFragmentRoot root = ((IJavaScriptProject)element).getPackageFragmentRoot((IResource)folder);
                if (root == null) {
                    return null;
                }
                return root.getPackageFragment(NO_NAME);
            }
        }
        return null;
    }

    public String getQualifiedName() {
        switch (this.binding.kind()) {
            case 68: {
                ITypeBinding elementType = this.getElementType();
                if (elementType.isLocal() || elementType.isAnonymous()) {
                    return NO_NAME;
                }
                int dimensions = this.getDimensions();
                char[] brackets = new char[dimensions * 2];
                int i = dimensions * 2 - 1;
                while (i >= 0) {
                    brackets[i] = 93;
                    brackets[i - 1] = 91;
                    i -= 2;
                }
                StringBuffer buffer = new StringBuffer(elementType.getQualifiedName());
                buffer.append(brackets);
                return String.valueOf(buffer);
            }
        }
        if (this.isAnonymous() || this.isLocal()) {
            return NO_NAME;
        }
        if (this.isPrimitive() || this.isNullType()) {
            BaseTypeBinding baseTypeBinding = (BaseTypeBinding)this.binding;
            return new String(baseTypeBinding.simpleName);
        }
        if (this.isMember()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getDeclaringClass().getQualifiedName()).append('.');
            buffer.append(this.getName());
            return String.valueOf(buffer);
        }
        PackageBinding packageBinding = this.binding.getPackage();
        StringBuffer buffer = new StringBuffer();
        if (packageBinding != null && packageBinding.compoundName != CharOperation.NO_CHAR_CHAR) {
            buffer.append(CharOperation.concatWith(packageBinding.compoundName, '.')).append('.');
        }
        buffer.append(this.getName());
        return String.valueOf(buffer);
    }

    public synchronized ITypeBinding getSuperclass() {
        if (this.binding == null) {
            return null;
        }
        switch (this.binding.kind()) {
            case 68: 
            case 132: {
                return null;
            }
        }
        ReferenceBinding superclass = null;
        try {
            superclass = ((ReferenceBinding)this.binding).superclass();
        }
        catch (RuntimeException e) {
            Util.log(e, "Could not retrieve superclass");
            return this.resolver.resolveWellKnownType("Object");
        }
        if (superclass == null) {
            return null;
        }
        return this.resolver.getTypeBinding(superclass);
    }

    public boolean isAnonymous() {
        if (this.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isAnonymousType();
        }
        return false;
    }

    public boolean isArray() {
        return this.binding.isArrayType();
    }

    public boolean isAssignmentCompatible(ITypeBinding type) {
        CompilationUnitScope scope;
        TypeBinding other;
        block7: {
            block6: {
                block5: {
                    try {
                        if (this != type) break block5;
                        return true;
                    }
                    catch (AbortCompilation abortCompilation) {
                        return false;
                    }
                }
                if (type instanceof TypeBinding) break block6;
                return false;
            }
            other = (TypeBinding)type;
            scope = this.resolver.scope();
            if (scope != null) break block7;
            return false;
        }
        return this.binding.isCompatibleWith(other.binding) || scope.isBoxingCompatibleWith(this.binding, other.binding);
    }

    public boolean isCastCompatible(ITypeBinding type) {
        CompilationUnitScope scope;
        Expression expression;
        block5: {
            block4: {
                try {
                    expression = new Expression(){

                        public StringBuffer printExpression(int indent, StringBuffer output) {
                            return null;
                        }
                    };
                    scope = this.resolver.scope();
                    if (scope != null) break block4;
                    return false;
                }
                catch (AbortCompilation abortCompilation) {
                    return false;
                }
            }
            if (type instanceof TypeBinding) break block5;
            return false;
        }
        org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding expressionType = ((TypeBinding)type).binding;
        return expression.checkCastTypesCompatibility(scope, this.binding, expressionType, null);
    }

    public boolean isClass() {
        return this.binding.isClass();
    }

    public boolean isDeprecated() {
        if (this.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isDeprecated();
        }
        return false;
    }

    public boolean isEqualTo(IBinding other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TypeBinding)) {
            return false;
        }
        org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding otherBinding = ((TypeBinding)other).binding;
        return BindingComparator.isEqual(this.binding, otherBinding);
    }

    public boolean isFromSource() {
        if (this.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return !referenceBinding.isBinaryBinding();
        }
        return false;
    }

    public boolean isLocal() {
        if (this.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isLocalType() && !referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isMember() {
        if (this.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isNested() {
        if (this.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isNestedType();
        }
        return false;
    }

    public boolean isNullType() {
        return this.binding == org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding.NULL;
    }

    public boolean isPrimitive() {
        return !this.isNullType() && this.binding.isBaseType();
    }

    public boolean isRecovered() {
        return false;
    }

    public boolean isSubTypeCompatible(ITypeBinding type) {
        TypeBinding other;
        block9: {
            block8: {
                block7: {
                    block6: {
                        try {
                            if (this != type) break block6;
                            return true;
                        }
                        catch (AbortCompilation abortCompilation) {
                            return false;
                        }
                    }
                    if (!this.binding.isBaseType()) break block7;
                    return false;
                }
                if (type instanceof TypeBinding) break block8;
                return false;
            }
            other = (TypeBinding)type;
            if (!other.binding.isBaseType()) break block9;
            return false;
        }
        return this.binding.isCompatibleWith(other.binding);
    }

    public boolean isTopLevel() {
        if (this.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return !referenceBinding.isNestedType();
        }
        return false;
    }

    private boolean shouldBeRemoved(MethodBinding methodBinding) {
        return methodBinding.isDefaultAbstract();
    }

    public String toString() {
        return this.binding.toString();
    }

    public boolean isCompilationUnit() {
        return false;
    }
}

