/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.rnceditor;

import com.objfac.rnceditor.RNCEditor;
import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.template.IVariable;
import com.objfac.xmleditor.template.Template;
import com.objfac.xmleditor.template.TemplateContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class RNCCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension {
    private String fDisplay;
    private String fReplace;
    private int fOffset;
    private Image fImage;
    private IContextInformation fContextInfo;
    private String fProposalInfo;
    private char[] fTrigger;
    private Point fSelection;
    private IVariable[] fVariables;
    public static final char[] TRIGGER = new char[]{'\n', '\t'};

    public RNCCompletionProposal(String string, String string2, int n, char[] cArray, IVariable[] iVariableArray) {
        this(string, string2, n, cArray, iVariableArray, null, null, null);
    }

    public RNCCompletionProposal(String string, String string2, int n, char[] cArray, IVariable[] iVariableArray, Image image, IContextInformation iContextInformation, String string3) {
        this.fDisplay = string;
        this.fReplace = string2;
        this.fTrigger = cArray;
        this.fOffset = n;
        this.fVariables = iVariableArray;
        this.fImage = image;
        this.fContextInfo = iContextInformation;
        this.fProposalInfo = string3;
    }

    public void apply(IDocument iDocument) {
        throw new IllegalStateException("ICompletionProposal#apply(IDocument) should not be called");
    }

    public Point getSelection(IDocument iDocument) {
        return this.fSelection;
    }

    public String getAdditionalProposalInfo() {
        return this.fProposalInfo;
    }

    public String getDisplayString() {
        return this.fDisplay;
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return this.fContextInfo;
    }

    public void apply(IDocument iDocument, char c, int n) {
        int n2;
        this.adjustCursor(iDocument, c, n);
        Template template = Template.REUSABLE_TEMPLATE;
        template.setPattern(this.fReplace);
        Point point = new Point(-1, -1);
        String string = template.replace(new TemplateContext(c), this.fVariables, point);
        RNCEditor rNCEditor = (RNCEditor)RNCEditor.getEditorForDocument(iDocument);
        int n3 = n;
        if (rNCEditor != null && n3 < (n2 = rNCEditor.getWatchPos(-1))) {
            n3 = n2;
        }
        n2 = this.fOffset;
        int n4 = n3 - this.fOffset;
        try {
            iDocument.replace(n2, n4, string);
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        if (point.x >= 0) {
            point.x += this.fOffset;
        } else {
            point.x = n2 + string.length();
            point.y = 0;
        }
        this.fSelection = point;
    }

    private void adjustCursor(IDocument iDocument, char c, int n) {
        switch (c) {
            case '\\': {
                ISourceViewer iSourceViewer;
                int n2 = this.fReplace.indexOf("</");
                RNCEditor rNCEditor = (RNCEditor)RNCEditor.getEditorForDocument(iDocument);
                if (n2 < 0 || rNCEditor == null || (iSourceViewer = rNCEditor.getViewer()) == null) break;
                StyledText styledText = iSourceViewer.getTextWidget();
                String string = this.fReplace.substring(n2);
                this.fReplace = this.fReplace.substring(0, n2);
                Clipboard clipboard = new Clipboard(styledText.getDisplay());
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents(new Object[]{string}, new Transfer[]{textTransfer});
                clipboard.dispose();
                this.fReplace = this.moveCursorToPos(this.fReplace, n2);
                break;
            }
            case '<': {
                int n3 = this.fReplace.indexOf(60);
                if (n3 < 0) break;
                this.fReplace = this.moveCursorToPos(this.fReplace, n3);
                break;
            }
            case ',': {
                int n4 = this.fReplace.indexOf(60);
                if (n4 < 0) break;
                try {
                    IRegion iRegion = iDocument.getLineInformationOfOffset(n);
                    String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                    char[] cArray = string.toCharArray();
                    int n5 = 0;
                    int n6 = n - iRegion.getOffset();
                    StringBuffer stringBuffer = new StringBuffer();
                    while (n5 < n6 && XMLCharacter.isWhitespace((char)cArray[n5])) {
                        stringBuffer.append(cArray[n5]);
                        ++n5;
                    }
                    int n7 = 0;
                    while (n5 < n6) {
                        if (cArray[n5] == '<') {
                            ++n7;
                        }
                        ++n5;
                    }
                    if (n7 <= 0) break;
                    String string2 = System.getProperty("line.separator", "\n");
                    String string3 = iDocument.getLineDelimiter(0);
                    if (string3 != null && string3.length() > 0 && !string3.equals(string2)) {
                        string2 = string3;
                    }
                    String string4 = stringBuffer.toString();
                    this.fReplace = n7 == 1 ? String.valueOf(this.fReplace.substring(0, n4)) + string2 + string4 + '\t' + string2 + string4 + this.fReplace.substring(n4) : String.valueOf(this.fReplace.substring(0, n4)) + string2 + string4 + '\t' + this.fReplace.substring(n4);
                    this.fReplace = this.moveCursorToPos(this.fReplace, n4 += string2.length() + string4.length() + 1);
                    break;
                }
                catch (BadLocationException badLocationException) {
                    XMLPlugin.log(badLocationException);
                }
            }
        }
    }

    private String moveCursorToPos(String string, int n) {
        int n2 = string.indexOf("${cursor}");
        if (n2 >= 0) {
            int n3 = "${cursor}".length();
            if (n > n2) {
                n -= n3;
            }
            string = String.valueOf(string.substring(0, n2)) + string.substring(n2 + n3);
        }
        string = String.valueOf(string.substring(0, n)) + "${cursor}" + string.substring(n);
        return string;
    }

    public boolean isValidFor(IDocument iDocument, int n) {
        String string;
        if (n < this.fOffset) {
            return false;
        }
        try {
            string = iDocument.get(this.fOffset, n - this.fOffset);
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
            return false;
        }
        String string2 = this.fDisplay.substring(0, Math.min(this.fDisplay.length(), string.length()));
        return string2.equalsIgnoreCase(string);
    }

    public char[] getTriggerCharacters() {
        return this.fTrigger;
    }

    public int getContextInformationPosition() {
        return -1;
    }
}

