/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.rnceditor;

import com.objfac.rnceditor.RNCNode;
import com.objfac.util.Misc;
import com.objfac.xmleditor.IOutlineTree;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.partition.DocumentWrapper;
import com.objfac.xmleditor.partition.FilterIterator;
import com.objfac.xmleditor.partition.IAbstractDocument;
import com.objfac.xmleditor.partition.XMLPartitioner;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLNodeTree;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class RNCTree
extends XMLNodeTree
implements IOutlineTree {
    private XMLNode fLastHead;
    private Position[] fPositions;
    private boolean fIncremental = true;
    private int fCommonIndex;
    private static boolean fXMLRules = true;
    private static final LinkedList EMPTY = new LinkedList();
    private LinkedList fChanges = EMPTY;
    private DocumentWrapper fDocument = new DocumentWrapper(null);
    static long parsebeg;
    static long parseend;
    static long parseave;
    static long parsecum;
    static long parsenum;
    private int fPos;
    private RNCNode fTopSibling;
    protected final Position fFindPosition = new Position(0);

    static {
        parsecum = 0L;
        parsenum = 0L;
    }

    public synchronized XMLNode getHead() {
        if (this.fHead == null && this.fPositions != null) {
            this.fChanges = new LinkedList();
            this.checkDeleted(this.fLastHead);
            this.buildTree();
            this.checkAddedModified(this.fHead);
        }
        return this.fHead;
    }

    public void updateTree(IDocument iDocument, Position[] positionArray, int n) {
        this.fDocument.setDocument(iDocument);
        this.updateTree(this.fDocument, positionArray, n);
    }

    public void updateTree(IAbstractDocument iAbstractDocument, Position[] positionArray, int n) {
        this.fChanges = EMPTY;
        if (this.fHead == null) {
            this.buildTree(iAbstractDocument, positionArray);
        } else {
            this.repairTree(iAbstractDocument, positionArray, n);
        }
        this.fPositions = positionArray;
    }

    private void repairTree(IAbstractDocument iAbstractDocument, Position[] positionArray, int n) {
        this.fPositions = positionArray;
        if (this.fHead != null) {
            this.fLastHead = this.fHead;
            this.fHead = null;
        }
        this.fIncremental = true;
    }

    private void buildTree(IAbstractDocument iAbstractDocument, Position[] positionArray) {
        this.fPositions = positionArray;
        this.buildTree();
    }

    private void buildTree() {
        if (this.fPositions.length == 0) {
            return;
        }
        this.fPos = 0;
        this.fTopSibling = null;
        this.parseTree();
    }

    private void parseTree() {
        block3: {
            ++parsenum;
            parsebeg = System.currentTimeMillis();
            try {
                this.parseDecls();
                if (this.parsePattern(null) == null) {
                    this.parseGrammarContents(null, true);
                }
            }
            catch (Throwable throwable) {
                XMLPlugin.log(throwable);
                if (!(throwable instanceof Error)) break block3;
                throw (Error)throwable;
            }
        }
        parseend = System.currentTimeMillis();
        parseave = (parsecum += parseend - parsebeg) / parsenum;
    }

    private void parseGrammarContents(RNCNode rNCNode, boolean bl) {
        while (this.parseGrammarContent(rNCNode, bl) != null) {
        }
    }

    private RNCNode parseGrammarContent(RNCNode rNCNode, boolean bl) {
        RNCNode rNCNode2 = this.nextNode();
        while (rNCNode2 != null && this.isPatternNoise(rNCNode, rNCNode2)) {
            rNCNode2 = this.nextNode();
        }
        if (rNCNode2 == null) {
            return null;
        }
        String string = rNCNode2.getType();
        if (string == "com.objfac.rncdefine" || string == "com.objfac.rncdiv" || bl && string == "com.objfac.rncinclude" || string == "com.objfac.rncstart") {
            this.linkNode(rNCNode2, rNCNode);
            rNCNode2.getQName();
            boolean bl2 = this.hasContent(rNCNode2);
            if ((string == "com.objfac.rncdefine" || string == "com.objfac.rncstart") && this.hasEqual(rNCNode2)) {
                this.parsePattern(rNCNode2);
            } else if (string == "com.objfac.rncdiv" && bl2) {
                this.parseGrammarContents(rNCNode2, bl);
            } else if (string == "com.objfac.rncinclude" && bl2) {
                this.parseGrammarContents(rNCNode2, false);
            }
            return rNCNode2;
        }
        this.pushNode();
        return null;
    }

    private void parseDatatypeContents(RNCNode rNCNode) {
        RNCNode rNCNode2;
        boolean bl;
        block7: {
            bl = false;
            rNCNode2 = this.nextNode();
            while (true) {
                if (rNCNode2 != null && this.isDatatypeNoise(rNCNode, rNCNode2)) {
                    rNCNode2 = this.nextNode();
                    continue;
                }
                if (rNCNode2 == null) {
                    return;
                }
                if (rNCNode2.getType() != "com.objfac.rncdefine") break block7;
                this.linkNode(rNCNode2, rNCNode);
                if (!this.hasEqual(rNCNode2)) continue;
                RNCNode rNCNode3 = this.nextNode();
                if (rNCNode3.getType() != "com.objfac.rncvalue") break;
                this.linkNode(rNCNode3, rNCNode2);
                rNCNode2 = this.nextNode();
            }
            bl = true;
        }
        if (rNCNode2.getType() != "com.objfac.rncend") {
            this.pushNode();
            return;
        }
        if (bl) {
            return;
        }
        while ((rNCNode2 = this.nextNode()) != null && this.isDatatypeNoise(rNCNode, rNCNode2)) {
        }
        if (rNCNode2 != null && rNCNode2.getType() != "com.objfac.rncexcept") {
            this.pushNode();
            return;
        }
        this.parsePattern(rNCNode);
    }

    private boolean hasEqual(RNCNode rNCNode) {
        String string = rNCNode.getContents();
        return string.endsWith("=") || string.endsWith("|=") || string.endsWith("&=");
    }

    private RNCNode parsePattern(RNCNode rNCNode) {
        RNCNode rNCNode2 = this.nextNode();
        while (rNCNode2 != null && this.isDatatypeNoise(rNCNode, rNCNode2)) {
            rNCNode2 = this.nextNode();
        }
        if (rNCNode2 == null) {
            return null;
        }
        if (rNCNode2.getType() == "com.objfac.rnclparen") {
            rNCNode2 = this.parsePattern(rNCNode);
            return null;
        }
        if (rNCNode2.getType() == "com.objfac.rncrparen") {
            return rNCNode2;
        }
        if (rNCNode2 == null) {
            return null;
        }
        rNCNode2.getContents();
        String string = rNCNode2.getType();
        if (string == "com.objfac.rncempty" || string == "com.objfac.rnctext" || string == "com.objfac.rncelement" || string == "com.objfac.rncattribute" || string == "com.objfac.rnclist" || string == "com.objfac.rncmixed" || string == "com.objfac.rncgrammar" || string == "com.objfac.rncnotallowed" || string == "com.objfac.rncvalue" || string == "com.objfac.rncdatatype" || string == "com.objfac.rncexternal" || string == "com.objfac.rncref") {
            block16: {
                this.linkNode(rNCNode2, rNCNode);
                if (string == "com.objfac.rncgrammar" && this.hasContent(rNCNode2)) {
                    this.parseGrammarContents(rNCNode2, true);
                    this.parseEnd(rNCNode2);
                } else if ((string == "com.objfac.rncelement" || string == "com.objfac.rncattribute" || string == "com.objfac.rnclist" || string == "com.objfac.rncmixed") && this.hasContent(rNCNode2)) {
                    this.parsePattern(rNCNode2);
                    this.parseEnd(rNCNode2);
                } else if (string == "com.objfac.rncdatatype" && this.hasExcept(rNCNode2)) {
                    this.parsePattern(rNCNode2);
                } else if (string == "com.objfac.rncdatatype" && this.hasContent(rNCNode2)) {
                    this.parseDatatypeContents(rNCNode2);
                }
                while (true) {
                    RNCNode rNCNode3 = this.nextNode();
                    while (rNCNode3 != null && (this.isDatatypeNoise(rNCNode, rNCNode3) || this.isModifier(rNCNode3))) {
                        rNCNode3 = this.nextNode();
                    }
                    if (rNCNode3 == null) break block16;
                    String string2 = rNCNode3.getType();
                    if (string2 == "com.objfac.rnclparen") {
                        this.parsePattern(rNCNode);
                        continue;
                    }
                    if (string2 == "com.objfac.rncrparen") break block16;
                    if (string2 != "com.objfac.rncor" && string2 != "com.objfac.rnccomma" && string2 != "com.objfac.rncamp") break;
                    this.parsePattern(rNCNode);
                }
                this.pushNode();
            }
            return rNCNode2;
        }
        this.pushNode();
        return null;
    }

    private boolean isModifier(RNCNode rNCNode) {
        String string = rNCNode.getType();
        return string == "com.objfac.rncstar" || string == "com.objfac.rncquestion" || string == "com.objfac.rncplus";
    }

    private void parseEnd(RNCNode rNCNode) {
        RNCNode rNCNode2 = this.nextNode();
        while (rNCNode2 != null && this.isPatternNoise(rNCNode, rNCNode2)) {
            rNCNode2 = this.nextNode();
        }
        if (rNCNode2 != null) {
            String string = rNCNode2.getType();
            if (string != "com.objfac.rncend") {
                this.pushNode();
            } else {
                this.linkNode(rNCNode2, rNCNode);
            }
        }
    }

    private boolean hasExcept(RNCNode rNCNode) {
        String string = rNCNode.getContents();
        return string.endsWith("-");
    }

    private boolean hasContent(RNCNode rNCNode) {
        String string = rNCNode.getContents();
        return string.endsWith("{");
    }

    private boolean isPatternNoise(RNCNode rNCNode, RNCNode rNCNode2) {
        String string = rNCNode2.getType();
        if (string == "com.objfac.rncanno") {
            return this.parseAnnotation(rNCNode, rNCNode2);
        }
        return this.isDeclNoise(rNCNode, rNCNode2) || string == "com.objfac.rncrparen" || string == "com.objfac.rnclparen";
    }

    private boolean isDatatypeNoise(RNCNode rNCNode, RNCNode rNCNode2) {
        String string = rNCNode2.getType();
        if (string == "com.objfac.rncanno") {
            return this.parseAnnotation(rNCNode, rNCNode2);
        }
        return this.isDeclNoise(rNCNode, rNCNode2);
    }

    private void parseDecls() {
        boolean bl;
        RNCNode rNCNode = this.nextNode();
        while (rNCNode != null && ((bl = this.isDecl(rNCNode)) || this.isDeclNoise(null, rNCNode))) {
            if (bl) {
                this.linkNode(rNCNode, null);
            }
            rNCNode = this.nextNode();
        }
        this.pushNode();
    }

    private boolean isDeclNoise(RNCNode rNCNode, RNCNode rNCNode2) {
        String string = rNCNode2.getType();
        if (string == "com.objfac.rncanno") {
            return this.parseAnnotation(rNCNode, rNCNode2);
        }
        return string == "com.objfac.rncws" || string == "com.objfac.rnccomment" || string == "com.objfac.rncdocumentation";
    }

    private boolean parseAnnotation(RNCNode rNCNode, RNCNode rNCNode2) {
        this.linkNode(rNCNode2, rNCNode);
        RNCNode rNCNode3 = this.nextNode();
        while (rNCNode3 != null) {
            String string = rNCNode3.getType();
            if (string != "com.objfac.rncanno") {
                if (string == "com.objfac.rncannoend") {
                    this.linkNode(rNCNode3, rNCNode2);
                    break;
                }
                this.pushNode();
                break;
            }
            this.parseAnnotation(rNCNode2, rNCNode3);
            rNCNode3 = this.nextNode();
        }
        return true;
    }

    private boolean isDecl(RNCNode rNCNode) {
        String string = rNCNode.getType();
        return string == "com.objfac.rncnamespace" || string == "com.objfac.rncdefault" || string == "com.objfac.rncdatatypes";
    }

    private void linkNode(RNCNode rNCNode, RNCNode rNCNode2) {
        rNCNode.nextSibling = null;
        rNCNode.lastChild = null;
        rNCNode.firstChild = null;
        rNCNode.parent = null;
        rNCNode.inTree = true;
        if (rNCNode2 == null) {
            if (this.fTopSibling != null) {
                this.fTopSibling.nextSibling = rNCNode;
            } else {
                this.fHead = rNCNode;
            }
            this.fTopSibling = rNCNode;
        } else {
            rNCNode.parent = rNCNode2;
            if (rNCNode2.lastChild == null) {
                rNCNode2.lastChild = rNCNode2.firstChild = rNCNode;
            } else {
                rNCNode2.lastChild.nextSibling = rNCNode;
                rNCNode2.lastChild = rNCNode;
            }
        }
    }

    private void pushNode() {
        if (this.fPos == 0) {
            throw new IllegalStateException();
        }
        --this.fPos;
    }

    private RNCNode nextNode() {
        if (this.fPos == this.fPositions.length) {
            return null;
        }
        return (RNCNode)this.fPositions[this.fPos++];
    }

    public boolean isIncremental() {
        return this.fIncremental;
    }

    public List getIncrementalChanges(FilterIterator filterIterator) {
        this.getHead();
        LinkedList<RNCNode> linkedList = new LinkedList<RNCNode>();
        if (this.fChanges == null) {
            return linkedList;
        }
        Iterator iterator = this.fChanges.iterator();
        while (iterator.hasNext()) {
            RNCNode rNCNode = (RNCNode)iterator.next();
            if (!filterIterator.pass(rNCNode)) continue;
            linkedList.add(rNCNode);
        }
        return linkedList;
    }

    private void checkDeleted(XMLNode xMLNode) {
        while (xMLNode != null) {
            this.checkDeleted(xMLNode, this.fChanges);
            xMLNode = xMLNode.getNextSibling();
        }
    }

    private void checkAddedModified(XMLNode xMLNode) {
        while (xMLNode != null) {
            this.checkAddedModified(xMLNode, this.fChanges);
            xMLNode = xMLNode.getNextSibling();
        }
    }

    private void checkDeleted(XMLNode xMLNode, LinkedList linkedList) {
        if (xMLNode == null) {
            return;
        }
        if (xMLNode.isDeleted()) {
            linkedList.add(xMLNode);
        }
        RNCNode rNCNode = (RNCNode)xMLNode.getFirstChild();
        while (rNCNode != null) {
            this.checkDeleted(rNCNode, linkedList);
            rNCNode = (RNCNode)rNCNode.getNextSibling();
        }
    }

    private void checkAddedModified(XMLNode xMLNode, LinkedList linkedList) {
        if (xMLNode == null) {
            return;
        }
        if (xMLNode.added || xMLNode.modified) {
            linkedList.add(xMLNode);
        }
        xMLNode.added = false;
        xMLNode.modified = false;
        RNCNode rNCNode = (RNCNode)xMLNode.getFirstChild();
        while (rNCNode != null) {
            this.checkAddedModified(rNCNode, linkedList);
            rNCNode = (RNCNode)rNCNode.getNextSibling();
        }
    }

    public XMLNode findNode(int n) {
        RNCNode rNCNode = (RNCNode)this.getHead();
        if (rNCNode == null) {
            return null;
        }
        return this.findSibling(rNCNode, n);
    }

    private XMLNode findSibling(RNCNode rNCNode, int n) {
        RNCNode rNCNode2 = rNCNode;
        while (rNCNode2 != null) {
            XMLNode xMLNode;
            if (rNCNode2.getOffset() + rNCNode2.getLength() > n) {
                return rNCNode2;
            }
            RNCNode rNCNode3 = (RNCNode)rNCNode2.getFirstChild();
            if (rNCNode3 != null && (xMLNode = this.findSibling(rNCNode3, n)) != null) {
                return xMLNode;
            }
            rNCNode2 = (RNCNode)rNCNode2.getNextSibling();
        }
        return null;
    }

    public Position[] getPositions() {
        this.getHead();
        return this.fPositions;
    }

    public RNCNode fastFindNode(int n) {
        int n2 = this.findIndex(this.fPositions, n);
        if (n2 >= 0) {
            return (RNCNode)this.fPositions[n2];
        }
        return null;
    }

    protected int findIndex(Position[] positionArray, int n) {
        this.fFindPosition.setOffset(n);
        int n2 = Misc.findRange((Object[])positionArray, (Object)this.fFindPosition, (Comparator)XMLPartitioner.POSITION_COMPARATOR);
        return n2;
    }

    public String getDoctypeContents(boolean bl) {
        return null;
    }
}

