/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.util.Local;
import com.objfac.xmleditor.Config;
import com.objfac.xmleditor.DTDParams;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.Storage;
import com.objfac.xmleditor.dtd.DTDDecl;
import com.objfac.xmleditor.validate.ErrorCollector;
import com.objfac.xmleditor.validate.Flattener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class FlattenDTDAction
implements IEditorActionDelegate {
    private XMLEditor fEditor;
    private static final String DTD_EXTENSION = ".dtd";
    private static final String FLAT = "_flat";
    static /* synthetic */ Class class$0;

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        if (iEditorPart instanceof IAdaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.objfac.xmleditor.XMLEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fEditor = (XMLEditor)iEditorPart.getAdapter((Class)clazz);
        } else {
            this.fEditor = null;
        }
        iAction.setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        if (Config.pro()) {
            if (this.fEditor == null) {
                return false;
            }
            if (this.fEditor.getEditorKind() == 1) {
                return true;
            }
            DTDParams dTDParams = this.fEditor.getDTDParams();
            if (dTDParams.beg != dTDParams.end || dTDParams.pub != null || dTDParams.sys != null || dTDParams.epub != null || dTDParams.esys != null) {
                return true;
            }
        }
        return false;
    }

    public void run(IAction iAction) {
        IDocument iDocument;
        if (!this.isEnabled()) {
            return;
        }
        if (this.fEditor != null && (iDocument = this.fEditor.getDocument()) != null) {
            String string;
            IEditorInput iEditorInput = this.fEditor.getEditorInput();
            String string2 = string = iEditorInput.getName();
            int n = string.lastIndexOf(46);
            string = n > 0 ? String.valueOf(string.substring(0, n)) + FLAT + DTD_EXTENSION : String.valueOf(string) + "_flat.dtd";
            Flattener flattener = new Flattener();
            ErrorCollector errorCollector = new ErrorCollector();
            DTDDecl dTDDecl = flattener.parse(false, this.fEditor, errorCollector);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"));
                printWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                String[] stringArray = iDocument.getLegalLineDelimiters();
                String string3 = stringArray[stringArray.length - 1];
                printWriter.write(string3);
                String string4 = Local.format((String)"<!-- Flattened DTD generated from {0} by XMLBuddy -->", (Object)string2);
                printWriter.write(string4);
                printWriter.write(string3);
                dTDDecl.print(printWriter);
                printWriter.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Storage storage = new Storage(byArray, string, string2);
                IWorkbenchPage iWorkbenchPage = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (iWorkbenchPage != null) {
                    try {
                        iWorkbenchPage.openEditor((IEditorInput)storage, "com.objfac.xmleditor.XMLEditor.dtd");
                    }
                    catch (PartInitException partInitException) {
                        XMLPlugin.log(partInitException);
                    }
                }
            }
            catch (IOException iOException) {
                XMLPlugin.log(iOException);
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }
}

