/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.io.Encoding;
import com.objfac.xml.io.IDocumentReaderFactory;
import com.objfac.xml.schema.impl.ExternalEntity;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.ActionUtils;
import com.objfac.xmleditor.actions.CharArrayInputStream;
import com.objfac.xmleditor.actions.Storage;
import com.objfac.xmleditor.actions.TransformDialog;
import com.objfac.xmleditor.partition.scanner.XMLParser;
import com.objfac.xmleditor.resources.PluginFactoryExtension;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.validate.BuiltinTransformerShell;
import com.objfac.xmleditor.validate.ITransformResult;
import com.objfac.xmleditor.validate.TransformArguments;
import com.objfac.xmleditor.validate.TransformerShell;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class TransformAction
extends Action {
    private XMLEditor fEditor;
    private static final String JAXP_TRANSFORMER_FACTORY = "javax.xml.transform.TransformerFactory";
    private static final String JAXP_TRANSFORMER_SHELL = "com.objfac.xmleditor.validate.JavaxTransformerShell";
    static /* synthetic */ Class class$0;

    public TransformAction(XMLEditor xMLEditor) {
        this.fEditor = xMLEditor;
        this.setText(Local.getString((String)"Transform..."));
        this.setToolTipText(Local.getString((String)"Do an XSLT transform"));
        this.setAccelerator(262228);
    }

    public void run() {
        TransformDialog transformDialog = new TransformDialog(this.fEditor.getEditorKind() == 6, this.fEditor.getViewer().getTextWidget().getShell(), this.fEditor.getFile(), this.fEditor.getTransformUri());
        TransformArguments transformArguments = transformDialog.show();
        if (transformArguments != null) {
            TransformAction.doTransform(this.fEditor, transformArguments);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doTransform(XMLEditor xMLEditor, TransformArguments transformArguments) {
        block37: {
            Object object;
            String string = XMLPlugin.getDefault().getXSLTProcessor();
            ITransformResult[] iTransformResultArray = null;
            boolean bl = true;
            if ("javax".equals(string)) {
                try {
                    Class.forName(JAXP_TRANSFORMER_FACTORY);
                    object = Class.forName(JAXP_TRANSFORMER_SHELL);
                    TransformerShell transformerShell = (TransformerShell)((Class)object).newInstance();
                    iTransformResultArray = transformerShell.transform(xMLEditor, transformArguments, xMLEditor.getResourceWatcherCallback());
                    bl = false;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            if (bl) {
                object = new BuiltinTransformerShell();
                iTransformResultArray = ((BuiltinTransformerShell)object).transform(xMLEditor, transformArguments, xMLEditor.getResourceWatcherCallback());
            }
            if ((object = TransformAction.getXMLTree(xMLEditor, transformArguments.inputUri)) == null || iTransformResultArray == null) break block37;
            int n = 0;
            while (n < iTransformResultArray.length) {
                String string2;
                IEditorDescriptor iEditorDescriptor;
                String string3;
                Object object2;
                String string4;
                block38: {
                    Object object3;
                    string4 = iTransformResultArray[n].getSystemId();
                    if (transformArguments.outputFile == null) break block38;
                    String string5 = string4 != null ? Misc.getAbsUrl((String)xMLEditor.getUrl(), (String)string4) : Misc.getAbsUrl((String)xMLEditor.getUrl(), (String)transformArguments.outputFile);
                    if (!string5.startsWith("file:///")) {
                        TransformAction.error(Local.format((String)"Can''t write to non-file URI {0}", (Object)string5), xMLEditor);
                        return;
                    }
                    object2 = iTransformResultArray[n].getContents();
                    string3 = TransformAction.getEncoding((char[])object2);
                    String string6 = string5.substring("file:///".length());
                    iEditorDescriptor = new Path(string6);
                    IFile iFile = XMLPlugin.getWorkspace().getRoot().getFileForLocation((IPath)iEditorDescriptor);
                    if (iFile != null) {
                        object3 = new CharArrayInputStream((char[])object2, string3);
                        if (!iFile.exists()) {
                            try {
                                iFile.create((InputStream)object3, true, null);
                            }
                            catch (CoreException coreException) {
                                TransformAction.error(Local.format((String)"Can''t create project file {0}", (Object)string5), xMLEditor);
                                return;
                            }
                        } else {
                            try {
                                iFile.setContents((InputStream)object3, true, true, null);
                            }
                            catch (CoreException coreException) {
                                TransformAction.error(Local.format((String)"Can''t write project file {0}", (Object)string5), xMLEditor);
                                return;
                            }
                        }
                    } else {
                        Writer writer;
                        FileOutputStream fileOutputStream;
                        try {
                            object3 = new URI(string5);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            TransformAction.error(Local.format((String)"Can''t use file uri {0}", (Object)string5), xMLEditor);
                            return;
                        }
                        File file = new File((URI)object3);
                        if (!file.exists()) {
                            try {
                                file.createNewFile();
                            }
                            catch (IOException iOException) {
                                TransformAction.error(Local.format((String)"Can''t create new file {0}", (Object)string5), xMLEditor);
                                return;
                            }
                        }
                        try {
                            fileOutputStream = new FileOutputStream(file);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            TransformAction.error(Local.format((String)"File not found {0}", (Object)string5), xMLEditor);
                            return;
                        }
                        if (string3 != null) {
                            try {
                                writer = new OutputStreamWriter((OutputStream)fileOutputStream, string3);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                writer = new OutputStreamWriter(fileOutputStream);
                            }
                        } else {
                            writer = new OutputStreamWriter(fileOutputStream);
                        }
                        writer = new BufferedWriter(writer);
                        try {
                            writer.write((char[])object2);
                            writer.close();
                        }
                        catch (IOException iOException) {
                            TransformAction.error(Local.format((String)"Error writing file {0}", (Object)string5), xMLEditor);
                            return;
                        }
                    }
                }
                if (string4 == null) {
                    string2 = ActionUtils.getName(xMLEditor.getUrl());
                    object2 = TransformAction.checkOutputDeclaration(xMLEditor.getXMLTree());
                    string2 = ActionUtils.replaceExtension(string2, (String)object2);
                } else {
                    string2 = ActionUtils.getName(string4);
                }
                object2 = ActionUtils.getExtension(string2);
                string3 = XMLConstants.extensionToId((String)object2);
                if (string3 == null) {
                    IEditorRegistry iEditorRegistry = WorkbenchPlugin.getDefault().getEditorRegistry();
                    iEditorDescriptor = iEditorRegistry.getDefaultEditor(string2);
                    if (iEditorDescriptor == null) {
                        iEditorDescriptor = iEditorRegistry.getDefaultEditor();
                    }
                    string3 = iEditorDescriptor.getId();
                }
                Storage storage = new Storage(iTransformResultArray[n].getContents(), string2, string2, "UTF-8");
                iEditorDescriptor = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (iEditorDescriptor != null) {
                    try {
                        iEditorDescriptor.openEditor((IEditorInput)storage, string3);
                    }
                    catch (PartInitException partInitException) {
                        XMLPlugin.log(partInitException);
                    }
                }
                ++n;
            }
        }
    }

    private static String getEncoding(char[] cArray) {
        return Encoding.getEncodingFromXmlDecl((char[])cArray);
    }

    private static void error(String string, XMLEditor xMLEditor) {
        ErrorDialog.openError((Shell)xMLEditor.getViewer().getTextWidget().getShell(), (String)Local.getString((String)"Transform output error"), (String)string, (IStatus)new Status(4, "com.objfac.xmleditor", 2, string, null));
    }

    private static XMLTree getXMLTree(XMLEditor xMLEditor, String string) {
        if (xMLEditor.getEditorKind() == 6) {
            return xMLEditor.getXMLTree();
        }
        IDocumentReaderFactory iDocumentReaderFactory = PluginFactoryExtension.getFactory();
        ExternalEntity externalEntity = new ExternalEntity(null, null, xMLEditor.getUrl(), iDocumentReaderFactory);
        ExternalEntity externalEntity2 = (ExternalEntity)externalEntity.getEntity(null, string);
        try {
            char[] cArray = externalEntity2.getContents();
            XMLParser xMLParser = new XMLParser();
            return xMLParser.parse(cArray);
        }
        catch (IOException iOException) {
            XMLPlugin.log(iOException);
            return null;
        }
    }

    private static String checkOutputDeclaration(XMLTree xMLTree) {
        String string = "xml";
        XMLNode xMLNode = xMLTree.getRoot();
        if (xMLNode != null) {
            XMLNode xMLNode2 = xMLNode.getFirstChild();
            while (xMLNode2 != null) {
                String string2 = xMLNode2.getLocalname();
                String string3 = xMLNode2.getNamespace();
                if ("output".equals(string2) && string3 != null && "http://www.w3.org/1999/XSL/Transform".equals(string3)) {
                    String string4 = xMLNode2.getAttributeValue("method");
                    if (string4 != null) {
                        if ("xml".equals(string4)) {
                            string = "xml";
                        } else if ("html".equals(string4)) {
                            string = "htm";
                        } else if ("xhtml".equals(string4)) {
                            string = "xhtml";
                        } else if ("text".equals(string4)) {
                            string = "txt";
                        }
                    } else {
                        boolean bl = true;
                        Object object = xMLTree.getHead();
                        while (object != null && object != xMLNode) {
                            if (object.getType().equals("com.objfac.xmltext") && !XMLCharacter.isWhitespace((String)((XMLNode)object).getContents())) {
                                bl = false;
                                break;
                            }
                            object = ((XMLNode)object).getNextSibling();
                        }
                        if (bl) {
                            object = xMLNode.getLocalname();
                            String string5 = xMLNode.getNamespace();
                            if ("html".equals(object) && "http://www.w3.org/1999/xhtml".equals(string5)) {
                                string = "xhtml";
                            } else if ("html".equalsIgnoreCase((String)object) && (string5 == null || string5.length() == 0)) {
                                string = "xml";
                            }
                        }
                    }
                }
                xMLNode2 = xMLNode2.getNextElementSibling();
            }
        }
        return string;
    }

    private static String plausibleNameBasedOnContents(String string, char[] cArray) {
        int n = string.lastIndexOf(46);
        String string2 = string;
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return String.valueOf(string2) + ".txt";
    }
}

