/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class XMLNextAction
implements IEditorActionDelegate {
    private XMLEditor fEditor;
    private IDocument fDocument;
    private ISourceViewer fViewer;

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.fEditor = iEditorPart instanceof XMLEditor ? (XMLEditor)iEditorPart : null;
    }

    public void run(IAction iAction) {
        if (this.fEditor != null && this.fEditor instanceof XMLEditor && this.fEditor.getXMLTree() != null && (this.fDocument = this.fEditor.getDocument()) != null) {
            int n = ((ITextSelection)this.fEditor.getSelectionProvider().getSelection()).getOffset();
            this.fViewer = this.fEditor.getViewer();
            XMLTree xMLTree = this.fEditor.getXMLTree();
            if (this.fViewer == null || xMLTree == null) {
                return;
            }
            Position[] positionArray = xMLTree.getPositions();
            int n2 = xMLTree.findNodeIndex(n);
            if (n2 < 0) {
                return;
            }
            XMLNode xMLNode = (XMLNode)positionArray[n2];
            String string = xMLNode.getType();
            int n3 = xMLNode.getOffset();
            int n4 = xMLNode.getLength();
            int n5 = n3 + n4;
            if (n3 == n) {
                XMLNode xMLNode2 = xMLNode;
                while (xMLNode != null && (string == "com.objfac.xmltext" || string == "com.objfac.xmlcdata")) {
                    if (++n2 == positionArray.length) {
                        xMLNode = null;
                        break;
                    }
                    xMLNode2 = xMLNode;
                    xMLNode = (XMLNode)positionArray[n2];
                    string = xMLNode.getType();
                }
                if (xMLNode != null) {
                    this.selectForward(xMLNode, n);
                } else {
                    this.selectEnd(xMLNode2);
                }
            } else if (n5 == n) {
                XMLNode xMLNode3 = xMLNode;
                do {
                    if (++n2 == positionArray.length) {
                        xMLNode = null;
                        break;
                    }
                    xMLNode3 = xMLNode;
                } while ((string = (xMLNode = (XMLNode)positionArray[n2]).getType()) == "com.objfac.xmltext" || string == "com.objfac.xmlcdata");
                if (xMLNode != null) {
                    this.selectForward(xMLNode, n);
                } else {
                    this.selectEnd(xMLNode3);
                }
            } else if (n3 < n && n < n5) {
                this.selectForward(xMLNode, n);
            }
        }
    }

    private void selectEnd(XMLNode xMLNode) {
        int n = xMLNode.getOffset() + xMLNode.getLength();
        this.setSelection(n, n);
    }

    private void selectForward(XMLNode xMLNode, int n) {
        int n2 = xMLNode.getOffset();
        int n3 = xMLNode.getLength();
        int n4 = n2 + n3;
        if (n2 > n) {
            this.setSelection(n2, n2);
            return;
        }
        if (n == n4 - 1) {
            this.setSelection(n4, n4);
            return;
        }
        switch (XMLConstants.getIntType(xMLNode.getType())) {
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this.setSelection(n4, n4);
                break;
            }
            case 1: {
                this.scanTag(n2, n4, n, '<');
                break;
            }
            case 2: 
            case 7: {
                this.scanTag(n2, n4, n, '>');
                break;
            }
            case 3: {
                this.scanTag(n2, n4, n, '/');
                break;
            }
            case 6: {
                this.scanTag(n2, n4, n, '?');
                break;
            }
            case 8: 
            case 10: {
                this.scanTag(n2, n4, n, '%');
                break;
            }
            case 17: {
                this.scanTag(n2, n4, n, '[');
                break;
            }
            case 9: {
                this.scanJsp(n2, n4, n, "%>");
                break;
            }
            case 0: {
                this.scanJsp(n2, n4, n, "-->");
            }
        }
    }

    private void scanJsp(int n, int n2, int n3, String string) {
        int n4 = n3 - n;
        try {
            String string2 = this.fDocument.get(n, n2 - n);
            char[] cArray = string2.toCharArray();
            int n5 = cArray.length;
            int n6 = n5 - 1;
            if (string2.endsWith(string)) {
                n6 -= string.length();
            }
            while (n6 > 0 && XMLCharacter.isWhitespace((char)cArray[n6])) {
                --n6;
            }
            if (n6 > n4) {
                this.setSelection(n + n6, n + n6);
            } else {
                this.setSelection(n2, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
    }

    private void scanTag(int n, int n2, int n3, char c) {
        int n4 = n3 - n;
        try {
            String string = this.fDocument.get(n, n2 - n);
            char[] cArray = string.toCharArray();
            int n5 = 0;
            int n6 = cArray.length;
            while (n5 < n6 && !XMLCharacter.isWhitespace((char)cArray[n5])) {
                ++n5;
            }
            while (n5 < n6) {
                char c2 = cArray[n5];
                if (c2 == '\"' || c2 == '\'') {
                    int n7;
                    char c3 = c2;
                    int n8 = n7 = ++n5;
                    while (n5 < n6 && cArray[n5] != c3) {
                        ++n5;
                    }
                    n8 = n5;
                    if (n7 > n4) {
                        this.setSelection(n + n7, n + n8);
                        return;
                    }
                } else if (c2 == c) {
                    if (n5 > n4) {
                        this.setSelection(n + n5, n + n5);
                        return;
                    }
                    n5 = n6;
                    break;
                }
                ++n5;
            }
            this.setSelection(n2, n2);
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
    }

    private void setSelection(int n, int n2) {
        if (n < n2) {
            this.fViewer.setSelectedRange(n, n2 - n);
        } else {
            this.fViewer.setSelectedRange(n, 0);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }
}

