/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.partition;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.partition.PositionUpdater;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.util.Assert;

public abstract class Partitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension {
    public static final String PARTITION_CATEGORY = "com.objfac.partition_category";
    private IDocument fDocument;
    private ITokenScanner fScanner;
    private String[] fContentTypes;
    private HashSet fSupported = new HashSet();
    private IPositionUpdater fPositionUpdater = new PositionUpdater("com.objfac.partition_category");
    AbstractDocument adoc;
    public static Comparator POSITION_COMPARATOR = new PositionComparator();

    public Partitioner(ITokenScanner iTokenScanner, String[] stringArray) {
        this.fScanner = iTokenScanner;
        this.fContentTypes = stringArray;
        int n = 0;
        while (n < this.fContentTypes.length) {
            this.fSupported.add(this.fContentTypes[n]);
            ++n;
        }
    }

    public ITypedRegion[] computePartitioning(int n, int n2) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            TypedPosition typedPosition;
            int n3 = n + n2;
            int n4 = n;
            Object[] objectArray = this.fDocument.getPositions(PARTITION_CATEGORY);
            int n5 = Misc.findRange((Object[])objectArray, (Object)new Position(n, 0), (Comparator)POSITION_COMPARATOR);
            Assert.isTrue((n5 >= 0 ? 1 : 0) != 0);
            if (n5 < 0) {
                n5 = 0;
            }
            while (n5 < objectArray.length) {
                typedPosition = (TypedPosition)objectArray[n5];
                int n6 = typedPosition.getOffset();
                int n7 = typedPosition.getLength();
                if (n6 > n4) {
                    int n8 = Math.max(n4, n);
                    int n9 = Math.min(n6, n3);
                    TypedRegion typedRegion = new TypedRegion(n8, n9 - n8, "__dftl_partition_content_type");
                    linkedList.add(typedRegion);
                    if (n6 >= n3) break;
                }
                TypedRegion typedRegion = new TypedRegion(n6, n7, typedPosition.getType());
                linkedList.add(typedRegion);
                n4 = n6 + n7;
                if (n4 >= n3) break;
                ++n5;
            }
            if (linkedList.isEmpty()) {
                typedPosition = new TypedRegion(n, n2, "__dftl_partition_content_type");
                linkedList.add(typedPosition);
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            XMLPlugin.log(badPositionCategoryException);
        }
        return linkedList.toArray(new TypedRegion[linkedList.size()]);
    }

    public void connect(IDocument iDocument) {
        this.fDocument = iDocument;
        this.fDocument.addPositionCategory(PARTITION_CATEGORY);
        this.initialPartition();
    }

    private void initialPartition() {
        this.fScanner.setRange(this.fDocument, 0, this.fDocument.getLength());
        try {
            TypedPosition typedPosition;
            while ((typedPosition = this.nextPartition()) != null) {
                this.fDocument.addPosition(PARTITION_CATEGORY, (Position)typedPosition);
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            XMLPlugin.log(badPositionCategoryException);
        }
    }

    public void disconnect() {
        try {
            this.fDocument.removePositionCategory(PARTITION_CATEGORY);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            XMLPlugin.log(badPositionCategoryException);
        }
        this.fDocument = null;
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    public boolean documentChanged(DocumentEvent documentEvent) {
        throw new IllegalStateException("Old-style documentChanged() called");
    }

    public String getContentType(int n) {
        return this.getPartition(n).getType();
    }

    public String[] getLegalContentTypes() {
        return this.fContentTypes;
    }

    public IRegion documentChanged2(DocumentEvent documentEvent) {
        int n = documentEvent.getOffset();
        documentEvent.getLength();
        int n2 = documentEvent.getText() == null ? 0 : documentEvent.getText().length();
        int n3 = n;
        int n4 = n;
        try {
            int n5;
            int n6;
            TypedPosition typedPosition;
            int n7 = this.fDocument.getLength();
            if (n7 == 0) {
                this.removeAll();
                return this.getRegion(n3, n4);
            }
            this.fPositionUpdater.update(documentEvent);
            Position[] positionArray = this.fDocument.getPositions(PARTITION_CATEGORY);
            Assert.isTrue((positionArray != null ? 1 : 0) != 0);
            int n8 = this.getScanIndex(positionArray, n);
            if (n8 >= 0) {
                typedPosition = (TypedPosition)positionArray[n8];
                n6 = typedPosition.getOffset();
                int n9 = typedPosition.getLength();
                TypedPosition typedPosition2 = this.scanPartition(n6, n7);
                n5 = typedPosition2.getOffset();
                int n10 = typedPosition2.getLength();
                if (n6 != n5 || n9 != n10 || !typedPosition.getType().equals(typedPosition2.getType())) {
                    this.fDocument.addPosition(PARTITION_CATEGORY, (Position)typedPosition2);
                    n8 = this.removeOverlappingPartitions(positionArray, n8, n5, n10);
                    n3 = n5;
                    n4 = n5 + n10;
                } else {
                    ++n8;
                    n3 = n4 = n5 + n10;
                }
            } else {
                n8 = 0;
            }
            while (n8 < positionArray.length) {
                typedPosition = (TypedPosition)positionArray[n8];
                if (typedPosition.getLength() == 0 || typedPosition.isDeleted()) {
                    typedPosition.delete();
                    this.fDocument.removePosition(PARTITION_CATEGORY, (Position)typedPosition);
                    ++n8;
                    continue;
                }
                n6 = typedPosition.getOffset();
                if (n6 == n4 && n6 > n) {
                    return this.getRegion(n3, n4);
                }
                TypedPosition typedPosition3 = this.scanPartition(n4, n7);
                this.fDocument.addPosition(PARTITION_CATEGORY, (Position)typedPosition3);
                int n11 = typedPosition3.getOffset();
                n5 = typedPosition3.getLength();
                n4 = n11 + n5;
                n8 = this.removeOverlappingPartitions(positionArray, n8, n11, n5);
            }
            while (n4 < n7) {
                typedPosition = this.scanPartition(n4, n7);
                this.fDocument.addPosition(PARTITION_CATEGORY, (Position)typedPosition);
                n4 = typedPosition.getOffset() + typedPosition.getLength();
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            XMLPlugin.log(badPositionCategoryException);
        }
        return this.getRegion(n3, n4);
    }

    protected int getScanIndex(Position[] positionArray, int n) {
        int n2 = Math.max(n - 1, 0);
        int n3 = Misc.findRange((Object[])positionArray, (Object)new Position(n2, 0), (Comparator)POSITION_COMPARATOR);
        return n3;
    }

    private IRegion getRegion(int n, int n2) {
        return new Region(n, n2 - n);
    }

    private int removeOverlappingPartitions(Position[] positionArray, int n, int n2, int n3) {
        int n4 = n;
        while (n < positionArray.length) {
            Position position = positionArray[n];
            if (!position.overlapsWith(n2, n3)) break;
            try {
                n4 = n + 1;
                position.delete();
                this.fDocument.removePosition(PARTITION_CATEGORY, position);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                XMLPlugin.log(badPositionCategoryException);
            }
            ++n;
        }
        return n4;
    }

    private TypedPosition scanPartition(int n, int n2) {
        this.fScanner.setRange(this.fDocument, n, n2 - n);
        return this.nextPartition();
    }

    private TypedPosition nextPartition() {
        IToken iToken = this.fScanner.nextToken();
        if (iToken.isEOF()) {
            return null;
        }
        Object object = iToken.getData();
        if (!(object instanceof String)) {
            throw new IllegalStateException(Local.getString((String)"partition token must be String type"));
        }
        String string = (String)object;
        if (!this.fSupported.contains(string)) {
            throw new IllegalStateException(Local.format((String)"token type {0} is not a legal content type", (Object)string));
        }
        TypedPosition typedPosition = this.createPartition(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength(), string, this.fDocument);
        return typedPosition;
    }

    protected abstract TypedPosition createPartition(int var1, int var2, String var3, IDocument var4);

    protected abstract ITypedRegion createRegion(int var1, int var2, String var3, IDocument var4);

    private void removeAll() {
        try {
            Position[] positionArray = this.fDocument.getPositions(PARTITION_CATEGORY);
            int n = 0;
            while (n < positionArray.length) {
                Position position = positionArray[n];
                position.delete();
                this.fDocument.removePosition(PARTITION_CATEGORY, position);
                ++n;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            XMLPlugin.log(badPositionCategoryException);
        }
    }

    public ITypedRegion getPartition(int n) {
        int n2 = this.fDocument.getLength();
        int n3 = 0;
        int n4 = n2;
        try {
            TypedPosition typedPosition;
            Object[] objectArray = this.fDocument.getPositions(PARTITION_CATEGORY);
            if (objectArray == null || objectArray.length == 0) {
                return this.createRegion(0, n2, "__dftl_partition_content_type", this.fDocument);
            }
            int n5 = Misc.findRange((Object[])objectArray, (Object)new Position(n, 0), (Comparator)POSITION_COMPARATOR);
            if (n5 >= 0) {
                typedPosition = (TypedPosition)objectArray[n5];
                if (typedPosition.includes(n)) {
                    return this.createRegion(typedPosition.getOffset(), typedPosition.getLength(), typedPosition.getType(), this.fDocument);
                }
                n3 = typedPosition.getOffset() + typedPosition.getLength();
            }
            if (n5 + 1 < objectArray.length) {
                typedPosition = (TypedPosition)objectArray[n5 + 1];
                n4 = typedPosition.getOffset();
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            XMLPlugin.log(badPositionCategoryException);
        }
        return this.createRegion(n3, n4 - n3, "__dftl_partition_content_type", this.fDocument);
    }

    public static class PositionComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            int n2 = ((Position)object).getOffset();
            return n2 < (n = ((Position)object2).getOffset()) ? -1 : (n2 > n ? 1 : 0);
        }
    }
}

