/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.preferences;

import com.objfac.util.Local;
import com.objfac.xmleditor.actions.ActionUtils;
import com.objfac.xmleditor.preferences.ValidatingPreferencePage;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.wizards.WizardUtils;
import java.util.Arrays;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.moved.ColorEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class GraphicColorsPreferencePage
extends ValidatingPreferencePage {
    private boolean fPopulating;
    private boolean fApplied;
    private ItemData[] fInitialItems;
    private ItemData[] fDefaultItems;
    private ColorEditor fGradientColor;
    private Label fGradientColorLabel;
    private ColorEditor fBackgroundColor;
    private Label fBackgroundColorLabel;
    private ColorEditor fBorderColor;
    private Label fBorderColorLabel;
    private ColorEditor fTextColor;
    private Label fTextColorLabel;
    private int fSelection;
    private ItemData[] fItems;
    private List fItemList;
    private Button fDefault;
    private ColorSelectionListener fColorListener = new ColorSelectionListener();

    public GraphicColorsPreferencePage() {
    }

    public GraphicColorsPreferencePage(String string) {
        super(string);
    }

    public GraphicColorsPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    protected void validate() {
    }

    protected Control createContents(Composite composite) {
        ActionUtils.isActionable();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        gridLayout = this.getPreferenceStore();
        this.fItems = new ItemData[XMLConstants.GRAPH_ITEM_NAMES.length];
        int n = 0;
        while (n < this.fItems.length) {
            this.fItems[n] = this.makeItemData((IPreferenceStore)gridLayout, XMLConstants.GRAPH_ITEM_NAMES[n], n);
            ++n;
        }
        Arrays.sort(this.fItems);
        this.fInitialItems = new ItemData[XMLConstants.GRAPH_ITEM_NAMES.length];
        n = 0;
        while (n < this.fItems.length) {
            this.fInitialItems[n] = this.fItems[n].copy();
            ++n;
        }
        this.fDefaultItems = new ItemData[XMLConstants.GRAPH_ITEM_NAMES.length];
        n = 0;
        while (n < this.fItems.length) {
            this.fDefaultItems[n] = this.makeDefaultItemData((IPreferenceStore)gridLayout, XMLConstants.GRAPH_ITEM_NAMES[n], n);
            ++n;
        }
        Label label = new Label(composite2, 0);
        label.setText(Local.getString((String)"Item type:"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fItemList = new List(composite2, 2564);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.heightHint = 50;
        this.fItemList.setLayoutData((Object)gridData);
        int n2 = 0;
        while (n2 < this.fItems.length) {
            ItemData itemData = this.fItems[n2];
            this.fItemList.add(itemData.localName);
            ++n2;
        }
        String string = WizardUtils.getDialogSetting("com.objfac.graphitem");
        if (string == null || string.length() == 0) {
            string = "element";
        }
        this.fSelection = -1;
        int n3 = this.findItem(string, this.fItems);
        this.fItemList.setSelection(n3);
        this.fItemList.setTopIndex(n3);
        GraphicColorsPreferencePage.insertSpacer(composite2, 2);
        this.fDefault = new Button(composite2, 32);
        this.fDefault.setText(Local.getString((String)"Use defaults"));
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        this.fDefault.setLayoutData((Object)gridData2);
        this.fTextColorLabel = new Label(composite2, 0);
        this.fTextColorLabel.setLayoutData((Object)new GridData());
        this.fTextColorLabel.setText(Local.getString((String)"Text color:"));
        this.fTextColor = new ColorEditor(composite2);
        gridData2 = this.fTextColor.getButton();
        gridData2.setLayoutData((Object)new GridData());
        this.fBorderColorLabel = new Label(composite2, 0);
        this.fBorderColorLabel.setLayoutData((Object)new GridData());
        this.fBorderColorLabel.setText(Local.getString((String)"Border color:"));
        this.fBorderColor = new ColorEditor(composite2);
        gridData2 = this.fBorderColor.getButton();
        gridData2.setLayoutData((Object)new GridData());
        this.fBackgroundColorLabel = new Label(composite2, 0);
        this.fBackgroundColorLabel.setLayoutData((Object)new GridData());
        this.fBackgroundColorLabel.setText(Local.getString((String)"Background color:"));
        this.fBackgroundColor = new ColorEditor(composite2);
        gridData2 = this.fBackgroundColor.getButton();
        gridData2.setLayoutData((Object)new GridData());
        this.fGradientColorLabel = new Label(composite2, 0);
        this.fGradientColorLabel.setLayoutData((Object)new GridData());
        this.fGradientColorLabel.setText(Local.getString((String)"Gradient color:"));
        this.fGradientColor = new ColorEditor(composite2);
        gridData2 = this.fGradientColor.getButton();
        gridData2.setLayoutData((Object)new GridData());
        this.populate(false);
        this.fItemList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphicColorsPreferencePage.this.populate(false);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.fDefault.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (GraphicColorsPreferencePage.this.fDefault.getSelection()) {
                    int n = GraphicColorsPreferencePage.this.fItemList.getSelectionIndex();
                    if (n < 0) {
                        return;
                    }
                    ((GraphicColorsPreferencePage)GraphicColorsPreferencePage.this).fItems[n] = GraphicColorsPreferencePage.this.fDefaultItems[((GraphicColorsPreferencePage)GraphicColorsPreferencePage.this).fItems[n].index].copy();
                }
                GraphicColorsPreferencePage.this.populate(false);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.fTextColor.getButton().addSelectionListener((SelectionListener)this.fColorListener);
        this.fBorderColor.getButton().addSelectionListener((SelectionListener)this.fColorListener);
        this.fBackgroundColor.getButton().addSelectionListener((SelectionListener)this.fColorListener);
        this.fGradientColor.getButton().addSelectionListener((SelectionListener)this.fColorListener);
        return composite;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populate(boolean bl) {
        if (this.fPopulating) return;
        this.fPopulating = true;
        try {
            int n = this.fItemList.getSelectionIndex();
            if (n < 0) {
                this.fDefault.setEnabled(false);
                this.fTextColorLabel.setEnabled(false);
                this.fTextColor.getButton().setEnabled(false);
                this.fBorderColorLabel.setEnabled(false);
                this.fBorderColor.getButton().setEnabled(false);
                this.fBackgroundColorLabel.setEnabled(false);
                this.fBackgroundColor.getButton().setEnabled(false);
                this.fGradientColorLabel.setEnabled(false);
                this.fGradientColor.getButton().setEnabled(false);
            } else {
                ItemData itemData = this.fItems[n];
                this.fTextColor.setColorValue(itemData.textColor);
                this.fBorderColor.setColorValue(itemData.borderColor);
                this.fBackgroundColor.setColorValue(itemData.backgroundColor);
                this.fGradientColor.setColorValue(itemData.gradientColor);
                int n2 = itemData.index;
                boolean bl2 = false;
                if (bl || this.fSelection != n) {
                    ItemData itemData2 = this.fDefaultItems[n2];
                    bl2 = itemData.equals(itemData2);
                    this.fSelection = n;
                }
                boolean bl3 = XMLConstants.GRAPH_ITEM_HAS_TEXT[n2];
                if (bl2 != this.fDefault.getSelection()) {
                    this.fDefault.setSelection(bl2);
                }
                this.fDefault.setEnabled(true);
                this.fTextColorLabel.setEnabled(!bl2 && bl3);
                this.fTextColor.getButton().setEnabled(!bl2 && bl3);
                this.fBorderColorLabel.setEnabled(!bl2);
                this.fBorderColor.getButton().setEnabled(!bl2);
                this.fBackgroundColorLabel.setEnabled(!bl2);
                this.fBackgroundColor.getButton().setEnabled(!bl2);
                this.fGradientColorLabel.setEnabled(!bl2);
                this.fGradientColor.getButton().setEnabled(!bl2);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.fPopulating = false;
            throw throwable;
        }
        {
            Object var7_10 = null;
            this.fPopulating = false;
            return;
        }
    }

    private int findItem(String string, ItemData[] itemDataArray) {
        int n = 0;
        while (n < itemDataArray.length) {
            ItemData itemData = itemDataArray[n];
            if (string.equals(itemData.name)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private ItemData makeDefaultItemData(IPreferenceStore iPreferenceStore, String string, int n) {
        ItemData itemData = new ItemData();
        itemData.index = n;
        itemData.name = string;
        itemData.localName = Local.getString((String)string);
        String string2 = XMLConstants.GRAPH_ITEM_PREFIXES[n];
        itemData.textColor = PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string2) + "FG"));
        itemData.borderColor = PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string2) + "Border"));
        itemData.backgroundColor = PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string2) + "BG"));
        itemData.gradientColor = PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string2) + "Gradient"));
        return itemData;
    }

    private ItemData makeItemData(IPreferenceStore iPreferenceStore, String string, int n) {
        ItemData itemData = new ItemData();
        itemData.index = n;
        itemData.name = string;
        itemData.localName = Local.getString((String)string);
        String string2 = XMLConstants.GRAPH_ITEM_PREFIXES[n];
        itemData.textColor = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string2) + "FG"));
        itemData.borderColor = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string2) + "Border"));
        itemData.backgroundColor = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string2) + "BG"));
        itemData.gradientColor = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string2) + "Gradient"));
        return itemData;
    }

    public boolean performCancel() {
        if (this.fApplied) {
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            int n = 0;
            while (n < this.fInitialItems.length) {
                ItemData itemData = this.fInitialItems[n];
                String string = XMLConstants.GRAPH_ITEM_PREFIXES[itemData.index];
                PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string) + "FG"), (RGB)itemData.textColor);
                PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string) + "Border"), (RGB)itemData.borderColor);
                PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string) + "BG"), (RGB)itemData.backgroundColor);
                PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string) + "Gradient"), (RGB)itemData.gradientColor);
                ++n;
            }
        }
        this.rememberSelection();
        return true;
    }

    protected void performDefaults() {
        this.getPreferenceStore();
        int n = 0;
        while (n < this.fItems.length) {
            ItemData itemData = this.fItems[n];
            this.fItems[n] = this.fDefaultItems[itemData.index].copy();
            ++n;
        }
        this.populate(true);
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        int n = 0;
        while (n < this.fItems.length) {
            ItemData itemData = this.fItems[n];
            String string = XMLConstants.GRAPH_ITEM_PREFIXES[itemData.index];
            PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string) + "FG"), (RGB)itemData.textColor);
            PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string) + "Border"), (RGB)itemData.borderColor);
            PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string) + "BG"), (RGB)itemData.backgroundColor);
            PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(string) + "Gradient"), (RGB)itemData.gradientColor);
            ++n;
        }
        this.rememberSelection();
        this.fApplied = true;
        return true;
    }

    private void rememberSelection() {
        int n = this.fItemList.getSelectionIndex();
        if (n >= 0) {
            String string = XMLConstants.GRAPH_ITEM_NAMES[this.fItems[n].index];
            WizardUtils.putDialogSetting("com.objfac.graphitem", string);
        }
    }

    private static class ItemData
    implements Comparable {
        int index;
        String name;
        String localName;
        RGB textColor;
        RGB borderColor;
        RGB backgroundColor;
        RGB gradientColor;

        ItemData() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof ItemData)) {
                return false;
            }
            ItemData itemData = (ItemData)object;
            return this.textColor.equals((Object)itemData.textColor) && this.borderColor.equals((Object)itemData.borderColor) && this.backgroundColor.equals((Object)itemData.backgroundColor) && this.gradientColor.equals((Object)itemData.gradientColor);
        }

        public int compareTo(Object object) {
            if (!(object instanceof ItemData)) {
                return -1;
            }
            ItemData itemData = (ItemData)object;
            return this.localName.compareTo(itemData.localName);
        }

        public ItemData copy() {
            ItemData itemData = new ItemData();
            itemData.index = this.index;
            itemData.name = this.name;
            itemData.localName = this.localName;
            itemData.textColor = this.textColor;
            itemData.borderColor = this.borderColor;
            itemData.backgroundColor = this.backgroundColor;
            itemData.gradientColor = this.gradientColor;
            return itemData;
        }
    }

    private class ColorSelectionListener
    implements SelectionListener {
        ColorSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = GraphicColorsPreferencePage.this.fItemList.getSelectionIndex();
            if (n < 0) {
                return;
            }
            ItemData itemData = GraphicColorsPreferencePage.this.fItems[n];
            Button button = (Button)selectionEvent.getSource();
            if (GraphicColorsPreferencePage.this.fTextColor.getButton() == button) {
                itemData.textColor = GraphicColorsPreferencePage.this.fTextColor.getColorValue();
            } else if (GraphicColorsPreferencePage.this.fBorderColor.getButton() == button) {
                itemData.borderColor = GraphicColorsPreferencePage.this.fBorderColor.getColorValue();
            } else if (GraphicColorsPreferencePage.this.fBackgroundColor.getButton() == button) {
                itemData.backgroundColor = GraphicColorsPreferencePage.this.fBackgroundColor.getColorValue();
            } else if (GraphicColorsPreferencePage.this.fGradientColor.getButton() == button) {
                itemData.gradientColor = GraphicColorsPreferencePage.this.fGradientColor.getColorValue();
            }
            GraphicColorsPreferencePage.this.populate(false);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    }
}

