/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.preferences;

import com.objfac.util.Local;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.preferences.PrefUtils;
import com.objfac.xmleditor.resources.XMLConstants;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;

public class XMLDTDSettings {
    public static final String IFNONE_USEPREF = "pref";
    public static final String IFNONE_USENONE = "none";
    public static final String IFNONE_USETHIS = "this";
    public static final String IFNONE_USEAUTO = "auto";

    public static boolean isMatch() {
        return XMLPlugin.getDefault().getPreferenceStore().getBoolean("com.objfac.xmleditor.dtdmatch");
    }

    public static boolean getDefaultMatch() {
        return XMLPlugin.getDefault().getPreferenceStore().getDefaultBoolean("com.objfac.xmleditor.dtdmatch");
    }

    public static void setMatch(boolean bl) {
        XMLPlugin.getDefault().getPreferenceStore().setValue("com.objfac.xmleditor.dtdmatch", bl);
    }

    public static boolean isAuto() {
        return XMLPlugin.getDefault().getPreferenceStore().getBoolean("com.objfac.xmleditor.dtdauto");
    }

    public static boolean getDefaultAuto() {
        return XMLPlugin.getDefault().getPreferenceStore().getDefaultBoolean("com.objfac.xmleditor.dtdauto");
    }

    public static void setAuto(boolean bl) {
        XMLPlugin.getDefault().getPreferenceStore().setValue("com.objfac.xmleditor.dtdauto", bl);
    }

    public static String getDefaultString() {
        boolean bl = XMLDTDSettings.isMatch();
        boolean bl2 = XMLDTDSettings.isAuto();
        if (bl) {
            if (bl2) {
                return Local.getString((String)"Use preference (DTD with matching root or auto-generate)");
            }
            return Local.getString((String)"Use preference (DTD with matching root or none)");
        }
        if (bl2) {
            return Local.getString((String)"Use preference (auto-generated DTD)");
        }
        return Local.getString((String)"Use preference (no DTD)");
    }

    public static ArrayList getMatchRows() {
        IPreferenceStore iPreferenceStore = XMLPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("com.objfac.xmleditor.dtdroot");
        String string2 = iPreferenceStore.getString("com.objfac.xmleditor.dtdpub");
        String string3 = iPreferenceStore.getString("com.objfac.xmleditor.dtdsys");
        return XMLDTDSettings.makeRows(string, string2, string3);
    }

    private static ArrayList makeRows(String string, String string2, String string3) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = PrefUtils.unpackNormalizedArray(string);
        String[] stringArray2 = PrefUtils.unpackNormalizedArray(string2);
        String[] stringArray3 = PrefUtils.unpackNormalizedArray(string3);
        int n = Math.min(stringArray.length, Math.min(stringArray2.length, stringArray3.length));
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray4 = new String[]{PrefUtils.hexUnescape(stringArray[n2]), PrefUtils.hexUnescape(stringArray2[n2]), PrefUtils.hexUnescape(stringArray3[n2])};
            arrayList.add(stringArray4);
            ++n2;
        }
        return arrayList;
    }

    public static ArrayList getDefaultMatchRows() {
        IPreferenceStore iPreferenceStore = XMLPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getDefaultString("com.objfac.xmleditor.dtdroot");
        String string2 = iPreferenceStore.getDefaultString("com.objfac.xmleditor.dtdpub");
        String string3 = iPreferenceStore.getDefaultString("com.objfac.xmleditor.dtdsys");
        return XMLDTDSettings.makeRows(string, string2, string3);
    }

    public static void setMatchRows(ArrayList arrayList) {
        Object object;
        int n = arrayList.size();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[n];
        IPreferenceStore iPreferenceStore = XMLPlugin.getDefault().getPreferenceStore();
        int n2 = 0;
        while (n2 < n) {
            object = (String[])arrayList.get(n2);
            stringArray[n2] = PrefUtils.hexEscape(object[0].trim());
            stringArray2[n2] = PrefUtils.hexEscape(PrefUtils.normalizePubid(object[1]));
            stringArray3[n2] = PrefUtils.hexEscape(object[2].trim());
            ++n2;
        }
        String string = PrefUtils.packNormalizedArray(stringArray);
        object = PrefUtils.packNormalizedArray(stringArray2);
        String string2 = PrefUtils.packNormalizedArray(stringArray3);
        iPreferenceStore.setValue("com.objfac.xmleditor.dtdroot", string);
        iPreferenceStore.setValue("com.objfac.xmleditor.dtdpub", (String)object);
        iPreferenceStore.setValue("com.objfac.xmleditor.dtdsys", string2);
    }

    public static DTDProps getCurrentProperties(IFile iFile) {
        DTDProps dTDProps = new DTDProps();
        dTDProps.fHow = XMLDTDSettings.getCurrentHandling(iFile);
        dTDProps.fPub = XMLDTDSettings.getCurrentPublicId(iFile);
        dTDProps.fSys = XMLDTDSettings.getCurrentSystemId(iFile);
        return dTDProps;
    }

    public static String getCurrentHandling(IFile iFile) {
        String string;
        try {
            string = iFile.getPersistentProperty(XMLConstants.DTD_HANDLE);
            if (string == null) {
                string = XMLDTDSettings.getDefaultHandling();
            }
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
            string = XMLDTDSettings.getDefaultHandling();
        }
        return string;
    }

    public static String getCurrentPublicId(IFile iFile) {
        String string;
        try {
            string = iFile.getPersistentProperty(XMLConstants.DTD_PUBLIC);
            if (string == null) {
                string = XMLDTDSettings.getDefaultPublicId();
            }
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
            string = XMLDTDSettings.getDefaultPublicId();
        }
        return string;
    }

    public static String getCurrentSystemId(IFile iFile) {
        String string;
        try {
            string = iFile.getPersistentProperty(XMLConstants.DTD_SYSTEM);
            if (string == null) {
                string = XMLDTDSettings.getDefaultSystemId();
            }
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
            string = XMLDTDSettings.getDefaultSystemId();
        }
        return string;
    }

    public static void setCurrentProperties(IFile iFile, DTDProps dTDProps) {
        try {
            if (dTDProps.fHow.equals(IFNONE_USETHIS)) {
                iFile.setPersistentProperty(XMLConstants.DTD_PUBLIC, dTDProps.fPub);
                iFile.setPersistentProperty(XMLConstants.DTD_SYSTEM, dTDProps.fSys);
            }
            iFile.setPersistentProperty(XMLConstants.DTD_HANDLE, dTDProps.fHow);
        }
        catch (CoreException coreException) {}
    }

    public static DTDProps getDefaultProperties() {
        DTDProps dTDProps = new DTDProps();
        dTDProps.fPub = XMLDTDSettings.getDefaultPublicId();
        dTDProps.fSys = XMLDTDSettings.getDefaultSystemId();
        dTDProps.fHow = XMLDTDSettings.getDefaultHandling();
        return dTDProps;
    }

    public static String getDefaultPublicId() {
        return "";
    }

    public static String getDefaultSystemId() {
        return "";
    }

    public static String getDefaultHandling() {
        return IFNONE_USEPREF;
    }

    public static class DTDProps {
        public String fPub;
        public String fSys;
        public String fHow;

        public DTDProps() {
        }

        public DTDProps(DTDProps dTDProps) {
            this.fPub = dTDProps.fPub;
            this.fSys = dTDProps.fSys;
            this.fHow = dTDProps.fHow;
        }

        public void reset(DTDProps dTDProps) {
            this.fPub = dTDProps.fPub;
            this.fSys = dTDProps.fSys;
            this.fHow = dTDProps.fHow;
        }
    }
}

