/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.preferences;

import com.objfac.util.CaselessMap;
import com.objfac.util.Local;
import com.objfac.xml.io.Encoding;
import com.objfac.xmleditor.preferences.IAbstractPage;
import com.objfac.xmleditor.preferences.MultiplexListener;
import java.util.Arrays;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class XMLEncodingPage {
    private Props fProps;
    private Props fInitialProps;
    private Props fDefaultProps;
    private Button fHonor;
    private Button fWorkbenchT;
    private Button fUtf8;
    private Button fWorkbenchF;
    private Combo fSpecified;
    private Composite fControls;
    private CaselessMap fEncodings;
    private Button fConvert;
    private IAbstractPage fPage;
    private Button fImplicit;
    private Text fPub;
    private Text fSys;
    private Button fNone;
    private Button fAuto;

    public XMLEncodingPage(IAbstractPage iAbstractPage, Props props, Props props2) {
        this.fPage = iAbstractPage;
        this.fProps = this.fInitialProps = props;
        this.fDefaultProps = props2;
    }

    public Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        Object object = new GridLayout();
        object.numColumns = 1;
        composite2.setLayout((Layout)object);
        object = new MultiplexListener(){

            protected void action() {
                XMLEncodingPage.this.check();
            }
        };
        this.fHonor = new Button(composite2, 32);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.fHonor.setLayoutData((Object)gridData);
        this.fHonor.setText("Honor <?xml encoding attribute if specified");
        this.fUtf8 = new Button(composite2, 16);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.fUtf8.setLayoutData((Object)gridData);
        this.fUtf8.setText("Default to UTF-8");
        this.fUtf8.addSelectionListener((SelectionListener)object);
        this.fWorkbenchT = new Button(composite2, 16);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.fWorkbenchT.setLayoutData((Object)gridData);
        this.fWorkbenchT.setText("Default to workbench encoding");
        this.fWorkbenchT.addSelectionListener((SelectionListener)object);
        this.fWorkbenchF = new Button(composite2, 16);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.fWorkbenchF.setLayoutData((Object)gridData);
        this.fWorkbenchF.setText("Default to specified encoding:");
        this.fWorkbenchF.addSelectionListener((SelectionListener)object);
        gridData = new Composite(composite2, 0);
        GridData gridData2 = new GridData();
        gridData2.verticalAlignment = 1;
        gridData.setLayoutData((Object)gridData2);
        Object object2 = new GridLayout();
        ((GridLayout)object2).numColumns = 2;
        gridData.setLayout((Layout)object2);
        this.fSpecified = new Combo((Composite)gridData, 4);
        gridData2 = new GridData();
        gridData2.verticalAlignment = 1;
        gridData2.horizontalIndent = 20;
        this.fSpecified.setLayoutData((Object)gridData2);
        this.fEncodings = Encoding.getMostlyStandardEncodingMap();
        object2 = this.fEncodings.values();
        String[] stringArray = object2.toArray(new String[object2.size()]);
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        this.fSpecified.setItems(stringArray);
        this.fSpecified.addSelectionListener((SelectionListener)object);
        this.fSpecified.addModifyListener((ModifyListener)object);
        this.fConvert = new Button((Composite)gridData, 8);
        gridData2 = new GridData();
        gridData2.verticalAlignment = 1;
        this.fConvert.setLayoutData((Object)gridData2);
        this.fConvert.setText(Local.getString((String)"Convert"));
        this.fConvert.addSelectionListener((SelectionListener)new MultiplexListener(){

            protected void action() {
                String string = XMLEncodingPage.this.fSpecified.getText();
                String string2 = Encoding.getStandardEquivalent((String)string);
                if (string2 != null) {
                    XMLEncodingPage.this.fSpecified.setText(string2);
                }
                XMLEncodingPage.this.check();
            }
        });
        this.fControls = composite2;
        this.updateControls();
        return composite2;
    }

    public void enableControls(boolean bl) {
        this.fHonor.setEnabled(bl);
        this.fUtf8.setEnabled(bl);
        this.fWorkbenchT.setEnabled(bl);
        this.fWorkbenchF.setEnabled(bl);
        this.fSpecified.setEnabled(bl);
        this.fConvert.setEnabled(bl);
    }

    public Props getProps() {
        if (this.fProps == null || this.fControls == null) {
            return null;
        }
        this.fProps.fHonor = this.fHonor.getSelection();
        this.fProps.fWorkbench = this.fWorkbenchT.getSelection();
        this.fProps.fSpecified = this.fSpecified.getText();
        return this.fProps;
    }

    public void resetToInitial() {
        this.fProps = this.fInitialProps;
        this.updateControls();
    }

    public void resetToDefault() {
        this.fProps = this.fDefaultProps;
        this.updateControls();
    }

    private void check() {
        boolean bl;
        if (this.fControls == null) {
            return;
        }
        this.fConvert.setEnabled(false);
        String string = this.fSpecified.getText();
        boolean bl2 = this.fUtf8.getSelection();
        boolean bl3 = bl = this.fWorkbenchF.getSelection() && !bl2;
        if (string == null || string.length() == 0) {
            if (bl) {
                this.fPage.setMessages(Local.getString((String)"Must enter an encoding"), null);
            } else {
                this.fPage.setMessages(null, null);
            }
        } else if (bl) {
            String string2 = Encoding.getStandardEquivalent((String)string);
            if (string2 == null) {
                this.fPage.setMessages(null, "Unknown encoding");
            } else if (string2.equals(string)) {
                this.fPage.setMessages(null, null);
            } else {
                this.fPage.setMessages(null, Local.format((String)"{0} recognized as equivalent to {1}", (Object)string, (Object)string2));
                this.fConvert.setEnabled(true);
            }
        } else if (bl2) {
            if (!string.equals("UTF-8")) {
                this.fSpecified.setText("UTF-8");
            }
            this.fPage.setMessages(null, null);
        } else {
            this.fPage.setMessages(null, null);
        }
        this.fSpecified.setEnabled(bl);
    }

    private void updateControls() {
        if (this.fProps == null || this.fControls == null) {
            return;
        }
        this.fHonor.setEnabled(this.fProps.fKnown);
        this.fHonor.setSelection(this.fProps.fHonor);
        this.fWorkbenchT.setEnabled(this.fProps.fKnown);
        this.fWorkbenchF.setEnabled(this.fProps.fKnown);
        boolean bl = this.fProps.fSpecified.equals("UTF-8");
        if (this.fProps.fWorkbench) {
            this.fWorkbenchT.setSelection(true);
            this.fWorkbenchF.setSelection(false);
            this.fUtf8.setSelection(false);
        } else if (bl) {
            this.fWorkbenchT.setSelection(false);
            this.fWorkbenchF.setSelection(false);
            this.fUtf8.setSelection(true);
        } else {
            this.fWorkbenchT.setSelection(false);
            this.fWorkbenchF.setSelection(true);
            this.fUtf8.setSelection(false);
        }
        this.fSpecified.setEnabled(this.fProps.fKnown && !this.fProps.fWorkbench && !bl);
        this.fSpecified.setText(this.fProps.fSpecified);
    }

    public static class Props {
        public boolean fHonor;
        public boolean fWorkbench;
        public String fSpecified;
        public boolean fKnown;

        public Props() {
            this(true);
        }

        public Props(boolean bl) {
            this.fHonor = true;
            this.fWorkbench = false;
            this.fSpecified = "UTF-8";
            this.fKnown = bl;
        }

        public Props(Props props) {
            this.fHonor = props.fHonor;
            this.fWorkbench = props.fWorkbench;
            this.fSpecified = props.fSpecified;
            this.fKnown = true;
        }
    }
}

