/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.search;

import com.objfac.xmleditor.search.IScope;
import com.objfac.xmleditor.search.Wildcard;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.ui.IWorkingSet;

public class XPathSearchScope
implements IScope {
    protected Wildcard wildcard;
    private HashSet pathParts = new HashSet();
    protected LinkedList resources;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public XPathSearchScope(Wildcard wildcard) {
        this.wildcard = wildcard;
    }

    public XPathSearchScope(Wildcard wildcard, ISelection iSelection) {
        this(wildcard);
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                IResource iResource;
                Object object = iterator.next();
                if (object instanceof ISearchResultViewEntry) {
                    object = ((ISearchResultViewEntry)object).getGroupByKey();
                }
                if (object instanceof IResource) {
                    this.addResource((IResource)object);
                    continue;
                }
                if (!(object instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) continue;
                this.addResource(iResource);
            }
        }
        this.calculatePathParts();
    }

    public XPathSearchScope(Wildcard wildcard, IWorkingSet[] iWorkingSetArray) {
        this(wildcard);
        int n = 0;
        while (n < iWorkingSetArray.length) {
            IAdaptable[] iAdaptableArray = iWorkingSetArray[n].getElements();
            int n2 = 0;
            while (n2 < iAdaptableArray.length) {
                IResource iResource;
                IAdaptable iAdaptable = iAdaptableArray[n2];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                    this.addResource(iResource);
                }
                ++n2;
            }
            ++n;
        }
        this.calculatePathParts();
    }

    private void calculatePathParts() {
        Iterator iterator = this.resources.iterator();
        block2: while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            String string = iResource.getFullPath().toString();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iResource.getAdapter((Class)clazz) == null && string.charAt(string.length() - 1) != '/') {
                string = String.valueOf(string) + "/";
            }
            int n = string.length();
            while (n > 0 && (n = string.lastIndexOf(47, n)) >= 0) {
                String string2 = string.substring(0, n);
                if (string2.length() == 0 || this.pathParts.contains(string2)) continue block2;
                this.pathParts.add(string2);
                --n;
            }
        }
    }

    public static XPathSearchScope getWorkspaceScope(Wildcard wildcard) {
        return new WorkspaceScope(wildcard);
    }

    private void addResource(IResource iResource) {
        if (this.resources == null) {
            this.resources = new LinkedList();
        }
        this.resources.add(iResource);
    }

    public boolean fileInScope(IResourceProxy iResourceProxy) {
        return this.wildcard.match(iResourceProxy.getName());
    }

    public boolean folderInScope(IResourceProxy iResourceProxy) {
        return this.pathParts.size() == 0 || this.pathParts.contains(iResourceProxy.requestFullPath().toString());
    }

    public boolean projectInScope(IResourceProxy iResourceProxy) {
        return this.pathParts.size() == 0 || this.pathParts.contains(iResourceProxy.requestFullPath().toString());
    }

    private static class WorkspaceScope
    extends XPathSearchScope {
        public WorkspaceScope(Wildcard wildcard) {
            super(wildcard);
        }

        public boolean fileInScope(IResourceProxy iResourceProxy) {
            return this.wildcard.match(iResourceProxy.getName());
        }

        public boolean folderInScope(IResourceProxy iResourceProxy) {
            return true;
        }

        public boolean projectInScope(IResourceProxy iResourceProxy) {
            return true;
        }
    }
}

