/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.validate;

import com.objfac.util.Local;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.resources.ResourceWatcherCallback;
import com.objfac.xmleditor.validate.ErrorCollector;
import com.objfac.xmleditor.validate.ErrorTuple;
import com.objfac.xmleditor.validate.ITransform;
import com.objfac.xmleditor.validate.ITransformResult;
import com.objfac.xmleditor.validate.ParserContext;
import com.objfac.xmleditor.validate.TransformArguments;
import com.objfac.xmleditor.validate.TransformerShell;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class BuiltinTransformerShell
implements TransformerShell {
    private static final String SAXON7_TRANSFORM = "com.objfac.xmleditor.xerces.Saxon7Transform";

    public ITransformResult[] transform(XMLEditor xMLEditor, TransformArguments transformArguments, ResourceWatcherCallback resourceWatcherCallback) {
        ErrorCollector errorCollector = new ErrorCollector();
        xMLEditor.getUrl();
        Object object = XMLPlugin.getDefault().loadInternalClass(SAXON7_TRANSFORM);
        ITransform iTransform = (ITransform)object;
        ParserContext parserContext = new ParserContext();
        try {
            ITransformResult[] iTransformResultArray = xMLEditor.getEditorKind() == 6 ? iTransform.transform(xMLEditor.getUrl(), transformArguments, errorCollector, resourceWatcherCallback) : iTransform.transform(transformArguments.inputUri, xMLEditor.getUrl(), transformArguments, errorCollector, resourceWatcherCallback);
            LinkedList linkedList = errorCollector.getErrors();
            int n = linkedList.size();
            if (errorCollector.getMaxSeverity() > 0 && n > 0) {
                IStatus iStatus;
                int n2 = n == 1 ? 1 : n - 1;
                String string = ((ErrorTuple)linkedList.getLast()).message;
                if (n2 == 1) {
                    iStatus = this.errorTupleToStatus((ErrorTuple)linkedList.getFirst());
                } else {
                    IStatus[] iStatusArray = new IStatus[n2];
                    iStatus = new MultiStatus("com.objfac.xmleditor", 0, iStatusArray, string, null);
                    Iterator iterator = linkedList.iterator();
                    int n3 = 0;
                    while (n3 < n2) {
                        iStatusArray[n3] = this.errorTupleToStatus((ErrorTuple)iterator.next());
                        ++n3;
                    }
                }
                ErrorDialog.openError((Shell)xMLEditor.getViewer().getTextWidget().getShell(), (String)Local.getString((String)"Transform problems"), (String)string, (IStatus)iStatus);
            }
            ITransformResult[] iTransformResultArray2 = iTransformResultArray;
            Object var17_18 = null;
            parserContext.restore();
            return iTransformResultArray2;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            parserContext.restore();
            throw throwable;
        }
    }

    private IStatus errorTupleToStatus(ErrorTuple errorTuple) {
        int n = this.convertToStatusLevel(errorTuple.level);
        String string = "com.objfac.xmleditor";
        int n2 = 0;
        String string2 = errorTuple.message;
        return new Status(n, string, n2, string2, null);
    }

    private int convertToStatusLevel(int n) {
        return 4;
    }

    void backgroundParse(String string, String string2, String string3) {
    }
}

