/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.wizards;

import com.objfac.util.Local;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.wizards.NewXMLFileCreationPage;
import com.objfac.xmleditor.wizards.WizardUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class FileCreationWizard
extends Wizard
implements INewWizard {
    protected IWorkbench fWorkbench;
    protected IStructuredSelection fSelection;
    protected NewXMLFileCreationPage fMainPage;
    protected HashMap fVariables = new HashMap();
    private String fDesc;
    private String fTemplate;
    private String fExtension;

    protected FileCreationWizard(String string, String string2, String string3) {
        this.fDesc = string;
        this.fTemplate = string2;
        this.fExtension = string3;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.fWorkbench = iWorkbench;
        this.fSelection = iStructuredSelection;
        this.initVariables();
    }

    public IPath getContainerFullPath() {
        return this.fMainPage.getContainerFullPath();
    }

    protected abstract void initVariables();

    protected abstract Object[] getParams();

    protected void setProperties(Map map, IFile iFile) {
    }

    public void addPages() {
        super.addPages();
        this.fMainPage = new NewXMLFileCreationPage("main", this.fSelection, this.fTemplate, this.fDesc, this.fExtension);
        this.fMainPage.setTitle(Local.getString((String)"Folder and File Name"));
        this.addPage((IWizardPage)this.fMainPage);
    }

    public boolean performFinish() {
        WizardUtils.putDialogSettings(this.fVariables, this.getParams());
        if (this.fMainPage.finish(this.fVariables)) {
            this.setProperties(this.fVariables, this.getNewFile());
            return true;
        }
        return false;
    }

    public IFile getNewFile() {
        IPath iPath = this.getContainerFullPath().append(this.fMainPage.getFinalFileName());
        IFile iFile = XMLPlugin.getWorkspace().getRoot().getFile(iPath);
        return iFile;
    }

    public IPath getNewFilePath() {
        IPath iPath = this.getContainerFullPath().append(this.fMainPage.getFinalFileName());
        return iPath;
    }
}

