/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.wizards;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.xmleditor.MigrationUtils;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.wizards.Template;
import com.objfac.xmleditor.wizards.WizardUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewXMLFileCreationPage
extends WizardNewFileCreationPage {
    private Map fVariables;
    private String fTemplateName;
    private String fLabel;
    private String fExtension;

    public NewXMLFileCreationPage(String string, IStructuredSelection iStructuredSelection, String string2, String string3, String string4) {
        super(string, iStructuredSelection);
        this.fTemplateName = string2;
        this.fLabel = string3;
        this.fExtension = string4;
    }

    protected InputStream getInitialContents() {
        InputStream inputStream;
        Map map = this.getVariables();
        Boolean bl = (Boolean)map.get("usefile");
        if (bl != null && bl.booleanValue() && (inputStream = this.getFileInputStream((String)map.get("file"))) != null) {
            return inputStream;
        }
        inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(this.fTemplateName);
        try {
            char[] cArray = Misc.readContents((Reader)new BufferedReader(new InputStreamReader(inputStream)));
            return Template.getInputStream(cArray, map);
        }
        catch (IOException iOException) {
            return super.getInitialContents();
        }
    }

    private InputStream getFileInputStream(String string) {
        return WizardUtils.getInputStream(this.getContainerFullPath(), string);
    }

    protected String getNewFileLabel() {
        return Local.getString((String)this.fLabel);
    }

    public String getFinalFileName() {
        String string = this.getFileName();
        if (string != null && string.lastIndexOf(46) < 0) {
            string = String.valueOf(string) + this.fExtension;
        }
        return string;
    }

    public boolean finish(Map map) {
        this.fVariables = map;
        String string = this.getFileName();
        if (string != null && string.lastIndexOf(46) < 0) {
            this.setFileName(String.valueOf(string) + this.fExtension);
        }
        if (this.validatePage()) {
            final IFile iFile = this.createNewFile();
            if (iFile != null) {
                Shell shell = this.getShell();
                IWorkbenchPage iWorkbenchPage = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (shell == null || iWorkbenchPage == null) {
                    return true;
                }
                final IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
                if (iWorkbenchPart instanceof ISetSelectionTarget) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            StructuredSelection structuredSelection = new StructuredSelection((Object)iFile);
                            ((ISetSelectionTarget)iWorkbenchPart).selectReveal((ISelection)structuredSelection);
                        }
                    });
                }
                try {
                    MigrationUtils.openEditor(iWorkbenchPage, iFile);
                    return true;
                }
                catch (PartInitException partInitException) {
                    XMLPlugin.log(partInitException);
                }
            }
            return true;
        }
        return false;
    }

    private Map getVariables() {
        if (this.fVariables == null) {
            return new HashMap();
        }
        return this.fVariables;
    }

    protected boolean validatePage() {
        String string;
        boolean bl = super.validatePage();
        if (bl && (string = this.getFileName()) != null && string.length() > 0 && string.indexOf(46) < 0) {
            string = String.valueOf(string) + this.fExtension;
            IPath iPath = this.getContainerFullPath();
            IPath iPath2 = iPath.append(string);
            if (XMLPlugin.getWorkspace().getRoot().getFolder(iPath2).exists()) {
                this.setErrorMessage(Local.format((String)"Folder {0} already exists at this location", (Object)string));
                bl = false;
            } else if (XMLPlugin.getWorkspace().getRoot().getFile(iPath2).exists()) {
                this.setErrorMessage(Local.format((String)"File {0} already exists at this location", (Object)string));
                bl = false;
            }
        }
        this.setPageComplete(bl);
        return bl;
    }
}

