/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moved;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.moved.SubstitutionTextReader;
import org.eclipse.swt.custom.StyleRange;

public class HTML2TextReader
extends SubstitutionTextReader {
    private static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    private static final Map fgEntityLookup;
    private static final Set fgTags;
    private int fCounter = 0;
    private TextPresentation fTextPresentation;
    private int fBold = 0;
    private int fStartOffset = -1;
    private boolean fInParagraph = false;

    static {
        fgTags = new HashSet();
        fgTags.add("b");
        fgTags.add("br");
        fgTags.add("h5");
        fgTags.add("p");
        fgTags.add("dl");
        fgTags.add("dt");
        fgTags.add("dd");
        fgTags.add("li");
        fgTags.add("ul");
        fgEntityLookup = new HashMap(7);
        fgEntityLookup.put("lt", "<");
        fgEntityLookup.put("gt", ">");
        fgEntityLookup.put("nbsp", " ");
        fgEntityLookup.put("amp", "&");
        fgEntityLookup.put("circ", "^");
        fgEntityLookup.put("tilde", "~");
        fgEntityLookup.put("quot", "\"");
    }

    public HTML2TextReader(Reader reader, TextPresentation textPresentation) {
        super(new PushbackReader(reader));
        this.fTextPresentation = textPresentation;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.fCounter;
        }
        return n;
    }

    protected void startBold() {
        if (this.fBold == 0) {
            this.fStartOffset = this.fCounter;
        }
        ++this.fBold;
    }

    protected void stopBold() {
        --this.fBold;
        if (this.fBold == 0) {
            if (this.fTextPresentation != null) {
                this.fTextPresentation.addStyleRange(new StyleRange(this.fStartOffset, this.fCounter - this.fStartOffset, null, null, 1));
            }
            this.fStartOffset = -1;
        }
    }

    protected String computeSubstitution(int n) throws IOException {
        if (n == 60) {
            return this.processHTMLTag();
        }
        if (n == 38) {
            return this.processEntity();
        }
        return null;
    }

    private String html2Text(String string) {
        String string2 = string;
        if ('/' == string2.charAt(0)) {
            string2 = string2.substring(1);
        }
        if (!fgTags.contains(string2)) {
            return "";
        }
        if ("b".equals(string)) {
            this.startBold();
            return "";
        }
        if ("h5".equals(string) || "dt".equals(string)) {
            this.startBold();
            return "";
        }
        if ("dl".equals(string)) {
            return LINE_DELIM;
        }
        if ("dd".equals(string)) {
            return "\t";
        }
        if ("li".equals(string)) {
            return String.valueOf(LINE_DELIM) + "\t" + "-";
        }
        if ("/b".equals(string)) {
            this.stopBold();
            return "";
        }
        if ("p".equals(string)) {
            this.fInParagraph = true;
            return LINE_DELIM;
        }
        if ("br".equals(string)) {
            return LINE_DELIM;
        }
        if ("/p".equals(string)) {
            boolean bl = this.fInParagraph;
            this.fInParagraph = false;
            return bl ? "" : LINE_DELIM;
        }
        if ("/h5".equals(string) || "/dt".equals(string)) {
            this.stopBold();
            return LINE_DELIM;
        }
        if ("/dd".equals(string)) {
            return LINE_DELIM;
        }
        return "";
    }

    private String processHTMLTag() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n = this.nextChar();
            while (n != -1 && n != 62) {
                stringBuffer.append(Character.toLowerCase((char)n));
                n = this.nextChar();
                if (n == 34) {
                    stringBuffer.append(Character.toLowerCase((char)n));
                    n = this.nextChar();
                    while (n != -1 && n != 34) {
                        stringBuffer.append(Character.toLowerCase((char)n));
                        n = this.nextChar();
                    }
                }
                if (n != 60) continue;
                this.unread(n);
                return String.valueOf('<') + stringBuffer.toString();
            }
            if (n == -1) {
                return null;
            }
            int n2 = stringBuffer.length();
            if (n2 < 3 || !"!--".equals(stringBuffer.substring(0, 3)) || n2 >= 5 && "--!".equals(stringBuffer.substring(n2 - 3))) break;
            stringBuffer.append(n);
        }
        return this.html2Text(stringBuffer.toString());
    }

    private void unread(int n) throws IOException {
        ((PushbackReader)this.getReader()).unread(n);
    }

    protected String entity2Text(String string) {
        if (string.length() > 1 && string.charAt(0) == '#') {
            try {
                int n = string.charAt(1) == 'x' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1), 10);
                return "" + (char)n;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String string2 = (String)fgEntityLookup.get(string);
            if (string2 != null) {
                return string2;
            }
        }
        return "&" + string;
    }

    private String processEntity() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.nextChar();
        while (Character.isLetterOrDigit((char)n) || n == 35) {
            stringBuffer.append((char)n);
            n = this.nextChar();
        }
        if (n == 59) {
            return this.entity2Text(stringBuffer.toString());
        }
        stringBuffer.insert(0, '&');
        if (n != -1) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }
}

