/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.moved;

import com.objfac.xmleditor.XMLPlugin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class XMLAnnotationHover
implements IAnnotationHover {
    public String getHoverInfo(ISourceViewer iSourceViewer, int n) {
        String string;
        IMarker iMarker = this.getMarker(iSourceViewer, n);
        if (iMarker != null && (string = iMarker.getAttribute("message", null)) != null) {
            return this.formatHoverText(string);
        }
        return null;
    }

    protected int compareRulerLine(Position position, IDocument iDocument, int n) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int n2 = iDocument.getLineOfOffset(position.getOffset());
                if (n == n2) {
                    return 1;
                }
                if (n2 <= n && n <= iDocument.getLineOfOffset(position.getOffset() + position.getLength())) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
        }
        return 0;
    }

    protected IMarker select(List list, List list2) {
        if (!list.isEmpty()) {
            return (IMarker)list.get(0);
        }
        if (!list2.isEmpty()) {
            return (IMarker)list2.get(0);
        }
        return null;
    }

    protected IMarker getMarker(ISourceViewer iSourceViewer, int n) {
        IDocument iDocument = iSourceViewer.getDocument();
        IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
        if (iAnnotationModel == null) {
            return null;
        }
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        ArrayList<IMarker> arrayList2 = new ArrayList<IMarker>();
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof MarkerAnnotation)) continue;
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)e;
            switch (this.compareRulerLine(iAnnotationModel.getPosition((Annotation)markerAnnotation), iDocument, n)) {
                case 1: {
                    arrayList.add(markerAnnotation.getMarker());
                    break;
                }
                case 2: {
                    arrayList2.add(markerAnnotation.getMarker());
                }
            }
        }
        return this.select(arrayList, arrayList);
    }

    private String formatHoverText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body text=\"#000000\" bgcolor=\"#FFFF88\"><font size=-1>");
        stringBuffer.append("<p>").append(string).append("</p>");
        stringBuffer.append("</font></body></html>");
        return stringBuffer.toString();
    }
}

