/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.io;

import java.io.PrintWriter;
import java.util.LinkedList;

public class XMLDumper {
    private boolean startTagOpen = false;
    private final LinkedList tagStack = new LinkedList();
    private PrintWriter writer = null;
    private int level = 0;
    private boolean suppressIndent = false;

    public void setWriter(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void startElement(String string) {
        this.closeStartTag();
        this.indent(this.level);
        this.write('<');
        this.write(string);
        this.push(string);
        this.startTagOpen = true;
        ++this.level;
    }

    public void closeStartTag() {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            this.write('>');
        }
    }

    public void attribute(String string, String string2) {
        this.write(' ');
        this.write(string);
        this.write('=');
        this.write('\"');
        this.chars(string2, true);
        this.write('\"');
    }

    public void data(String string) {
        if (string.length() > 0) {
            this.closeStartTag();
            this.chars(string, false);
            this.suppressIndent = true;
        }
    }

    public void chars(String string, boolean bl) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    this.write("&amp;");
                    break;
                }
                case '<': {
                    this.write("&lt;");
                    break;
                }
                case '>': {
                    this.write("&gt;");
                    break;
                }
                case '\"': {
                    if (bl) {
                        this.write("&quot;");
                        break;
                    }
                }
                default: {
                    this.write(c);
                }
            }
            ++n2;
        }
    }

    public void endElement() {
        --this.level;
        if (this.startTagOpen) {
            this.startTagOpen = false;
            this.write("/>");
            this.pop();
        } else {
            if (!this.suppressIndent) {
                this.indent(this.level);
            }
            this.write("</");
            this.write(this.pop());
            this.write(">");
        }
        this.suppressIndent = false;
    }

    public void indent(int n) {
        this.writer.println();
        int n2 = 0;
        while (n2 < n) {
            this.write("  ");
            ++n2;
        }
    }

    public void write(String string) {
        this.writer.print(string);
    }

    public void write(char c) {
        this.writer.print(c);
    }

    public void push(String string) {
        this.tagStack.add(string);
    }

    public String pop() {
        String string = (String)this.tagStack.removeLast();
        return string;
    }
}

