/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.parsers;

import com.objfac.util.CustomHashMap;
import com.objfac.util.Equator;
import com.objfac.util.Local;
import com.objfac.util.SortedMap;
import com.objfac.xml.parsers.IErrorHandler;
import com.objfac.xml.schema.impl.Dfm;
import com.objfac.xml.schema.impl.Nfm;
import com.objfac.xml.schema.impl.NfmNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class NfmParser {
    private IErrorHandler fErrorHandler;
    private HashMap equiv;
    private Dfm start;

    public void setErrorHandler(IErrorHandler iErrorHandler) {
        this.fErrorHandler = iErrorHandler;
    }

    public Dfm parse(Nfm nfm, boolean bl) {
        Dfm dfm = this.parseStart(nfm.getStart(), nfm.getStop());
        ArrayList arrayList = new ArrayList();
        NfmParser.collect(dfm, arrayList);
        ArrayList arrayList2 = new ArrayList();
        this.detect(arrayList, arrayList2);
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap();
        this.resolve(arrayList, arrayList2, hashMap, hashSet);
        this.replace(arrayList, hashMap);
        if (hashSet.size() == 0) {
            if (bl) {
                this.optimize(arrayList);
            }
        } else {
            this.reportErrors(hashSet);
        }
        Nfm.free(nfm);
        NfmNode.freeAll();
        return dfm;
    }

    private void reportErrors(HashSet hashSet) {
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.reportError((String)iterator.next());
        }
    }

    private void reportError(String string) {
        if (this.fErrorHandler != null) {
            this.fErrorHandler.error(Local.format((String)"Ambiguous content model starting with {0}", (Object)string));
        }
    }

    public static void collect(Dfm dfm, List list) {
        list.add(dfm);
        NfmParser.collect1(dfm, list);
    }

    private static void collect1(Dfm dfm, List list) {
        Object[] objectArray = dfm.getValues();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                Dfm dfm2 = (Dfm)objectArray[n];
                if (!list.contains(dfm2)) {
                    list.add(dfm2);
                    NfmParser.collect1(dfm2, list);
                }
                ++n;
            }
        }
    }

    private void replace(ArrayList arrayList, HashMap hashMap) {
        int n = 0;
        while (n < arrayList.size()) {
            Dfm dfm = (Dfm)arrayList.get(n);
            Object[] objectArray = dfm.getValues();
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    Dfm dfm2;
                    Dfm dfm3 = (Dfm)objectArray[n2];
                    while ((dfm2 = (Dfm)hashMap.get(dfm3)) != null) {
                        dfm3 = dfm2;
                    }
                    objectArray[n2] = dfm3;
                    ++n2;
                }
            }
            ++n;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Dfm.free((Dfm)iterator.next());
        }
    }

    private void detect(ArrayList arrayList, ArrayList arrayList2) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object object;
            Dfm dfm = (Dfm)iterator.next();
            Object[] objectArray = dfm.getKeys();
            Object[] objectArray2 = dfm.getValues();
            boolean bl = false;
            if (objectArray == null) continue;
            boolean[] blArray = new boolean[objectArray.length];
            String string = null;
            int n = 0;
            int n2 = -1;
            while (n < objectArray.length) {
                object = objectArray[n].toString();
                if (string != null && string == object) {
                    int n3 = n;
                    if (objectArray[n2] != objectArray[n]) {
                        this.reportError((String)object);
                    } else if (objectArray2[n] != objectArray2[n2]) {
                        Dfm dfm2 = (Dfm)objectArray2[n2];
                        Dfm dfm3 = (Dfm)objectArray2[n];
                        if (dfm2.id > dfm3.id) {
                            Dfm dfm4 = dfm2;
                            dfm2 = dfm3;
                            dfm3 = dfm4;
                            n3 = n2;
                            n2 = n;
                        }
                        arrayList2.add(new Conflict(dfm, (String)object, dfm2, dfm3));
                    }
                    bl = true;
                    blArray[n3] = true;
                } else {
                    string = object;
                    n2 = n;
                }
                ++n;
            }
            if (!bl) continue;
            SortedMap sortedMap = dfm.getMap();
            n2 = 0;
            object = sortedMap.keyIterator();
            while (object.hasNext()) {
                object.next().toString();
                if (blArray[n2]) {
                    object.remove();
                }
                ++n2;
            }
            Dfm.freeMap((SortedMap)sortedMap);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void resolve(ArrayList var1_1, ArrayList var2_2, HashMap var3_3, HashSet var4_4) {
        var5_5 = new HashSet<Conflict>();
        var6_6 = 0;
        while (var6_6 < var2_2.size()) {
            block9: {
                block11: {
                    block10: {
                        var7_7 = (Conflict)var2_2.get(var6_6);
                        if (!var5_5.add(var7_7)) break block9;
                        if (var7_7.dfm1.accepting == var7_7.dfm2.accepting) break block10;
                        var4_4.add(var7_7.name);
                        break block9;
                    }
                    var8_8 = var7_7.dfm1.getKeys();
                    if (var8_8 == null == ((var9_9 = var7_7.dfm2.getKeys()) == null)) break block11;
                    var4_4.add(var7_7.name);
                    break block9;
                }
                if (var8_8 == null) ** GOTO lbl46
                if (var8_8.length != var9_9.length) {
                    var4_4.add(var7_7.name);
                } else {
                    var10_10 = 0;
                    while (var10_10 < var9_9.length) {
                        if (var8_8[var10_10] != var9_9[var10_10]) {
                            var4_4.add(var7_7.name);
                            break block9;
                        }
                        ++var10_10;
                    }
                    var10_11 = var7_7.dfm1.getValues();
                    var11_12 = var7_7.dfm2.getValues();
                    var12_13 = 0;
                    while (var12_13 < var9_9.length) {
                        if (var10_11[var12_13] != var11_12[var12_13]) {
                            var13_14 = (Dfm)var10_11[var12_13];
                            var14_15 = (Dfm)var11_12[var12_13];
                            if (var13_14.id > var14_15.id) {
                                var15_16 = var13_14;
                                var13_14 = var14_15;
                                var14_15 = var15_16;
                            }
                            if (!var5_5.contains(var15_16 = new Conflict(var7_7.dfm1, var7_7.dfm2, var8_8[var12_13].toString(), var13_14, var14_15))) {
                                var2_2.add(var15_16);
                            }
                        }
                        ++var12_13;
                    }
lbl46:
                    // 2 sources

                    var3_3.put(var7_7.dfm1, var7_7.dfm2);
                }
            }
            ++var6_6;
        }
    }

    private void optimize(ArrayList arrayList) {
        Object object;
        HashMap hashMap = new HashMap();
        EquivalenceMap equivalenceMap = new EquivalenceMap();
        int n = 0;
        while (n < arrayList.size()) {
            object = (Dfm)arrayList.get(n);
            this.addCandidate(equivalenceMap, (Dfm)object);
            ++n;
        }
        EquivalenceMap equivalenceMap2 = new EquivalenceMap();
        if (equivalenceMap.size() > 0) {
            object = equivalenceMap.valueIterator();
            while (object.hasNext()) {
                ArrayList arrayList2 = (ArrayList)object.next();
                this.removeDuplicates(arrayList2, hashMap, equivalenceMap2);
            }
            equivalenceMap = equivalenceMap2;
        }
        if (hashMap.size() > 0) {
            this.replace(arrayList, hashMap);
        }
    }

    private void removeDuplicates(ArrayList arrayList, HashMap hashMap, EquivalenceMap equivalenceMap) {
        int n = arrayList.size();
        if (n < 2) {
            return;
        }
        Dfm dfm = (Dfm)arrayList.get(0);
        Object[] objectArray = dfm.getValues();
        boolean cfr_ignored_0 = dfm.accepting;
        if (objectArray == null || objectArray.length == 0) {
            this.doRemove(arrayList, hashMap);
            return;
        }
        ArrayList[] cfr_ignored_1 = new ArrayList[objectArray.length];
        int n2 = 1;
        while (n2 < arrayList.size()) {
            Dfm dfm2 = (Dfm)arrayList.get(n2);
            Object[] objectArray2 = dfm2.getValues();
            boolean bl = true;
            int n3 = 0;
            while (n3 < objectArray2.length) {
                if (objectArray[n3] != objectArray2[n3]) {
                    this.addCandidate(equivalenceMap, dfm2);
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (bl) {
                this.doRemove(arrayList, hashMap, n2);
            }
            ++n2;
        }
    }

    private void doRemove(ArrayList arrayList, HashMap hashMap, int n) {
        Dfm dfm = (Dfm)arrayList.get(0);
        Dfm dfm2 = (Dfm)arrayList.get(n);
        if (dfm.id > dfm2.id) {
            Dfm dfm3 = dfm;
            dfm = dfm2;
            dfm2 = dfm3;
        }
        hashMap.put(dfm2, dfm);
    }

    private void doRemove(ArrayList arrayList, HashMap hashMap) {
        Dfm dfm;
        Dfm dfm2 = null;
        int n = 1;
        while (n < arrayList.size()) {
            dfm = (Dfm)arrayList.get(n);
            if (dfm2 == null) {
                dfm2 = dfm;
            } else if (dfm2.id > dfm.id) {
                dfm2 = dfm;
            }
            ++n;
        }
        n = 1;
        while (n < arrayList.size()) {
            dfm = (Dfm)arrayList.get(n);
            if (dfm != dfm2) {
                hashMap.put(dfm, dfm2);
            }
            ++n;
        }
    }

    private void addCandidate(EquivalenceMap equivalenceMap, Dfm dfm) {
        ArrayList<Dfm> arrayList = (ArrayList<Dfm>)equivalenceMap.get(dfm);
        if (arrayList == null) {
            arrayList = new ArrayList<Dfm>();
            equivalenceMap.put(dfm, arrayList);
        }
        arrayList.add(dfm);
    }

    private void optimize(Dfm dfm) {
        this.start = dfm;
        this.equiv = new HashMap();
        this.equiv.put(dfm, Boolean.FALSE);
        this.traverse(dfm);
    }

    private void traverse(Dfm dfm) {
    }

    private Dfm parseStart(NfmNode nfmNode, NfmNode nfmNode2) {
        Dfm dfm;
        nfmNode.dfm = dfm = Dfm.dfm(false);
        while (nfmNode.next1 != null && nfmNode.next2 == null && nfmNode.symbol == null) {
            nfmNode = nfmNode.next1;
            nfmNode.dfm = dfm;
        }
        Dfm dfm2 = this.parse(1, nfmNode, nfmNode2);
        dfm.merge(dfm2);
        Dfm.free(dfm2);
        return dfm;
    }

    private void parseNext(int n, Dfm dfm, NfmNode nfmNode, NfmNode nfmNode2) {
        Dfm dfm2 = this.parse(n + 1, nfmNode, nfmNode2);
        dfm.merge(dfm2);
        Dfm.free(dfm2);
    }

    private Dfm parse(int n, NfmNode nfmNode, NfmNode nfmNode2) {
        int n2;
        while (nfmNode.next1 != null && nfmNode.next2 == null && nfmNode.symbol == null) {
            nfmNode = nfmNode.next1;
        }
        if (nfmNode == nfmNode2) {
            return Dfm.dfm(true);
        }
        if (nfmNode.symbol != null) {
            Object object;
            NfmNode nfmNode3;
            Dfm dfm = null;
            NfmNode nfmNode4 = nfmNode3 = nfmNode.next1;
            while (nfmNode4.dfm == null && nfmNode4.next1 != null && nfmNode4.next2 == null && nfmNode4.symbol == null) {
                nfmNode4 = nfmNode4.next1;
            }
            if (nfmNode4.dfm != null) {
                object = nfmNode3;
                while (object != nfmNode4) {
                    object.dfm = nfmNode4.dfm;
                    object = object.next1;
                }
                dfm = nfmNode4.dfm;
            } else {
                nfmNode4.dfm = dfm = Dfm.dfm(false);
                object = nfmNode3;
                while (object != nfmNode4) {
                    object.dfm = dfm;
                    object = object.next1;
                }
                this.parseNext(n, dfm, nfmNode4, nfmNode2);
            }
            object = Dfm.dfm(nfmNode.symbol, dfm);
            return object;
        }
        Dfm dfm = null;
        Dfm dfm2 = null;
        if (nfmNode.next1 != null && nfmNode.next1.mark != n) {
            n2 = nfmNode.next1.mark;
            nfmNode.next1.mark = n;
            dfm = this.parse(n, nfmNode.next1, nfmNode2);
            nfmNode.next1.mark = n2;
        }
        if (nfmNode.next2 != null && nfmNode.next2.mark != n) {
            n2 = nfmNode.next2.mark;
            nfmNode.next2.mark = n;
            dfm2 = this.parse(n, nfmNode.next2, nfmNode2);
            nfmNode.next2.mark = n2;
        }
        if (dfm2 != null) {
            if (dfm != null) {
                dfm.merge(dfm2);
            } else {
                dfm = dfm2;
            }
        }
        return dfm;
    }

    private static class EquivalenceMap
    extends CustomHashMap {
        public EquivalenceMap() {
            super(new Equator(){

                public boolean equal(Object object, Object object2) {
                    if (!(object instanceof Dfm) || !(object2 instanceof Dfm)) {
                        return false;
                    }
                    if (object == object2) {
                        return true;
                    }
                    Dfm dfm = (Dfm)object;
                    Dfm dfm2 = (Dfm)object2;
                    Object[] objectArray = dfm.keys;
                    Object[] objectArray2 = dfm2.keys;
                    if (dfm.accepting != dfm2.accepting || objectArray == null != (objectArray2 == null) || objectArray != null && objectArray.length != objectArray2.length) {
                        return false;
                    }
                    if (objectArray == null) {
                        return true;
                    }
                    int n = 0;
                    while (n < objectArray.length) {
                        if (objectArray[n] != objectArray2[n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }

                public int hash(Object object) {
                    Dfm dfm = (Dfm)object;
                    int n = dfm.accepting ? 1 : 0;
                    Object[] objectArray = dfm.keys;
                    if (objectArray == null) {
                        return n;
                    }
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        n += objectArray[n2].hashCode();
                        ++n2;
                    }
                    return n;
                }
            });
        }
    }

    private static class Conflict {
        public String name;
        public Dfm dfm1;
        public Dfm dfm2;
        public Dfm host1;
        public Dfm host2;

        public Conflict(Dfm dfm, String string, Dfm dfm2, Dfm dfm3) {
            this.host1 = dfm;
            this.name = string;
            this.dfm1 = dfm2;
            this.dfm2 = dfm3;
        }

        public Conflict(Dfm dfm, Dfm dfm2, String string, Dfm dfm3, Dfm dfm4) {
            this.host1 = dfm;
            this.host2 = dfm2;
            this.name = string;
            this.dfm1 = dfm3;
            this.dfm2 = dfm4;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Conflict)) {
                return false;
            }
            Conflict conflict = (Conflict)object;
            return this.dfm1 == conflict.dfm1 && this.dfm2 == conflict.dfm2;
        }
    }
}

