/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.schema.impl;

import com.objfac.util.Misc;
import com.objfac.xml.io.DocumentCache;
import com.objfac.xml.io.IDocumentReaderFactory;
import com.objfac.xml.schema.IExternalEntity;
import com.objfac.xml.schema.UnknownPublicIdentifierException;
import java.io.IOException;
import java.util.HashMap;

public class ExternalEntity
implements IExternalEntity {
    private String fPubId;
    private String fSysId;
    private String fAbsUrl;
    private ExternalEntity fParent;
    private HashMap fPubMap = new HashMap();
    private IDocumentReaderFactory fFactory;

    public ExternalEntity(ExternalEntity externalEntity, String string, String string2, IDocumentReaderFactory iDocumentReaderFactory) {
        this.fParent = externalEntity;
        this.fPubId = string;
        this.fSysId = string2;
        this.fFactory = iDocumentReaderFactory;
    }

    public IExternalEntity getEntity(String string, String string2) {
        return new ExternalEntity(this, string, string2, this.fFactory);
    }

    public IDocumentReaderFactory getFactory() {
        return this.fFactory;
    }

    public String getStringContents() throws IOException {
        String string = this.fParent == null ? null : this.fParent.getAbsUrl();
        char[] cArray = DocumentCache.getCache().getContents(this.getPublicId(), this.getSystemUrl(), string, this.getFactory());
        return new String(cArray);
    }

    public void getContents(StringBuffer stringBuffer) throws IOException {
        String string = this.fParent == null ? null : this.fParent.getAbsUrl();
        DocumentCache.getCache().getContents(stringBuffer, this.getPublicId(), this.getSystemUrl(), string, this.getFactory());
    }

    public char[] getContents() throws IOException {
        String string = this.fParent == null ? null : this.fParent.getAbsUrl();
        return DocumentCache.getCache().getContents(this.getPublicId(), this.getSystemUrl(), string, this.getFactory());
    }

    public String getPublicId() {
        return this.fPubId;
    }

    public String getSystemId() {
        return this.fSysId;
    }

    private String getSystemUrl() {
        if (this.fSysId != null) {
            return this.fSysId;
        }
        if (this.fPubId != null && this.fPubId.length() > 0) {
            return (String)this.fPubMap.get(this.fPubId);
        }
        return null;
    }

    public String getAbsUrl() throws UnknownPublicIdentifierException {
        if (this.fAbsUrl == null) {
            if (this.fSysId == null) {
                if (this.fPubId == null || this.fPubId.equals("")) {
                    throw new IllegalArgumentException("At least one of fPubId or fSysId must be specified");
                }
                this.fAbsUrl = (String)this.fPubMap.get(this.fPubId);
                if (this.fAbsUrl == null) {
                    throw new UnknownPublicIdentifierException("No system identifier known for " + this.fPubId);
                }
            } else {
                if (this.fParent != null) {
                    String string = this.fParent.getAbsUrl();
                    this.fAbsUrl = Misc.getAbsUrl((String)string, (String)this.fSysId);
                } else {
                    if (!Misc.isAbsolute((String)this.fSysId)) {
                        throw new IllegalStateException("Url must be absolute " + this.fSysId);
                    }
                    this.fAbsUrl = this.fSysId;
                }
                if (this.fPubId != null && !this.fPubId.equals("")) {
                    this.fPubMap.put(this.fPubId, this.fAbsUrl);
                }
            }
        }
        return this.fAbsUrl;
    }

    public IExternalEntity getParent() {
        return this.fParent;
    }
}

