/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xerces;

import com.objfac.xml.DefaultLocatorInfo;
import com.objfac.xml.ErrorCallback;
import com.objfac.xml.LocatorInfo;
import com.objfac.xmleditor.xerces.SAXParseBundle;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorCallbackErrorHandler
implements ErrorHandler,
ErrorListener {
    private ErrorCallback callback;
    private boolean fatal;

    public ErrorCallbackErrorHandler(ErrorCallback errorCallback) {
        this.callback = errorCallback;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.parseError(1, "warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.parseError(2, "error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.fatal = true;
        this.parseError(3, "fatal", sAXParseException);
    }

    public void initializationError(String string, Exception exception, String string2) {
        if (this.fatal) {
            return;
        }
        Object object = exception instanceof SAXParseException ? this.makeLocator((SAXParseException)exception) : new DefaultLocatorInfo(null, string2, 1, 0);
        this.callback.error(3, this.format(string, exception), object);
    }

    private void parseError(int n, String string, SAXParseException sAXParseException) {
        LocatorInfo locatorInfo = this.makeLocator(sAXParseException);
        this.callback.error(n, this.format(string, sAXParseException), locatorInfo);
    }

    private LocatorInfo makeLocator(SAXParseException sAXParseException) {
        return new DefaultLocatorInfo(sAXParseException.getPublicId(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
    }

    private String format(String string, Throwable throwable) {
        ResourceBundle resourceBundle = SAXParseBundle.bundle();
        String string2 = resourceBundle.getString(string);
        String string3 = throwable.getMessage();
        if (string3 == null) {
            string3 = throwable.toString();
        }
        return MessageFormat.format(resourceBundle.getString("format"), string2, string3);
    }

    public void error(TransformerException transformerException) throws TransformerException {
        this.transformerException(2, transformerException);
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        throw transformerException;
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        this.transformerException(1, transformerException);
    }

    private void transformerException(int n, TransformerException transformerException) {
        Throwable throwable;
        while ((throwable = transformerException.getCause()) != null) {
            if (!(throwable instanceof TransformerException)) break;
            transformerException = (TransformerException)throwable;
            throwable = null;
        }
        String string = throwable != null ? throwable.toString() : transformerException.getMessageAndLocation();
        SourceLocator sourceLocator = transformerException.getLocator();
        DefaultLocatorInfo defaultLocatorInfo = sourceLocator == null ? new DefaultLocatorInfo(1, 1) : new DefaultLocatorInfo(sourceLocator.getSystemId(), sourceLocator.getSystemId(), sourceLocator.getLineNumber(), sourceLocator.getColumnNumber());
        this.callback.error(n, string, (LocatorInfo)defaultLocatorInfo);
    }
}

