/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xerces;

import com.objfac.walker.IWalker;
import com.objfac.xml.ErrorCallback;
import com.objfac.xmleditor.resources.ResourceWatcherCallback;
import com.objfac.xmleditor.validate.ISchemaReader;
import com.objfac.xmleditor.xerces.CacheEntityResolver;
import com.objfac.xmleditor.xerces.ErrorCallbackErrorHandler;
import com.thaiopensource.relaxng.impl.CombineSchema;
import com.thaiopensource.relaxng.impl.DTDWalkerFactory;
import com.thaiopensource.relaxng.impl.PatternPool;
import com.thaiopensource.relaxng.impl.PatternSchema;
import com.thaiopensource.relaxng.impl.PatternWalker;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.rng.RngProperty;
import com.thaiopensource.validate.rng.SAXSchemaReader;
import com.thaiopensource.xml.sax.Sax2XMLReaderCreator;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RELAXNGSchemaReader
implements ISchemaReader {
    public IWalker read(String string, Reader reader, String string2, int n, IWalker iWalker, ErrorCallback errorCallback, ResourceWatcherCallback resourceWatcherCallback) {
        SchemaReader schemaReader;
        resourceWatcherCallback.watchResource(string);
        String string3 = "schemaparsefailed";
        ErrorCallbackErrorHandler errorCallbackErrorHandler = new ErrorCallbackErrorHandler(errorCallback);
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, (ErrorHandler)errorCallbackErrorHandler);
        ValidateProperty.ENTITY_RESOLVER.put(propertyMapBuilder, (EntityResolver)new CacheEntityResolver(resourceWatcherCallback));
        ValidateProperty.XML_READER_CREATOR.put(propertyMapBuilder, (XMLReaderCreator)new Sax2XMLReaderCreator("org.apache.xerces.parsers.SAXParser"));
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        PropertyMap propertyMap = propertyMapBuilder.toPropertyMap();
        switch (n) {
            case 0: {
                schemaReader = SAXSchemaReader.getInstance();
                break;
            }
            case 1: {
                schemaReader = CompactSchemaReader.getInstance();
                break;
            }
            case 2: {
                throw new IllegalStateException("XSD not handled here");
            }
            case 3: {
                throw new IllegalStateException("NRL not handled yet");
            }
            default: {
                throw new IllegalStateException("Unknown schemaKind " + n);
            }
        }
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        if (string2 != null) {
            inputSource.setEncoding(string2);
        }
        try {
            Schema schema = schemaReader.createSchema(inputSource, propertyMap);
            if (schema instanceof CombineSchema) {
                if (((CombineSchema)schema).schema1 instanceof PatternSchema) {
                    schema = ((CombineSchema)schema).schema1;
                } else if (((CombineSchema)schema).schema2 instanceof PatternSchema) {
                    schema = ((CombineSchema)schema).schema2;
                }
            }
            if (schema instanceof PatternSchema) {
                return new PatternWalker(new PatternPool(), ((PatternSchema)schema).start, iWalker);
            }
        }
        catch (IncorrectSchemaException incorrectSchemaException) {
            errorCallbackErrorHandler.initializationError(string3, (Exception)((Object)incorrectSchemaException), string);
        }
        catch (SAXException sAXException) {
            errorCallbackErrorHandler.initializationError(string3, sAXException, string);
        }
        catch (IOException iOException) {
            errorCallbackErrorHandler.initializationError(string3, iOException, string);
        }
        return null;
    }

    public IWalker read(char[] cArray, String string, char[] cArray2, String string2, String string3, ErrorCallback errorCallback, ResourceWatcherCallback resourceWatcherCallback) {
        boolean bl = string2 == string3;
        ErrorCallbackErrorHandler errorCallbackErrorHandler = new ErrorCallbackErrorHandler(errorCallback);
        CacheEntityResolver cacheEntityResolver = new CacheEntityResolver(resourceWatcherCallback);
        try {
            return DTDWalkerFactory.makeDtdWalker((char[])cArray, (String)string, (char[])cArray2, (String)string2, (String)string3, (EntityResolver)cacheEntityResolver, (ErrorHandler)errorCallbackErrorHandler);
        }
        catch (SAXException sAXException) {
            errorCallbackErrorHandler.initializationError("schemaparsefailed", sAXException, bl ? string : string3);
            return null;
        }
    }
}

