/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xerces;

import com.objfac.util.Local;
import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.resources.AbstractEditor;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLNodeTree;
import com.objfac.xmleditor.xmltree.XMLTree;
import com.objfac.xmleditor.xpath.ResultImpl;
import com.objfac.xmleditor.xpath.XPathChecker;
import com.objfac.xmleditor.xpath.XPathRunner;
import java.io.CharArrayReader;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xpath.StandaloneContext;
import net.sf.saxon.xpath.XPathEvaluator;
import org.w3c.dom.Node;

public class Saxon7Evaluator
implements XPathRunner,
XPathChecker {
    private static final int[] fTypes = new int[]{1, 2, 3, 7, 8, 9, 13};
    private static final int[] fResultTypes = new int[]{1, 2, 3, 4, 5, 6, 7};

    public List check(String string, XMLNode xMLNode) {
        LinkedList linkedList = new LinkedList();
        try {
            StandaloneContext standaloneContext = new StandaloneContext();
            this.addNamespaces(standaloneContext, xMLNode);
            ExpressionTool.make((String)string, (StaticContext)standaloneContext, (int)0, (int)0, (int)0);
        }
        catch (XPathException xPathException) {
            this.addError(xPathException, linkedList);
        }
        return linkedList;
    }

    private void addNamespaces(StandaloneContext standaloneContext, XMLNode xMLNode) {
        XMLNode.Namespace namespace = xMLNode.getNamespaceChain();
        while (namespace != null) {
            if (namespace.prefix != null && namespace.prefix.length() > 0 && namespace.uri != null && namespace.uri.length() > 0) {
                standaloneContext.declareNamespace(namespace.prefix, namespace.uri);
            }
            namespace = namespace.next;
        }
    }

    public List evaluate(String string, AbstractEditor abstractEditor, XMLNode xMLNode) {
        LinkedList linkedList = new LinkedList();
        XPathEvaluator xPathEvaluator = new XPathEvaluator();
        StreamSource streamSource = new StreamSource(new CharArrayReader(abstractEditor.getContents()), abstractEditor.getUrl());
        try {
            List list;
            NodeInfo nodeInfo = xPathEvaluator.setSource((Source)streamSource);
            if (xMLNode != null && (list = this.findNodeInDocument(nodeInfo, abstractEditor.getXMLTree(), xMLNode)) != null) {
                xPathEvaluator.setContextNode((NodeInfo)list);
                StandaloneContext standaloneContext = xPathEvaluator.getStaticContext();
                if (standaloneContext instanceof StandaloneContext) {
                    this.addNamespaces(standaloneContext, xMLNode);
                }
            }
            list = xPathEvaluator.evaluate(string);
            this.convertResults(list, linkedList);
        }
        catch (XPathException xPathException) {
            this.addError(xPathException, linkedList);
        }
        return linkedList;
    }

    private void addError(XPathException xPathException, LinkedList linkedList) {
        String string = xPathException.getLocalizedMessage();
        if (string == null) {
            string = xPathException.toString();
        }
        SourceLocator sourceLocator = xPathException.getLocator();
        int n = 0;
        if (sourceLocator != null) {
            n = sourceLocator.getColumnNumber();
        }
        linkedList.add(new ResultImpl(0, Local.getString((String)"Error"), string, n));
    }

    private void convertResults(List list, LinkedList linkedList) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof NodeInfo) {
                NodeInfo nodeInfo = (NodeInfo)e;
                if (!(nodeInfo instanceof Node)) continue;
                Node node = (Node)nodeInfo;
                String string = node.getNodeName();
                String string2 = node.getNodeValue();
                if (string2 == null) {
                    string2 = "";
                }
                int n = nodeInfo.getNodeKind();
                int n2 = 9;
                int n3 = 0;
                while (n3 < fTypes.length) {
                    if (n == fTypes[n3]) {
                        n2 = fResultTypes[n3];
                        break;
                    }
                    ++n3;
                }
                if (n2 == 1) {
                    String string3;
                    Object object;
                    Item item;
                    StringBuffer stringBuffer = new StringBuffer();
                    AxisIterator axisIterator = nodeInfo.iterateAxis((byte)3, (NodeTest)new AnyNodeTest());
                    boolean bl = false;
                    boolean bl2 = true;
                    while (axisIterator.next() != null) {
                        NodeInfo nodeInfo2;
                        item = axisIterator.current();
                        if (!(item instanceof NodeInfo) || ((NodeInfo)item).getNodeKind() != 3 || !((nodeInfo2 = (NodeInfo)item) instanceof Node)) continue;
                        object = (Node)nodeInfo2;
                        string3 = object.getNodeValue();
                        int n4 = 0;
                        int n5 = string3.length();
                        while (n4 < n5) {
                            char c = string3.charAt(n4);
                            if (XMLCharacter.isWhitespace((char)c)) {
                                bl = true;
                            } else {
                                if (bl && !bl2) {
                                    stringBuffer.append(' ');
                                }
                                bl = false;
                                bl2 = false;
                                stringBuffer.append(c);
                            }
                            ++n4;
                        }
                    }
                    item = nodeInfo.iterateAxis((byte)2, (NodeTest)new AnyNodeTest());
                    boolean bl3 = true;
                    while (item.next() != null) {
                        object = item.current();
                        if (!(object instanceof NodeInfo) || ((NodeInfo)object).getNodeKind() != 2 || !((string3 = (NodeInfo)object) instanceof Node)) continue;
                        Node node2 = (Node)((Object)string3);
                        String string4 = node2.getNodeName();
                        String string5 = node2.getNodeValue();
                        if (bl3) {
                            if (!bl2) {
                                stringBuffer.append(' ');
                            }
                            stringBuffer.append('(');
                            bl3 = false;
                        } else {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append(string4).append("=\"").append(string5).append('\"');
                    }
                    if (!bl3) {
                        stringBuffer.append(')');
                    }
                    string2 = stringBuffer.toString();
                }
                linkedList.add(new ResultImpl(n2, string, string2, 0));
                continue;
            }
            if (e instanceof Boolean) {
                linkedList.add(new ResultImpl(8, "xsd:boolean", ((Boolean)e).toString(), 0));
                continue;
            }
            if (e instanceof String) {
                linkedList.add(new ResultImpl(8, "xsd:string", ((String)e).toString(), 0));
                continue;
            }
            if (e instanceof BigDecimal) {
                linkedList.add(new ResultImpl(8, "xsd:decimal", ((BigDecimal)e).toString(), 0));
                continue;
            }
            if (e instanceof Long) {
                linkedList.add(new ResultImpl(8, "xsd:integer", ((Long)e).toString(), 0));
                continue;
            }
            if (e instanceof Double) {
                linkedList.add(new ResultImpl(8, "xsd:double", ((Double)e).toString(), 0));
                continue;
            }
            if (e instanceof Float) {
                linkedList.add(new ResultImpl(8, "xsd:float", ((Float)e).toString(), 0));
                continue;
            }
            if (!(e instanceof Date)) continue;
            linkedList.add(new ResultImpl(8, "xsd:dateTime", new SimpleDateFormat().format((Date)e), 0));
        }
    }

    private NodeInfo findNodeInDocument(NodeInfo nodeInfo, XMLTree xMLTree, XMLNode xMLNode) {
        NodeInfo nodeInfo2 = null;
        String string = xMLNode.getType();
        if (string == "com.objfac.xmlstarttag" || string == "com.objfac.xmlemptytag") {
            String string2 = xMLNode.getLocalname();
            String string3 = xMLNode.getNamespace();
            int n = nodeInfo.getNamePool().getFingerprint(string3 == null ? "" : string3, string2);
            if (n >= 0) {
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)4, (NodeTest)new NameTest(1, n, nodeInfo.getNamePool()));
                Iterator iterator = this.getContextIterator(xMLTree, string2, string3);
                while (axisIterator.next() != null) {
                    Item item = axisIterator.current();
                    if (!(item instanceof NodeInfo) || ((NodeInfo)item).getNodeKind() != 1) continue;
                    NodeInfo nodeInfo3 = (NodeInfo)item;
                    if (!iterator.hasNext()) break;
                    XMLNode xMLNode2 = (XMLNode)iterator.next();
                    if (xMLNode2 != xMLNode) continue;
                    nodeInfo2 = nodeInfo3;
                    break;
                }
            }
        }
        return nodeInfo2;
    }

    private Iterator getContextIterator(XMLTree xMLTree, final String string, final String string2) {
        final LinkedList linkedList = new LinkedList();
        xMLTree.visit(new XMLNodeTree.Visitor(){

            public void visit(XMLNode xMLNode) {
                String string4 = xMLNode.getType();
                if (string4 == "com.objfac.xmlstarttag" || string4 == "com.objfac.xmlemptytag") {
                    String string22 = xMLNode.getLocalname();
                    String string3 = xMLNode.getNamespace();
                    if (string22.equals(string) && string3.equals(string2)) {
                        linkedList.add(xMLNode);
                    }
                }
            }
        });
        return linkedList.iterator();
    }
}

