/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.xerces;

import com.objfac.xml.ErrorCallback;
import com.objfac.xmleditor.resources.ResourceWatcherCallback;
import com.objfac.xmleditor.validate.ITransform;
import com.objfac.xmleditor.validate.ITransformResult;
import com.objfac.xmleditor.validate.TransformArguments;
import com.objfac.xmleditor.validate.TransformResult;
import com.objfac.xmleditor.xerces.CacheEntityResolver;
import com.objfac.xmleditor.xerces.ErrorCallbackErrorHandler;
import java.io.CharArrayWriter;
import java.util.ArrayList;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.TransformerFactoryImpl;

public class Saxon7Transform
implements ITransform {
    public ITransformResult[] transform(String string, TransformArguments transformArguments, ErrorCallback errorCallback, ResourceWatcherCallback resourceWatcherCallback) {
        ErrorCallbackErrorHandler errorCallbackErrorHandler = new ErrorCallbackErrorHandler(errorCallback);
        CacheEntityResolver cacheEntityResolver = new CacheEntityResolver(resourceWatcherCallback);
        try {
            Source source = cacheEntityResolver.resolve(transformArguments.inputUri, string);
            Source source2 = cacheEntityResolver.resolve(string, null);
            return this.transform(source2, source, transformArguments, errorCallbackErrorHandler, cacheEntityResolver);
        }
        catch (TransformerException transformerException) {
            this.error(errorCallbackErrorHandler, transformerException);
            return null;
        }
    }

    private void setParams(Transformer transformer, TransformArguments transformArguments) {
        ArrayList arrayList = transformArguments.params;
        if (arrayList != null) {
            int n = 0;
            int n2 = arrayList.size();
            while (n < n2) {
                TransformArguments.Param param = (TransformArguments.Param)arrayList.get(n);
                transformer.setParameter(param.name, param.value);
                ++n;
            }
        }
    }

    private void error(ErrorCallbackErrorHandler errorCallbackErrorHandler, TransformerException transformerException) {
        try {
            errorCallbackErrorHandler.error(transformerException);
        }
        catch (TransformerException transformerException2) {}
    }

    public ITransformResult[] transform(String string, String string2, TransformArguments transformArguments, ErrorCallback errorCallback, ResourceWatcherCallback resourceWatcherCallback) {
        ErrorCallbackErrorHandler errorCallbackErrorHandler = new ErrorCallbackErrorHandler(errorCallback);
        CacheEntityResolver cacheEntityResolver = new CacheEntityResolver(resourceWatcherCallback);
        try {
            Source source = cacheEntityResolver.resolve(string2, null);
            Source source2 = cacheEntityResolver.resolve(string, string2);
            return this.transform(source2, source, transformArguments, errorCallbackErrorHandler, cacheEntityResolver);
        }
        catch (TransformerException transformerException) {
            this.error(errorCallbackErrorHandler, transformerException);
            return null;
        }
    }

    private ITransformResult[] transform(Source source, Source source2, TransformArguments transformArguments, ErrorCallbackErrorHandler errorCallbackErrorHandler, CacheEntityResolver cacheEntityResolver) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        Configuration configuration = new Configuration();
        configuration.setURIResolver((URIResolver)cacheEntityResolver);
        configuration.setErrorListener((ErrorListener)errorCallbackErrorHandler);
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        transformerFactoryImpl.setConfiguration(configuration);
        try {
            Templates templates = transformerFactoryImpl.newTemplates(source);
            Transformer transformer = templates.newTransformer();
            this.setParams(transformer, transformArguments);
            String string = null;
            if (string != null) {
                ((Controller)transformer).setInitialMode(string);
            }
            StreamResult streamResult = new StreamResult(charArrayWriter);
            transformer.transform(source2, streamResult);
            charArrayWriter.close();
            ITransformResult[] iTransformResultArray = new ITransformResult[]{new TransformResult(charArrayWriter.toCharArray(), streamResult.getSystemId())};
            return iTransformResultArray;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.error(errorCallbackErrorHandler, transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            this.error(errorCallbackErrorHandler, transformerException);
        }
        return null;
    }
}

