/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.rse.internal.ui.actions.SystemSubMenuManager;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.actions.ISystemViewMenuListener;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.menus.CommandContributionItem;

public class SystemViewMenuListener
implements ISystemViewMenuListener {
    protected boolean menuListenerAdded = false;
    protected boolean menuMnemonicsAdded = false;
    protected boolean doOnce = false;
    protected boolean armListeners = false;
    protected Mnemonics m = new Mnemonics();
    protected ISystemMessageLine msgLine;
    static /* synthetic */ Class class$0;

    public SystemViewMenuListener() {
    }

    public SystemViewMenuListener(boolean doOnce) {
        this.doOnce = doOnce;
    }

    public void setShowToolTipText(boolean set, ISystemMessageLine msgLine) {
        this.armListeners = set;
        this.msgLine = msgLine;
    }

    public void menuAboutToShow(IMenuManager menu) {
        Menu m;
        if (!this.menuListenerAdded && menu instanceof MenuManager && (m = ((MenuManager)menu).getMenu()) != null) {
            this.menuListenerAdded = true;
            m.addMenuListener((MenuListener)this);
        }
    }

    public void menuHidden(MenuEvent event) {
    }

    public void menuShown(MenuEvent event) {
        if (!this.menuMnemonicsAdded || !this.doOnce) {
            this.m.clear();
            Menu menu = (Menu)event.getSource();
            this.m.setMnemonics(menu);
            if (this.armListeners) {
                this.setArmListener(menu);
            }
            this.menuMnemonicsAdded = true;
            if (this.doOnce) {
                ((Menu)event.getSource()).removeMenuListener((MenuListener)this);
            }
        }
    }

    private void setArmListener(Menu menu) {
        MenuItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem menuItem = items[i];
            this.setArmListener(menuItem);
            ++i;
        }
    }

    private void setArmListener(MenuItem item) {
        item.addArmListener((ArmListener)this);
        Menu menu = item.getMenu();
        if (menu != null) {
            this.setArmListener(menu);
        }
    }

    public void widgetArmed(ArmEvent event) {
        MenuItem mi;
        Object data;
        if (this.msgLine == null) {
            return;
        }
        this.msgLine.clearMessage();
        Widget w = event.widget;
        if (w instanceof MenuItem && (data = (mi = (MenuItem)w).getData()) != null) {
            String tip = null;
            if (data instanceof ActionContributionItem) {
                tip = ((ActionContributionItem)data).getAction().getToolTipText();
            } else if (data instanceof CommandContributionItem) {
                try {
                    tip = ((CommandContributionItem)data).getData().tooltip;
                }
                catch (Throwable throwable) {
                    try {
                        Field f = data.getClass().getDeclaredField("widget");
                        f.setAccessible(true);
                        Widget widget = (Widget)f.get(data);
                        Class<?> clazz = data.getClass();
                        Class[] classArray = new Class[1];
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz2;
                        Method m = clazz.getDeclaredMethod("getToolTipText", classArray);
                        m.setAccessible(true);
                        tip = (String)m.invoke(data, widget instanceof Item ? ((Item)widget).getText() : null);
                    }
                    catch (Exception exception) {}
                }
            } else if (data instanceof SystemSubMenuManager) {
                tip = ((SystemSubMenuManager)((Object)data)).getToolTipText();
            }
            if (tip != null) {
                this.msgLine.setMessage(tip);
            }
        }
    }
}

