/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.common.WSDLParserFactory;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.command.data.EclipseIPath2URLStringTransformer;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.WSDLSelectionDialog;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.WSDLSelectionOutputCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.WSDLSelectionWidgetWrapper;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.WebServiceClientTypeWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.Timer;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.jst.ws.internal.ui.common.ComboWithHistory;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.ui.widgets.PageInfo;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetContributorFactory;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class ClientWizardWidget
extends SimpleWidgetDataContributor
implements Runnable {
    private WebServiceClientTypeWidget clientWidget_;
    private Button overwriteButton_;
    private Button monitorService_;
    private ComboWithHistory serviceImpl_;
    private Button browseButton_;
    private WSDLSelectionDialog wsdlDialog_;
    private String componentName_;
    private IProject project_;
    private String webServiceURI_;
    private WebServicesParser parser_;
    private ResourceContext resourceContext_;
    private Listener statusListener_;
    private ModifyListener objectModifyListener_;
    private int validationState_;
    private boolean validObjectSelection_ = true;
    private WSDLSelectionWidgetWrapper wsdlValidatorWidget_;
    private Timer timer_ = null;
    private String INFOPOP_WSWSCEN_TEXT_SERVICE_IMPL = "WSWSCEN0020";
    private String INFOPOP_WSWSCEN_CHECKBOX_MONITOR_SERVICE = "WSWSCEN0014";
    private String INFOPOP_WSWSCEN_CHECKBOX_OVERWRITE = "WSWSCEN0030";
    private String INFOPOP_WSWSCEN_PAGE = "WSWSCEN0001";

    public void run() {
        this.validationState_ = 1;
        this.statusListener_.handleEvent(null);
        if (this.validObjectSelection_) {
            this.callObjectTransformation(this.project_, this.wsdlValidatorWidget_.getComponentName(), this.wsdlValidatorWidget_.getWsdlURI());
        }
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        String pluginId = "org.eclipse.jst.ws.consumption.ui";
        UIUtils utils = new UIUtils(pluginId);
        utils.createInfoPop((Control)parent, this.INFOPOP_WSWSCEN_PAGE);
        this.statusListener_ = statusListener;
        this.validationState_ = 1;
        Composite typeComposite = utils.createComposite(parent, 3);
        this.serviceImpl_ = utils.createComboWithHistory(typeComposite, ConsumptionUIMessages.LABEL_WEBSERVICEDEF, ConsumptionUIMessages.TOOLTIP_WSWSCEN_TEXT_IMPL, this.INFOPOP_WSWSCEN_TEXT_SERVICE_IMPL, 18432, WebServiceConsumptionUIPlugin.getInstance().getDialogSettings());
        Object layoutData = this.serviceImpl_.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).widthHint = 225;
        }
        this.objectModifyListener_ = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ClientWizardWidget.this.serviceImpl_.getText().indexOf(58) > 0) {
                    ClientWizardWidget.this.timer_ = Timer.newInstance(ClientWizardWidget.this.timer_, Display.getCurrent(), ClientWizardWidget.this);
                    ClientWizardWidget.this.timer_.startTimer();
                } else {
                    ClientWizardWidget.this.run();
                }
            }
        };
        this.serviceImpl_.addModifyListener(this.objectModifyListener_);
        this.browseButton_ = utils.createPushButton(typeComposite, ConsumptionUIMessages.BUTTON_BROWSE, ConsumptionUIMessages.TOOLTIP_WSWSCEN_BUTTON_BROWSE_IMPL, null);
        this.browseButton_.addSelectionListener((SelectionListener)new WSDLBrowseListener());
        utils.createHorizontalSeparator(parent, 1);
        Composite clientComposite = utils.createComposite(parent, 1, 0, 0);
        this.clientWidget_ = new WebServiceClientTypeWidget(true);
        this.clientWidget_.addControls(clientComposite, statusListener);
        Composite buttonGroup = utils.createComposite(clientComposite, 1);
        this.monitorService_ = utils.createCheckbox(buttonGroup, ConsumptionUIMessages.CHECKBOX_MONITOR_WEBSERVICE, ConsumptionUIMessages.TOOLTIP_PWPR_CHECKBOX_MONITOR_SERVICE, this.INFOPOP_WSWSCEN_CHECKBOX_MONITOR_SERVICE);
        if (this.getResourceContext().isOverwriteFilesEnabled()) {
            Label prefSeparator = utils.createHorizontalSeparator(parent, 1);
            prefSeparator.setText("File Options");
            Composite prefButtonPanel = utils.createComposite(parent, 1);
            this.overwriteButton_ = utils.createCheckbox(prefButtonPanel, ConsumptionUIMessages.CHECKBOX_OVERWRITE_FILES, ConsumptionUIMessages.TOOLTIP_WSWSCEN_BUTTON_OVERWRITE_FILES, this.INFOPOP_WSWSCEN_CHECKBOX_OVERWRITE);
            this.overwriteButton_.setSelection(this.getResourceContext().isOverwriteFilesEnabled());
            this.overwriteButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClientWizardWidget.this.getResourceContext().setOverwriteFilesEnabled(ClientWizardWidget.this.overwriteButton_.getSelection());
                }
            });
        }
        return this;
    }

    public void setResourceContext(ResourceContext context) {
        this.resourceContext_ = context;
    }

    public ResourceContext getResourceContext() {
        if (this.resourceContext_ == null) {
            this.resourceContext_ = WebServicePlugin.getInstance().getResourceContext();
        }
        return this.resourceContext_;
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
        this.clientWidget_.setTypeRuntimeServer(ids);
    }

    public void setClientProjectName(String name) {
        this.clientWidget_.setClientProjectName(name);
    }

    public void setClientEarProjectName(String name) {
        this.clientWidget_.setClientEarProjectName(name);
    }

    public void setClientComponentType(String name) {
        this.clientWidget_.setClientComponentType(name);
    }

    public void setClientNeedEAR(boolean b) {
        this.clientWidget_.setClientNeedEAR(b);
    }

    public String getClientRuntimeId() {
        return this.clientWidget_.getClientRuntimeId();
    }

    public String getClientEarProjectName() {
        return this.clientWidget_.getClientEarProjectName();
    }

    public String getClientProjectName() {
        return this.clientWidget_.getClientProjectName();
    }

    public String getClientComponentType() {
        return this.clientWidget_.getClientComponentType();
    }

    public boolean getClientNeedEAR() {
        return this.clientWidget_.getClientNeedEAR();
    }

    public void setWebServiceURI(String uri) {
        this.webServiceURI_ = uri;
    }

    public void externalize() {
        super.externalize();
        if (this.getClientTypeRuntimeServer() != null) {
            this.serviceImpl_.storeWidgetHistory(this.getClientTypeRuntimeServer().getTypeId());
        }
    }

    public void internalize() {
        this.serviceImpl_.removeModifyListener(this.objectModifyListener_);
        if (this.webServiceURI_ != null && this.webServiceURI_.length() != 0) {
            this.serviceImpl_.setText(this.webServiceURI_);
        }
        if (this.getClientTypeRuntimeServer() != null) {
            this.serviceImpl_.restoreWidgetHistory(this.getClientTypeRuntimeServer().getTypeId());
        }
        this.serviceImpl_.addModifyListener(this.objectModifyListener_);
        EclipseIPath2URLStringTransformer transformer = new EclipseIPath2URLStringTransformer();
        this.webServiceURI_ = (String)transformer.transform(this.webServiceURI_);
    }

    public void setProject(IProject project) {
        this.project_ = project;
    }

    public void setComponentName(String name) {
        this.componentName_ = name;
    }

    public String getWebServiceURI() {
        return this.webServiceURI_;
    }

    public String getWsdlURI() {
        return this.getWebServiceURI();
    }

    public IProject getProject() {
        return this.project_;
    }

    public String getComponentName() {
        return this.componentName_;
    }

    public WebServicesParser getWebServicesParser() {
        return WSDLParserFactory.getWSDLParser();
    }

    public void setWebServicesParser(WebServicesParser parser) {
        this.parser_ = this.getWebServicesParser();
        this.clientWidget_.setWebServicesParser(this.parser_);
    }

    public TypeRuntimeServer getClientTypeRuntimeServer() {
        return this.clientWidget_.getTypeRuntimeServer();
    }

    public void setInstallClient(Boolean install) {
        this.clientWidget_.setInstallClient(install);
    }

    public Boolean getInstallClient() {
        return this.clientWidget_.getInstallClient();
    }

    public Boolean getTestService() {
        return this.clientWidget_.getTestClient();
    }

    public void setTestService(Boolean value) {
        this.clientWidget_.setTestClient(value);
    }

    public int getClientGeneration() {
        return this.clientWidget_.getClientGeneration();
    }

    public void setClientGeneration(int value) {
        this.clientWidget_.setClientGeneration(value);
    }

    public void setDevelopClient(boolean develop) {
        this.clientWidget_.setDevelopClient(develop);
    }

    public boolean getDevelopClient() {
        return this.clientWidget_.getDevelopClient();
    }

    public void setAssembleClient(boolean assemble) {
        this.clientWidget_.setAssembleClient(assemble);
    }

    public boolean getAssembleClient() {
        return this.clientWidget_.getAssembleClient();
    }

    public void setDeployClient(boolean deploy) {
        this.clientWidget_.setDeployClient(deploy);
    }

    public boolean getDeployClient() {
        return this.clientWidget_.getDeployClient();
    }

    public void setStartClient(Boolean start) {
        this.clientWidget_.setStartClient(start);
    }

    public Boolean getStartClient() {
        return this.clientWidget_.getStartClient();
    }

    public Boolean getMonitorService() {
        return new Boolean(this.monitorService_.getSelection());
    }

    public void setMonitorService(Boolean value) {
        this.monitorService_.setSelection(value.booleanValue());
    }

    public IStatus getStatus() {
        this.validObjectSelection_ = false;
        IStatus missingFieldStatus = this.checkMissingFieldStatus();
        if (missingFieldStatus.getSeverity() == 4) {
            return missingFieldStatus;
        }
        IStatus invalidServiceImplStatus = this.checkServiceImplTextStatus();
        if (invalidServiceImplStatus.getSeverity() == 4) {
            return invalidServiceImplStatus;
        }
        IStatus possibleErrorStatus = this.checkErrorStatus();
        if (possibleErrorStatus.getSeverity() == 4) {
            return possibleErrorStatus;
        }
        IStatus possibleWarningStatus = this.checkWarningStatus();
        if (possibleWarningStatus.getSeverity() == 2) {
            return possibleWarningStatus;
        }
        this.validationState_ = 0;
        this.clientWidget_.setValidationState(0);
        return Status.OK_STATUS;
    }

    private IStatus checkMissingFieldStatus() {
        if (this.validationState_ == 1 && this.serviceImpl_.getText().trim().length() == 0) {
            return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_NO_SERVICE_SELECTION, (Object[])new String[]{ConsumptionUIMessages.LABEL_WEBSERVICEIMPL}));
        }
        IStatus clientMissingFieldsStatus = this.clientWidget_.checkMissingFieldStatus();
        if (clientMissingFieldsStatus.getSeverity() == 4) {
            return clientMissingFieldsStatus;
        }
        return Status.OK_STATUS;
    }

    private IStatus checkErrorStatus() {
        IStatus clientSideErrorStatus = this.clientWidget_.checkErrorStatus();
        if (clientSideErrorStatus.getSeverity() == 4) {
            return clientSideErrorStatus;
        }
        return Status.OK_STATUS;
    }

    private IStatus checkWarningStatus() {
        IStatus clientWarningStatus = this.clientWidget_.checkWarningStatus();
        if (clientWarningStatus.getSeverity() == 2) {
            return clientWarningStatus;
        }
        return Status.OK_STATUS;
    }

    private IStatus checkServiceImplTextStatus() {
        String fieldText = this.serviceImpl_.getText().trim();
        if (this.wsdlValidatorWidget_ == null) {
            this.wsdlValidatorWidget_ = new WSDLSelectionWidgetWrapper();
        }
        this.validObjectSelection_ = this.wsdlValidatorWidget_.validate(fieldText);
        if (!this.validObjectSelection_) {
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_INVALID_SERVICE_DEF);
        }
        return Status.OK_STATUS;
    }

    private void callObjectTransformation(IProject project, String componentName, String wsdlURI) {
        WSDLSelectionOutputCommand wsdlOutputCommand = new WSDLSelectionOutputCommand();
        wsdlOutputCommand.setComponentName(componentName);
        wsdlOutputCommand.setProject(project);
        wsdlOutputCommand.setWsdlURI(wsdlURI);
        wsdlOutputCommand.setTestService(this.getTestService());
        wsdlOutputCommand.setWebServicesParser(this.getWebServicesParser());
        wsdlOutputCommand.execute(null, null);
        this.setComponentName(wsdlOutputCommand.getComponentName());
        this.setProject(wsdlOutputCommand.getProject());
        this.setWebServicesParser(wsdlOutputCommand.getWebServicesParser());
        this.setWebServiceURI(wsdlOutputCommand.getWsdlURI());
    }

    private class WSDLBrowseListener
    implements SelectionListener {
        private WSDLBrowseListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            ClientWizardWidget.this.wsdlDialog_ = new WSDLSelectionDialog(Display.getCurrent().getActiveShell(), new PageInfo(ConsumptionUIMessages.DIALOG_TITILE_SERVICE_IMPL_SELECTION, "", new WidgetContributorFactory(){

                public WidgetContributor create() {
                    return new WSDLSelectionWidgetWrapper();
                }
            }));
            ClientWizardWidget.this.wsdlDialog_.setComponentName(ClientWizardWidget.this.getComponentName());
            ClientWizardWidget.this.wsdlDialog_.setProject(ClientWizardWidget.this.getProject());
            ClientWizardWidget.this.wsdlDialog_.setWebServiceURI(ClientWizardWidget.this.serviceImpl_.getText());
            int result = ClientWizardWidget.this.wsdlDialog_.open();
            if (result == 0) {
                ClientWizardWidget.this.serviceImpl_.removeModifyListener(ClientWizardWidget.this.objectModifyListener_);
                ClientWizardWidget.this.serviceImpl_.setText(ClientWizardWidget.this.wsdlDialog_.getDisplayableSelectionString());
                ClientWizardWidget.this.serviceImpl_.addModifyListener(ClientWizardWidget.this.objectModifyListener_);
                ClientWizardWidget.this.callObjectTransformation(ClientWizardWidget.this.project_, ClientWizardWidget.this.wsdlDialog_.getComponentName(), ClientWizardWidget.this.wsdlDialog_.getWebServiceURI());
                ClientWizardWidget.this.validationState_ = 1;
                ClientWizardWidget.this.clientWidget_.setValidationState(1);
                ClientWizardWidget.this.statusListener_.handleEvent(null);
            }
            ClientWizardWidget.this.wsdlDialog_ = null;
        }
    }
}

